module regular_motor(
						input logic clk, reset,
						input logic [3:0] speed, // 0 is stop; speed level from 1 to 8
						input logic stop, //stop signal for emergency stop that will feed from ultrasonic sensors
						input logic direction, //forward and backward
						output logic motor_c1, motor_c2, motor_en //for motor pins 
					);	
	

	parameter 	MAX_SPEED_LV = 8; //from 0 to 8. (should <= 15)
					//MAX_SPEED_LV_P_ONE = MAX_SPEED_LV + 1'b1; //used to optimized circuit, no need to change
	
	enum logic {FORWRAD,BACKWARD} dir; 
	//enum logic [3:0] {STOP, SPEED1, SPEED2, SPEED3, SPEED4, SPEED5, SPEED6, SPEED7, SPEED8} spd;
	
	//convert input signals to what we use and do verifying
	assign dir = (direction == 1'b1) ? FORWRAD : BACKWARD; 
	
	
	
	logic [14:0] counter_10000;
	always_ff @ (posedge clk)
	begin
		if(reset) begin 
			counter_10000 <= 0; 
		end else begin
			if (counter_10000 < 10000)
				counter_10000 <= counter_10000 + 1'b1;
			else
				counter_10000 <= 1'b0;
		end
	end
	
	logic tick;
	assign tick = (counter_10000 == 10000)? 1'b1: 1'b0;
	
	logic [3:0] counter; //count pulse width
	always_ff @ (posedge clk)
	begin
		if(reset) begin 
			counter <= 0; 
		end else begin
			if(tick == 1'b1) begin
				if (counter < MAX_SPEED_LV)
					counter <= counter + 1'b1;
				else
					counter <= 1'b0;
			end 
		end
	end
	
	//motor control
	always_comb begin
		motor_c1 = 1'b0;
		motor_c2 = 1'b0;
		
		if(!stop) begin			
			if(dir == FORWRAD) 
				motor_c1 = 1'b1;
			else
				motor_c2 = 1'b1;
		end
	end
	
	assign motor_en = (speed == 0 || stop)? 1'b0 :
							(counter <= speed) ? 1'b1 : 1'b0;
	
endmodule
