module ultrasonic(
						input logic clk,reset,
						input logic echo,
						
						//Used by correct_distance_module that every 
						//ultrasonic can be controlled when to measure
						//distance.(In order to avoid conflict of multi
						//ultrasonic sensors measure at the same time)
						//When counter of a ultrasonic is zero, it will
						//wait until pause = 0 to start. Once start, it
						//doesn't care about pause signal. 
						//When finished, the counter reset to zero and 
						//raise finished singal until start to count again.
						input logic pause,  
						output logic finished,
						
						output logic trigger,
						output logic [19:0] distance);
	
	parameter COUNT_INTERVAL = 26'd3_500_000;
	
	logic [19:0] distance_counter; //temp distance that will be counted depend on echo width
	logic [25:0] counter;
	
	always_ff @ (posedge clk)
	begin
		if(reset) begin 
			counter <= 0; 
			distance <= 0; 
			distance_counter <=0; 
		end else begin
			if(counter == 0) begin //when counter == 0, only start counting when pause == 0
				if(~pause) begin
					counter <= counter + 1;
				end else begin
					counter <= counter;
				end
			end else if (counter >= COUNT_INTERVAL) begin //reach counter maximum, set distance and reset counter to zero
				distance <= distance_counter;
				counter <= 0;
				distance_counter <= 0;
			end else if (counter >= 26'd510) begin //after trigger deactive a while, start to monitor echo and count width
				counter <= counter + 1;
				if (echo) begin
					distance_counter <= distance_counter + 1;
				end
			end else begin
				counter <= counter + 1;
			end
		end
	end
	
	//trigger
	always_ff @ (posedge clk) begin
		if (counter > 0 && counter < 26'd502) //1 ~ 501 (0 might be in pause, shouldn't send trigger)
			trigger <= 1;
		else
			trigger <= 0;
	end
	
	//finished singnal
	assign finished = (counter == 0) ? 1'b1 : 1'b0;
	
endmodule
