//F: Front, B: Back, R: Right
//e.g. FR: on the right corner of the front
//e.g. RF: in the front of right side
module correct_distance_qsys(
			input logic				clk,
			input logic 	  		reset,
			output logic [31:0]	readdata, // Only accept 8, 16, 32, 64,... bits;
			input logic  [1:0]  	address, //00:FR, 01:RF, 10:RB, 11:BR
			input logic 	  		read,
			input logic   			chipselect,
			
			//ultrasonic part
			input logic	 [3:0]	echo, //echo[0]:FR, echo[1]:RF, etc. 
			output logic [3:0]	trigger,
			
			output logic 			stop); //for emergency stop that directly send to motors 


   
	// ======================= Ultrasonic ========================================
	
	logic [19:0] us_distance_000, us_distance_001, us_distance_010, us_distance_011;
	
	logic [3:0] pause;
	
	logic [3:0] finished;
	
	
	ultrasonic us_000(	.clk(clk), 
								.reset(reset), 
								.pause(pause[0]),  
								.finished(finished[0]),
								.echo(echo[0]), 
								.trigger(trigger[0]), 
								.distance(us_distance_000));
	
	ultrasonic us_001(	.clk(clk), 
								.reset(reset), 
								.pause(pause[1]),  
								.finished(finished[1]),
								.echo(echo[1]), 
								.trigger(trigger[1]), 
								.distance(us_distance_001));
								
	ultrasonic us_010(	.clk(clk), 
								.reset(reset), 
								.pause(pause[2]),  
								.finished(finished[2]),
								.echo(echo[2]), 
								.trigger(trigger[2]), 
								.distance(us_distance_010));
								
	ultrasonic us_011(	.clk(clk), 
								.reset(reset), 
								.pause(pause[3]),  
								.finished(finished[3]),
								.echo(echo[3]), 
								.trigger(trigger[3]), 
								.distance(us_distance_011));
	
	always_comb begin
		
		readdata = 32'b0; //default
		
		if(chipselect && read) begin
			case(address)
				2'b00: readdata = {12'h000, us_distance_000};
		
				2'b01: readdata = {12'h000, us_distance_001};
				
				2'b10: readdata = {12'h000, us_distance_010};
		
				2'b11: readdata = {12'h000, us_distance_011};

			endcase
		end
	end
	
	
	//control ultrasonic sensors by pause signals
	logic [1:0] pointer; //indicate which ultrasonic sensor is working now
	always_ff @ (posedge clk) begin
		if(reset) begin
			pause <= 4'b1110;
			pointer <= 2'd0;
		end else begin
			if(~pause[pointer])begin
				pause[pointer] <= 1'b1;
			end else begin
				if(finished[pointer]) begin //done, change to next one
					pause[pointer_next] <= 1'b0;
					pointer <= pointer_next;
				end
			end
		end
	end
	
	
//	always_ff @ (posedge clk) begin
//		if(reset) begin
//			
//		end else begin
//			if(finished[pointer]) begin
//				
//			end
//		end
//	end
	
	//pointer + 1
	logic [1:0] pointer_next;
	assign pointer_next = (pointer == 2'd3) ? 2'd0 : pointer + 1'b1;
	
		
endmodule
