function [ phi_out,out,angle_p,angle_n ] = overhead(myCarLength,myCarWidth,theta,parkPitch,radius)

% This is a function to utilize an aggressive parking algorithm

phi_out = atan(myCarLength/(2*(radius + myCarWidth/2)));
phi_in = atan(myCarLength/(2*(radius - myCarWidth/2)));
rin_p = sqrt((myCarLength/2)^2 + (radius - myCarWidth/2)^2);
rout_p = sqrt((myCarLength/2)^2 + (radius + myCarWidth/2)^2);
phi_p = phi_out + theta;
A = (parkPitch + rin_p*(cos(phi_in - theta) - cos(phi_in)))/rout_p;
assignin('base','rout_p',rout_p);
assignin('base','A',A);
assignin('base','phi_p',phi_p);

b = -(A+cos(phi_p))*cos(phi_p);
c = (A+cos(phi_p))^2-(sin(phi_p))^2;
a = 1;
angle_p = acos((-b+sqrt(b^2-a*c))/a);
angle_n = acos((-b-sqrt(b^2-a*c))/a);
assignin('base','b',b);
assignin('base','c',c);


out = A*rout_p*cot(theta) - rout_p*((sin(phi_p) - sin(phi_p - angle_p)));
end






