% This is a function to plot a car with a given postion, width, length, and
% direction. It also output the coordinates of the center and four corners
% of the car

function [carData] = carPlot(centerX,centerY,direction,width,length)
colordef white;
rotationMatrix = [cos(direction), -sin(direction); +sin(direction), cos(direction)];

RFCorner = 0.5.*[ width, length];
LFCorner = 0.5.*[ -width, length];
RRCorner = 0.5.*[ width, -length];
LRCorner = 0.5.*[ -width, -length];

RFCorner = (rotationMatrix*RFCorner')';
LFCorner = (rotationMatrix*LFCorner')';
RRCorner = (rotationMatrix*RRCorner')';
LRCorner = (rotationMatrix*LRCorner')';

carData = [centerX,centerY,RFCorner+[centerX,centerY],LFCorner+[centerX,centerY],RRCorner+[centerX,centerY],LRCorner+[centerX,centerY]];


patch ([LRCorner(1),RRCorner(1),RFCorner(1),LFCorner(1)] + centerX...
      ,[LRCorner(2),RRCorner(2),RFCorner(2),LFCorner(2)] + centerY...
      ,[0,0,1],'EraseMode','none');
  

end
