cla;
% This is a model for parallel auto parking, for more detailed explanation,
% please refer to the algorithm part in the final report.

% Parameter for world Setting
global LOT_BACK; % the coordinate of the back side of the parking lot
global LOT_WIDTH; % the width of the parking lot
global LOT_LENGTH; % The length of the parking lot
global ST_LENGTH; % length of street
global ST_WITDTH; % width of street
global CAR_LENGTH; % length of the car
global CAR_WIDTH; % width of the car

CAR_LENGTH = 40; 
CAR_WIDTH = 20;
LOT_BACK = 40;
LOT_WIDTH = 25;
LOT_LENGTH = 2*CAR_LENGTH; % Assume the parking is twice the length of the car
ST_LENGTH = 200;
ST_WITDTH = 80;


% Parameter for My Car




% Initial Position setting


% The angle between y-axis and the direction of the car ( facing front  = > theta = 0)
theta = 0; 

% parkPitch is the distance between the car and the wall 
parkPitch = 10; 

% iniCarY = initial Car Y coordiante
iniCarY = LOT_LENGTH + LOT_BACK; 

% carCenter is a two dimentional vector that stores the coordinate of the
% curren car position. We initially set that the back side of the car is
% align with the front side of the parking lot, but it can be set to any
% value and will not affect the parking.
carCenter = [0 + LOT_WIDTH + parkPitch, iniCarY] +  0.5.*[CAR_WIDTH, CAR_LENGTH]; 

% Carplot is a function to plot the car
carPlot(carCenter(1),carCenter(2),theta,CAR_WIDTH,CAR_LENGTH); 

%world is a function used to plot the street and wall.
world(LOT_WIDTH,LOT_BACK,LOT_LENGTH,ST_WITDTH,ST_LENGTH); % Plot the world ( street and wall)


% Setting the turninig radius of the car
radius = 40; 

% Calculate some intermediate value to put in the formular after. This can make the formula looks more tidy 
lotFront = LOT_BACK + LOT_LENGTH; % The Y-coordinate of the front of the parking lot
lotRear = LOT_BACK; % The Y- coordinate of the rear of the parking lot
inRadius = radius - 0.5* CAR_WIDTH; % turning radius of the  inner side of the car


% Calculate the the angle to turn when doing parallel parking, the explanation is documented in the final report. 
angleToTurn = acos((radius  - 0.5*(0.5*CAR_WIDTH + parkPitch+radius+LOT_WIDTH-sqrt((radius+0.5*CAR_WIDTH)^2+(0.5*CAR_LENGTH)^2)))/radius);

% overhead is an aggresive algorithm to make the parking car precisely not
% hit the wall, it generate an output "out" and put it into distance to
% move
[phi,out,angle_p,angle_n] = overhead(CAR_LENGTH,CAR_WIDTH,angleToTurn,parkPitch,radius);

% Calculate the distance the car needs to move before starting to turn and
% parking
distanceToMove = sqrt(inRadius^2 - (inRadius - parkPitch)^2) + lotFront - carCenter(2) - out   ;

% straight is a function that makes the car going forward or backward while
% you can choose the distance you want, minus value correspond to move backward 
% further it returns a matrix carTrack that record the track of the
% car (coordiante)
[carCenter(1),carCenter(2),theta,carTrack]...
 = straight(carCenter(1),carCenter(2),theta,distanceToMove,CAR_WIDTH,CAR_LENGTH,LOT_WIDTH,LOT_BACK,LOT_LENGTH,ST_WITDTH,ST_LENGTH);

% store the the data into matrix carTrajectory
carTraject = carTrack;

% turn is a function that makes the car turning while you can choose the
% angle to turn, positive radius corresponds to turn, and positive
% angle corresponds to go counter clockwise, also generate carTrack
[carCenter(1),carCenter(2),theta,carTrack]...
=turn(carCenter(1),carCenter(2),theta,-(angleToTurn),radius,CAR_WIDTH,CAR_LENGTH,LOT_WIDTH,LOT_BACK,LOT_LENGTH,ST_WITDTH,ST_LENGTH);

% store the the data into matrix carTrajectory
carTraject = [carTraject;carTrack];


% similarly from the code above, but this represent the second arc.
[carCenter(1),carCenter(2),theta,carTrack]...
=turn(carCenter(1),carCenter(2),theta,angleToTurn,-radius,CAR_WIDTH,CAR_LENGTH,LOT_WIDTH,LOT_BACK,LOT_LENGTH,ST_WITDTH,ST_LENGTH);

% store the the data into matrix carTrajectory
carTraject = [carTraject;carTrack];


hold on;

% the program has utilize one straight and two curvy move to complete the
% parallel parking. The trajectory of the car has been stored in the matrix
% carTrajectory. carTrajectory is a matrix with 10 columes, storing five 2
% dimentional coordinate. The first two colume are for the center of the
% car, and the other 8 columes are for the four corners of the car.

% For example, to plot the trajectory of front-left corner of the car, use the
% following: 

plot(carTraject(:,5),carTraject(:,6),'ro');

% r means the plot it in red, o means use circle to plot















