# A Tcl script for the Qsys system console

# Start Qsys, open your soc_system.qsys file, run File->System Console,
# then execute this script by selecting it with Ctrl-E

# The System Console is described in Chapter 10 of Volume III of
# the Quartus II Handbook

# Alternately,
# system-console --project_dir=. --script=syscon-test.tcl
#
# system-console --project_dir=. -cli
#   and then "source syscon-test.tcl"

# Base addresses of the peripherals: take from Qsys
set vga_led 0x00000000
set aud_cod 0x00040000
puts "Started system-console-test-script"

# Using the JTAG chain, check the clock and reset"

set j [lindex [get_service_paths jtag_debug] 0]
open_service jtag_debug $j
puts "Opened jtag_debug"

puts "Checking the JTAG chain loopback: [jtag_debug_loop $j {1 2 3 4 5 6}]"
jtag_debug_reset_system $j

puts -nonewline "Sampling the clock: "
foreach i {1 1 1 1 1 1 1 1 1 1 1 1} {
    puts -nonewline [jtag_debug_sample_clock $j]
}
puts ""

puts "Checking reset state: [jtag_debug_sample_reset $j]"

close_service jtag_debug $j
puts "Closed jtag_debug"

# Perform bus reads and writes

set m [lindex [get_service_paths master] 0]
open_service master $m
puts "Opened master"

# Write a test pattern to the various registerforeach {r v} {0 0x20 1 0x20 2 0x05 3 0x50 4 0X20 5 0x20 30 0x1D 31 0x64} {
foreach {r v} {0 0x20 1 0x20 2 0x05 3 0x50 4 0X20 5 0x20 24 0x2E 25 0x00} {
    master_write_8 $m [expr $vga_led + $r] $v
}

foreach {r v} {0 0x00 1 0x00 2 0x23 3 0x01} {
    master_write_8 $m [expr $aud_cod + $r] $v
}
close_service master $m
puts "Closed master"




