#ifndef _VGA_PIANO_H
#define _VGA_PIANO_H

#include <linux/ioctl.h>

//holds VGA piano arguments and data
typedef struct {
  unsigned int data;
  unsigned short xcoord, ycoord, keypress, address;
} vga_piano_arg_t;

#define VGA_PIANO_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_PIANO_WRITE_DATA _IOW(VGA_PIANO_MAGIC, 1, vga_piano_arg_t *)
#define VGA_PIANO_WRITE_COORD _IOW(VGA_PIANO_MAGIC, 2, vga_piano_arg_t *)
#define VGA_PIANO_WRITE_KEYPRESS _IOW(VGA_PIANO_MAGIC, 3, vga_piano_arg_t *)

#endif
