#include <stdlib.h>
#include <pthread.h>
#include "queue.h"

struct Node {
	void *data;
	struct Node *next;
};

typedef struct Node Node;

struct Queue {
	Node *head;
	Node *tail;
	pthread_mutex_t queue_mutex;
};

typedef struct Queue Queue;

Queue *initQueue() {
	Queue *queue = malloc(sizeof(Queue));
    queue->head = NULL;
    queue->tail = NULL;
    pthread_mutex_init(&queue->queue_mutex, NULL);
    return queue;
}

void destroyQueue(Queue *queue) {
	Node *node = queue->head;

	while (node != NULL) {
		Node *next = node->next;
		free(node);
		node = next;
	}

	pthread_mutex_destroy(&queue->queue_mutex);
	free(queue);
}

void push(Queue *queue, void *data) {
	pthread_mutex_lock(&queue->queue_mutex);
	Node *node = malloc(sizeof(Node));
	node->data = data;
	node->next = NULL;

	if (queue->head == NULL) {
		queue->head = node;
	}
	else {
		queue->tail->next = node;
	}
	
	queue->tail = node;
	pthread_mutex_unlock(&queue->queue_mutex);
}

void *pop(Queue *queue) {
	if (queue->head == NULL) {
		return NULL;
	}

	Node *node = queue->head;
	void *data = node->data;

	if (queue->tail == node) { // node is only node in queue, acquire tail lock
		pthread_mutex_lock(&queue->queue_mutex);

		if (node->next == NULL) { // now that we have lock, check if it is still only node
			queue->tail = NULL;
			queue->head = NULL;
		}
		else {
			queue->head = node->next;
		}
		
		pthread_mutex_unlock(&queue->queue_mutex);
	}
	else {
		queue->head = node->next;
	}

	free(node);
	return data;
}
