#include <stdio.h>
#include <fcntl.h>
#include "audio_driver.h"
#include "queue.h"
#include <pthread.h>

FILE *audio_files[12];
int audio_fd;
audio_arg_t aa;
extern pthread_mutex_t key_mutex;
queue *audio_queue;

void send_to_audio_thread(unsigned int key) {
	key -= 1; // let interface present keys from 1 - 12
	if (key < 12) {
		push(audio_queue, audio_files[key]);
	}
}

void poll_buffer() {
	// get device status from driver
	if (ioctl(audio_fd, AUDIO_READ_DATA, &aa)) 
		perror("ioctl(AUDIO_READ_DATA) failed");
	//aa.data contains the signal
}

void write_audio_data(short *data, int length) {
	// send audio data frame to device
	aa.data = data;
	aa.length = length;
	if (ioctl(audio_fd, AUDIO_WRITE_DATA, &aa)) 
		perror("ioctl(AUDIO_WRITE_DATA) failed");
}

int init_audio() {
	// open audio driver
	static const char file[] = "/dev/audio";
	if ( (audio_fd = open(file, O_RDWR)) == -1) {
		fprintf(stderr, "could not open %s\n", file);
		return -1;
	}
	
	char filename[100];
	int i;
	
	// open 12 key audio files
	for (i = 1; i < 13; i++) {
		sprintf(filename, "raw_audio/key%d.raw", i);
		FILE *audio = fopen(filename, "r");
		fseek(audio, 0L, SEEK_END);
		int sz = ftell(audio);
		rewind(audio);
		printf("opening file of length %d\n", sz);
		if (!audio) {
			perror("could not open file\n");
			return -1;
		}
		audio_files[i-1] = audio;
	}
	
	// thread safe queue used to send audio files to audio thread
	audio_queue = initQueue();
	return 0;
}

void play_audio(FILE *note_file) {
	short data[1024];
	size_t read;
	
	// read from file, loop until the file is done or the buffer is full
	while ((read = fread(data, 2, 1024, note_file)) > 0) {
		do { // poll until buffer is open in device
			poll_buffer();
		} while (aa.data == 3);
		
		write_audio_data(data, (unsigned int)read);		
		
		// check if we should stop current file and start playing new one
		void *queue_val = pop(audio_queue);
		if (queue_val != NULL) {
			rewind(note_file);
			note_file = (FILE *)queue_val;
		}
	}

	rewind(note_file);
}


// starting point of audio thread
void audio_thread_fn(void *arg) {
  	while(1) { // loop, popping off of queue, play if something there
  		void *queue_val = pop(audio_queue);
		if (queue_val != NULL) {
		  	FILE *note_file = (FILE *)queue_val;
			play_audio(note_file);
		}
	}
}
