extern module VGA_LED(input logic        clk,
		input logic 	  reset,
		input logic [31:0]  writedata,
		input logic 	  write,
		input 		  chipselect,
		input logic [15:0]  address,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
		output logic 	  VGA_SYNC_n);

module testbench;

	logic clk, reset, write, chipselect, VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n;
	logic [31:0]  writedata;
	logic [15:0]  address;
	logic [7:0] VGA_R, VGA_G, VGA_B;
	
	VGA_LED vga_led(.*);
	
	initial begin // start clock
		clk = '0;
		forever #10ns clk = ~clk;
	end
	
	initial begin // send reset
		reset = '0;
		#10ns reset = '1;
		#20ns reset = '0;
	end
	
	initial begin
		write = '0;
		chipselect = '0;
		writedata = '0;
		address = '0;
	end
	
endmodule
