extern module audio_effects (
    input  sample_req,
    output [15:0] audio_output,
    //input  [3:0]  control
	 
	 //Inputs from the HPS
	 input hps_clk,
	 input reset,
	 input chipselect,
	 input [11:0] address,
	 input [15:0] data,
	 input write,
	 
	 output [3:0] LEDS
);

module audio_testbench;

	logic hps_clk, reset, sample_req, chipselect, write;
	logic [15:0] audio_output, data;
	logic [11:0] address;
	logic [3:0] LEDS;
	
	audio_effects effects (.*);
	
	initial begin // start clock
		hps_clk = '0;
		sample_req = 0;
		forever begin
			#10ns hps_clk = ~hps_clk;
			sample_req = ~sample_req;
		end
	end
	
	initial begin // send reset
		reset = '0;
		#10ns reset = '1;
		#20ns reset = '0;
	end
	
	initial begin
		chipselect = 1;
		write = 1;
		data = '0;
		address = '0;
		forever begin
			#20ns if (address == 11'd1024)
				address = '0;
			else
				address = address + 1;
			data = data + 1;
			
		end
	end

endmodule