package laptop;
/******************************************************************************\
* Copyright (C) 2012-2013 Leap Motion, Inc. All rights reserved.               *
* Leap Motion proprietary and confidential. Not for distribution.              *
* Use subject to the terms of the Leap Motion SDK Agreement available at       *
* https://developer.leapmotion.com/sdk_agreement, or another agreement         *
* between Leap Motion and you, your company or other organization.             *
\******************************************************************************/

import java.io.IOException;
import java.lang.Math;
import java.util.concurrent.TimeUnit;

import com.leapmotion.leap.*;
import com.leapmotion.leap.Gesture.State;
import java.nio.ByteBuffer; // for converting int array to byte array
import java.nio.IntBuffer;

// Networking imports
import java.net.DatagramSocket;
import java.net.DatagramPacket;
import java.net.InetAddress;

class LeapSender {
	
	final static int SIZE = 3;
	
    public static void main(String[] args) throws IOException {
      
    	
        Controller controller = new Controller();
        int[] arrayToSend = new int[SIZE];
        
        while(true) {
        	try {
				TimeUnit.MILLISECONDS.sleep(30);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				break;
			}
        	Frame frame = controller.frame();
        	System.out.println("Frame id: " + frame.id()
                    + ", timestamp: " + frame.timestamp()
                    + ", hands: " + frame.hands().count()
                    + ", fingers: " + frame.fingers().count());

        	if (!frame.hands().isEmpty()) {
        		// Get the first hand
        		Hand hand = frame.hands().get(0);
        		
        		FingerList fingers = hand.fingers();
        		if(!fingers.isEmpty()) {
        			Finger finger = fingers.get(0);
        			Vector fingerPos = finger.stabilizedTipPosition();
        			
        			int xPosition;
        			int yPosition;
        			int yVelocity;
        			
        			xPosition = (int)fingerPos.getX();
        			yPosition = (int)fingerPos.getY();
        			yVelocity = (int)finger.tipVelocity().getY();
        			
        			arrayToSend[0] = xPosition;
        			arrayToSend[1] = yPosition;
        			arrayToSend[2] = yVelocity;

        			byte[] toSend = intArray2ByteArray(arrayToSend);
        			sendData(toSend);
        		}
        			
        		/*	
        		 * Code to include later perhaps if we modify our design to include multiple fingers
        		 * 
        		
        		int handCount = 1;
        		for(Hand hand: frame.hands()) {
	        		// Check if the hand has any fingers
        			System.out.println("Hand " + handCount);
        			System.out.println("Hand Time Visible: " + hand.timeVisible());
	        		FingerList fingers = hand.fingers();
	        		if (!fingers.isEmpty()) {	        			
	        			int i = 1;
	        			// Print out the finger positions
	        			for (Finger finger : fingers) {
	        				System.out.println("Finger " + i);
	        				Vector tipPos = finger.stabilizedTipPosition();
	        				System.out.println("X: " + tipPos.getX());
	        				Vector tipVel = finger.tipVelocity();
	        				System.out.println("Y velocity: " + tipVel.getY());
	        				i++;
	        			}
	        		}
	        		handCount++;
        		}
        		*/
        	}
        }
    }

    // takes byte array of x pos, y pos, y velocity
    static void sendData(byte[] data) throws IOException {
		DatagramSocket socket = new DatagramSocket(9876);
		InetAddress IPAddress = InetAddress.getByName("192.168.1.102");
		DatagramPacket packet = new DatagramPacket(data, data.length, IPAddress, 4000);
		socket.send(packet);
		socket.close(); 
    }

    static byte [] intArray2ByteArray(int[] data){
		ByteBuffer byteBuffer = ByteBuffer.allocate(data.length*4);
		IntBuffer intBuffer = byteBuffer.asIntBuffer();
		intBuffer.put(data);
		byte[] output = byteBuffer.array();
		return output;
    }
}
