library verilog;
use verilog.vl_types.all;
entity lab3_hps_0 is
    generic(
        F2S_Width       : integer := 2;
        S2F_Width       : integer := 2
    );
    port(
        h2f_rst_n       : out    vl_logic;
        f2h_axi_clk     : in     vl_logic;
        f2h_AWID        : in     vl_logic_vector(7 downto 0);
        f2h_AWADDR      : in     vl_logic_vector(31 downto 0);
        f2h_AWLEN       : in     vl_logic_vector(3 downto 0);
        f2h_AWSIZE      : in     vl_logic_vector(2 downto 0);
        f2h_AWBURST     : in     vl_logic_vector(1 downto 0);
        f2h_AWLOCK      : in     vl_logic_vector(1 downto 0);
        f2h_AWCACHE     : in     vl_logic_vector(3 downto 0);
        f2h_AWPROT      : in     vl_logic_vector(2 downto 0);
        f2h_AWVALID     : in     vl_logic;
        f2h_AWREADY     : out    vl_logic;
        f2h_AWUSER      : in     vl_logic_vector(4 downto 0);
        f2h_WID         : in     vl_logic_vector(7 downto 0);
        f2h_WDATA       : in     vl_logic_vector(63 downto 0);
        f2h_WSTRB       : in     vl_logic_vector(7 downto 0);
        f2h_WLAST       : in     vl_logic;
        f2h_WVALID      : in     vl_logic;
        f2h_WREADY      : out    vl_logic;
        f2h_BID         : out    vl_logic_vector(7 downto 0);
        f2h_BRESP       : out    vl_logic_vector(1 downto 0);
        f2h_BVALID      : out    vl_logic;
        f2h_BREADY      : in     vl_logic;
        f2h_ARID        : in     vl_logic_vector(7 downto 0);
        f2h_ARADDR      : in     vl_logic_vector(31 downto 0);
        f2h_ARLEN       : in     vl_logic_vector(3 downto 0);
        f2h_ARSIZE      : in     vl_logic_vector(2 downto 0);
        f2h_ARBURST     : in     vl_logic_vector(1 downto 0);
        f2h_ARLOCK      : in     vl_logic_vector(1 downto 0);
        f2h_ARCACHE     : in     vl_logic_vector(3 downto 0);
        f2h_ARPROT      : in     vl_logic_vector(2 downto 0);
        f2h_ARVALID     : in     vl_logic;
        f2h_ARREADY     : out    vl_logic;
        f2h_ARUSER      : in     vl_logic_vector(4 downto 0);
        f2h_RID         : out    vl_logic_vector(7 downto 0);
        f2h_RDATA       : out    vl_logic_vector(63 downto 0);
        f2h_RRESP       : out    vl_logic_vector(1 downto 0);
        f2h_RLAST       : out    vl_logic;
        f2h_RVALID      : out    vl_logic;
        f2h_RREADY      : in     vl_logic;
        h2f_lw_axi_clk  : in     vl_logic;
        h2f_lw_AWID     : out    vl_logic_vector(11 downto 0);
        h2f_lw_AWADDR   : out    vl_logic_vector(20 downto 0);
        h2f_lw_AWLEN    : out    vl_logic_vector(3 downto 0);
        h2f_lw_AWSIZE   : out    vl_logic_vector(2 downto 0);
        h2f_lw_AWBURST  : out    vl_logic_vector(1 downto 0);
        h2f_lw_AWLOCK   : out    vl_logic_vector(1 downto 0);
        h2f_lw_AWCACHE  : out    vl_logic_vector(3 downto 0);
        h2f_lw_AWPROT   : out    vl_logic_vector(2 downto 0);
        h2f_lw_AWVALID  : out    vl_logic;
        h2f_lw_AWREADY  : in     vl_logic;
        h2f_lw_WID      : out    vl_logic_vector(11 downto 0);
        h2f_lw_WDATA    : out    vl_logic_vector(31 downto 0);
        h2f_lw_WSTRB    : out    vl_logic_vector(3 downto 0);
        h2f_lw_WLAST    : out    vl_logic;
        h2f_lw_WVALID   : out    vl_logic;
        h2f_lw_WREADY   : in     vl_logic;
        h2f_lw_BID      : in     vl_logic_vector(11 downto 0);
        h2f_lw_BRESP    : in     vl_logic_vector(1 downto 0);
        h2f_lw_BVALID   : in     vl_logic;
        h2f_lw_BREADY   : out    vl_logic;
        h2f_lw_ARID     : out    vl_logic_vector(11 downto 0);
        h2f_lw_ARADDR   : out    vl_logic_vector(20 downto 0);
        h2f_lw_ARLEN    : out    vl_logic_vector(3 downto 0);
        h2f_lw_ARSIZE   : out    vl_logic_vector(2 downto 0);
        h2f_lw_ARBURST  : out    vl_logic_vector(1 downto 0);
        h2f_lw_ARLOCK   : out    vl_logic_vector(1 downto 0);
        h2f_lw_ARCACHE  : out    vl_logic_vector(3 downto 0);
        h2f_lw_ARPROT   : out    vl_logic_vector(2 downto 0);
        h2f_lw_ARVALID  : out    vl_logic;
        h2f_lw_ARREADY  : in     vl_logic;
        h2f_lw_RID      : in     vl_logic_vector(11 downto 0);
        h2f_lw_RDATA    : in     vl_logic_vector(31 downto 0);
        h2f_lw_RRESP    : in     vl_logic_vector(1 downto 0);
        h2f_lw_RLAST    : in     vl_logic;
        h2f_lw_RVALID   : in     vl_logic;
        h2f_lw_RREADY   : out    vl_logic;
        h2f_axi_clk     : in     vl_logic;
        h2f_AWID        : out    vl_logic_vector(11 downto 0);
        h2f_AWADDR      : out    vl_logic_vector(29 downto 0);
        h2f_AWLEN       : out    vl_logic_vector(3 downto 0);
        h2f_AWSIZE      : out    vl_logic_vector(2 downto 0);
        h2f_AWBURST     : out    vl_logic_vector(1 downto 0);
        h2f_AWLOCK      : out    vl_logic_vector(1 downto 0);
        h2f_AWCACHE     : out    vl_logic_vector(3 downto 0);
        h2f_AWPROT      : out    vl_logic_vector(2 downto 0);
        h2f_AWVALID     : out    vl_logic;
        h2f_AWREADY     : in     vl_logic;
        h2f_WID         : out    vl_logic_vector(11 downto 0);
        h2f_WDATA       : out    vl_logic_vector(63 downto 0);
        h2f_WSTRB       : out    vl_logic_vector(7 downto 0);
        h2f_WLAST       : out    vl_logic;
        h2f_WVALID      : out    vl_logic;
        h2f_WREADY      : in     vl_logic;
        h2f_BID         : in     vl_logic_vector(11 downto 0);
        h2f_BRESP       : in     vl_logic_vector(1 downto 0);
        h2f_BVALID      : in     vl_logic;
        h2f_BREADY      : out    vl_logic;
        h2f_ARID        : out    vl_logic_vector(11 downto 0);
        h2f_ARADDR      : out    vl_logic_vector(29 downto 0);
        h2f_ARLEN       : out    vl_logic_vector(3 downto 0);
        h2f_ARSIZE      : out    vl_logic_vector(2 downto 0);
        h2f_ARBURST     : out    vl_logic_vector(1 downto 0);
        h2f_ARLOCK      : out    vl_logic_vector(1 downto 0);
        h2f_ARCACHE     : out    vl_logic_vector(3 downto 0);
        h2f_ARPROT      : out    vl_logic_vector(2 downto 0);
        h2f_ARVALID     : out    vl_logic;
        h2f_ARREADY     : in     vl_logic;
        h2f_RID         : in     vl_logic_vector(11 downto 0);
        h2f_RDATA       : in     vl_logic_vector(63 downto 0);
        h2f_RRESP       : in     vl_logic_vector(1 downto 0);
        h2f_RLAST       : in     vl_logic;
        h2f_RVALID      : in     vl_logic;
        h2f_RREADY      : out    vl_logic;
        f2h_irq_p0      : in     vl_logic_vector(31 downto 0);
        f2h_irq_p1      : in     vl_logic_vector(31 downto 0);
        mem_a           : out    vl_logic_vector(14 downto 0);
        mem_ba          : out    vl_logic_vector(2 downto 0);
        mem_ck          : out    vl_logic;
        mem_ck_n        : out    vl_logic;
        mem_cke         : out    vl_logic;
        mem_cs_n        : out    vl_logic;
        mem_ras_n       : out    vl_logic;
        mem_cas_n       : out    vl_logic;
        mem_we_n        : out    vl_logic;
        mem_reset_n     : out    vl_logic;
        mem_dq          : inout  vl_logic_vector(31 downto 0);
        mem_dqs         : inout  vl_logic_vector(3 downto 0);
        mem_dqs_n       : inout  vl_logic_vector(3 downto 0);
        mem_odt         : out    vl_logic;
        mem_dm          : out    vl_logic_vector(3 downto 0);
        oct_rzqin       : in     vl_logic;
        hps_io_emac1_inst_TX_CLK: out    vl_logic;
        hps_io_emac1_inst_TXD0: out    vl_logic;
        hps_io_emac1_inst_TXD1: out    vl_logic;
        hps_io_emac1_inst_TXD2: out    vl_logic;
        hps_io_emac1_inst_TXD3: out    vl_logic;
        hps_io_emac1_inst_RXD0: in     vl_logic;
        hps_io_emac1_inst_MDIO: inout  vl_logic;
        hps_io_emac1_inst_MDC: out    vl_logic;
        hps_io_emac1_inst_RX_CTL: in     vl_logic;
        hps_io_emac1_inst_TX_CTL: out    vl_logic;
        hps_io_emac1_inst_RX_CLK: in     vl_logic;
        hps_io_emac1_inst_RXD1: in     vl_logic;
        hps_io_emac1_inst_RXD2: in     vl_logic;
        hps_io_emac1_inst_RXD3: in     vl_logic;
        hps_io_qspi_inst_IO0: inout  vl_logic;
        hps_io_qspi_inst_IO1: inout  vl_logic;
        hps_io_qspi_inst_IO2: inout  vl_logic;
        hps_io_qspi_inst_IO3: inout  vl_logic;
        hps_io_qspi_inst_SS0: out    vl_logic;
        hps_io_qspi_inst_CLK: out    vl_logic;
        hps_io_sdio_inst_CMD: inout  vl_logic;
        hps_io_sdio_inst_D0: inout  vl_logic;
        hps_io_sdio_inst_D1: inout  vl_logic;
        hps_io_sdio_inst_CLK: out    vl_logic;
        hps_io_sdio_inst_D2: inout  vl_logic;
        hps_io_sdio_inst_D3: inout  vl_logic;
        hps_io_usb1_inst_D0: inout  vl_logic;
        hps_io_usb1_inst_D1: inout  vl_logic;
        hps_io_usb1_inst_D2: inout  vl_logic;
        hps_io_usb1_inst_D3: inout  vl_logic;
        hps_io_usb1_inst_D4: inout  vl_logic;
        hps_io_usb1_inst_D5: inout  vl_logic;
        hps_io_usb1_inst_D6: inout  vl_logic;
        hps_io_usb1_inst_D7: inout  vl_logic;
        hps_io_usb1_inst_CLK: in     vl_logic;
        hps_io_usb1_inst_STP: out    vl_logic;
        hps_io_usb1_inst_DIR: in     vl_logic;
        hps_io_usb1_inst_NXT: in     vl_logic;
        hps_io_spim0_inst_CLK: out    vl_logic;
        hps_io_spim0_inst_MOSI: out    vl_logic;
        hps_io_spim0_inst_MISO: in     vl_logic;
        hps_io_spim0_inst_SS0: out    vl_logic;
        hps_io_spim1_inst_CLK: out    vl_logic;
        hps_io_spim1_inst_MOSI: out    vl_logic;
        hps_io_spim1_inst_MISO: in     vl_logic;
        hps_io_spim1_inst_SS0: out    vl_logic;
        hps_io_uart0_inst_RX: in     vl_logic;
        hps_io_uart0_inst_TX: out    vl_logic;
        hps_io_i2c1_inst_SDA: inout  vl_logic;
        hps_io_i2c1_inst_SCL: inout  vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of F2S_Width : constant is 1;
    attribute mti_svvh_generic_type of S2F_Width : constant is 1;
end lab3_hps_0;
