library verilog;
use verilog.vl_types.all;
entity hps_sdram_p0_acv_hard_memphy is
    generic(
        DEVICE_FAMILY   : string  := "";
        IS_HHP_HPS      : string  := "false";
        OCT_SERIES_TERM_CONTROL_WIDTH: string  := "";
        OCT_PARALLEL_TERM_CONTROL_WIDTH: string  := "";
        MEM_ADDRESS_WIDTH: string  := "";
        MEM_BANK_WIDTH  : string  := "";
        MEM_IF_CS_WIDTH : string  := "";
        MEM_CLK_EN_WIDTH: string  := "";
        MEM_CK_WIDTH    : string  := "";
        MEM_ODT_WIDTH   : string  := "";
        MEM_DQS_WIDTH   : string  := "";
        MEM_DM_WIDTH    : string  := "";
        MEM_CONTROL_WIDTH: string  := "";
        MEM_DQ_WIDTH    : string  := "";
        MEM_READ_DQS_WIDTH: string  := "";
        MEM_WRITE_DQS_WIDTH: string  := "";
        DLL_DELAY_CTRL_WIDTH: string  := "";
        MR1_ODS         : string  := "";
        MR1_RTT         : string  := "";
        MR2_RTT_WR      : string  := "";
        TB_PROTOCOL     : string  := "";
        TB_MEM_CLK_FREQ : string  := "";
        TB_RATE         : string  := "";
        TB_MEM_DQ_WIDTH : string  := "";
        TB_MEM_DQS_WIDTH: string  := "";
        TB_PLL_DLL_MASTER: string  := "";
        FAST_SIM_MODEL  : string  := "";
        FAST_SIM_CALIBRATION: string  := "";
        CALIB_REG_WIDTH : string  := "";
        AC_ROM_INIT_FILE_NAME: string  := "";
        INST_ROM_INIT_FILE_NAME: string  := ""
    );
    port(
        global_reset_n  : in     vl_logic;
        soft_reset_n    : in     vl_logic;
        ctl_reset_n     : out    vl_logic;
        ctl_reset_export_n: out    vl_logic;
        afi_reset_n     : out    vl_logic;
        pll_locked      : in     vl_logic;
        oct_ctl_rs_value: in     vl_logic_vector;
        oct_ctl_rt_value: in     vl_logic_vector;
        afi_addr        : in     vl_logic_vector(19 downto 0);
        afi_ba          : in     vl_logic_vector(2 downto 0);
        afi_cke         : in     vl_logic_vector(1 downto 0);
        afi_cs_n        : in     vl_logic_vector(1 downto 0);
        afi_ras_n       : in     vl_logic_vector(0 downto 0);
        afi_we_n        : in     vl_logic_vector(0 downto 0);
        afi_cas_n       : in     vl_logic_vector(0 downto 0);
        afi_rst_n       : in     vl_logic_vector(0 downto 0);
        afi_odt         : in     vl_logic_vector(1 downto 0);
        afi_mem_clk_disable: in     vl_logic_vector(0 downto 0);
        afi_dqs_burst   : in     vl_logic_vector(4 downto 0);
        afi_wdata_valid : in     vl_logic_vector(4 downto 0);
        afi_wdata       : in     vl_logic_vector(79 downto 0);
        afi_dm          : in     vl_logic_vector(9 downto 0);
        afi_rdata       : out    vl_logic_vector(79 downto 0);
        afi_rdata_en    : in     vl_logic_vector(4 downto 0);
        afi_rdata_en_full: in     vl_logic_vector(4 downto 0);
        afi_rdata_valid : out    vl_logic_vector(0 downto 0);
        afi_wlat        : out    vl_logic_vector(3 downto 0);
        afi_rlat        : out    vl_logic_vector(4 downto 0);
        afi_cal_success : out    vl_logic;
        afi_cal_fail    : out    vl_logic;
        avl_read        : in     vl_logic;
        avl_write       : in     vl_logic;
        avl_address     : in     vl_logic_vector(15 downto 0);
        avl_writedata   : in     vl_logic_vector(31 downto 0);
        avl_waitrequest : out    vl_logic;
        avl_readdata    : out    vl_logic_vector(31 downto 0);
        cfg_addlat      : in     vl_logic_vector(7 downto 0);
        cfg_bankaddrwidth: in     vl_logic_vector(7 downto 0);
        cfg_caswrlat    : in     vl_logic_vector(7 downto 0);
        cfg_coladdrwidth: in     vl_logic_vector(7 downto 0);
        cfg_csaddrwidth : in     vl_logic_vector(7 downto 0);
        cfg_devicewidth : in     vl_logic_vector(7 downto 0);
        cfg_dramconfig  : in     vl_logic_vector(23 downto 0);
        cfg_interfacewidth: in     vl_logic_vector(7 downto 0);
        cfg_rowaddrwidth: in     vl_logic_vector(7 downto 0);
        cfg_tcl         : in     vl_logic_vector(7 downto 0);
        cfg_tmrd        : in     vl_logic_vector(7 downto 0);
        cfg_trefi       : in     vl_logic_vector(15 downto 0);
        cfg_trfc        : in     vl_logic_vector(7 downto 0);
        cfg_twr         : in     vl_logic_vector(7 downto 0);
        io_intaddrdout  : in     vl_logic_vector(63 downto 0);
        io_intbadout    : in     vl_logic_vector(11 downto 0);
        io_intcasndout  : in     vl_logic_vector(3 downto 0);
        io_intckdout    : in     vl_logic_vector(3 downto 0);
        io_intckedout   : in     vl_logic_vector(7 downto 0);
        io_intckndout   : in     vl_logic_vector(3 downto 0);
        io_intcsndout   : in     vl_logic_vector(7 downto 0);
        io_intdmdout    : in     vl_logic_vector(19 downto 0);
        io_intdqdin     : out    vl_logic_vector(179 downto 0);
        io_intdqdout    : in     vl_logic_vector(179 downto 0);
        io_intdqoe      : in     vl_logic_vector(89 downto 0);
        io_intdqsbdout  : in     vl_logic_vector(19 downto 0);
        io_intdqsboe    : in     vl_logic_vector(9 downto 0);
        io_intdqsdout   : in     vl_logic_vector(19 downto 0);
        io_intdqslogicdqsena: in     vl_logic_vector(9 downto 0);
        io_intdqslogicfiforeset: in     vl_logic_vector(4 downto 0);
        io_intdqslogicincrdataen: in     vl_logic_vector(9 downto 0);
        io_intdqslogicincwrptr: in     vl_logic_vector(9 downto 0);
        io_intdqslogicoct: in     vl_logic_vector(9 downto 0);
        io_intdqslogicrdatavalid: out    vl_logic_vector(4 downto 0);
        io_intdqslogicreadlatency: in     vl_logic_vector(24 downto 0);
        io_intdqsoe     : in     vl_logic_vector(9 downto 0);
        io_intodtdout   : in     vl_logic_vector(7 downto 0);
        io_intrasndout  : in     vl_logic_vector(3 downto 0);
        io_intresetndout: in     vl_logic_vector(3 downto 0);
        io_intwendout   : in     vl_logic_vector(3 downto 0);
        io_intafirlat   : out    vl_logic_vector(4 downto 0);
        io_intafiwlat   : out    vl_logic_vector(3 downto 0);
        io_intaficalfail: out    vl_logic;
        io_intaficalsuccess: out    vl_logic;
        mem_a           : out    vl_logic_vector;
        mem_ba          : out    vl_logic_vector;
        mem_cs_n        : out    vl_logic_vector;
        mem_cke         : out    vl_logic_vector;
        mem_odt         : out    vl_logic_vector;
        mem_we_n        : out    vl_logic_vector;
        mem_ras_n       : out    vl_logic_vector;
        mem_cas_n       : out    vl_logic_vector;
        mem_reset_n     : out    vl_logic;
        mem_dq          : inout  vl_logic_vector;
        mem_dm          : out    vl_logic_vector;
        mem_ck          : out    vl_logic_vector;
        mem_ck_n        : out    vl_logic_vector;
        mem_dqs         : inout  vl_logic_vector;
        mem_dqs_n       : inout  vl_logic_vector;
        reset_n_scc_clk : out    vl_logic;
        reset_n_avl_clk : out    vl_logic;
        scc_data        : in     vl_logic;
        scc_dqs_ena     : in     vl_logic_vector;
        scc_dqs_io_ena  : in     vl_logic_vector;
        scc_dq_ena      : in     vl_logic_vector;
        scc_dm_ena      : in     vl_logic_vector;
        scc_upd         : in     vl_logic_vector(0 downto 0);
        capture_strobe_tracking: out    vl_logic_vector;
        phy_clk         : out    vl_logic;
        ctl_clk         : out    vl_logic;
        phy_reset_n     : out    vl_logic;
        pll_afi_clk     : in     vl_logic;
        pll_afi_half_clk: in     vl_logic;
        pll_addr_cmd_clk: in     vl_logic;
        pll_mem_clk     : in     vl_logic;
        pll_mem_phy_clk : in     vl_logic;
        pll_afi_phy_clk : in     vl_logic;
        pll_avl_phy_clk : in     vl_logic;
        pll_write_clk   : in     vl_logic;
        pll_write_clk_pre_phy_clk: in     vl_logic;
        pll_dqs_ena_clk : in     vl_logic;
        seq_clk         : in     vl_logic;
        pll_avl_clk     : in     vl_logic;
        pll_config_clk  : in     vl_logic;
        dll_clk         : out    vl_logic;
        dll_pll_locked  : out    vl_logic;
        dll_phy_delayctrl: in     vl_logic_vector
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of DEVICE_FAMILY : constant is 1;
    attribute mti_svvh_generic_type of IS_HHP_HPS : constant is 1;
    attribute mti_svvh_generic_type of OCT_SERIES_TERM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of OCT_PARALLEL_TERM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_ADDRESS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_BANK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_IF_CS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CLK_EN_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_ODT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_DM_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_DQ_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_READ_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_WRITE_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of DLL_DELAY_CTRL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MR1_ODS : constant is 1;
    attribute mti_svvh_generic_type of MR1_RTT : constant is 1;
    attribute mti_svvh_generic_type of MR2_RTT_WR : constant is 1;
    attribute mti_svvh_generic_type of TB_PROTOCOL : constant is 1;
    attribute mti_svvh_generic_type of TB_MEM_CLK_FREQ : constant is 1;
    attribute mti_svvh_generic_type of TB_RATE : constant is 1;
    attribute mti_svvh_generic_type of TB_MEM_DQ_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of TB_MEM_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of TB_PLL_DLL_MASTER : constant is 1;
    attribute mti_svvh_generic_type of FAST_SIM_MODEL : constant is 1;
    attribute mti_svvh_generic_type of FAST_SIM_CALIBRATION : constant is 1;
    attribute mti_svvh_generic_type of CALIB_REG_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AC_ROM_INIT_FILE_NAME : constant is 1;
    attribute mti_svvh_generic_type of INST_ROM_INIT_FILE_NAME : constant is 1;
end hps_sdram_p0_acv_hard_memphy;
