library verilog;
use verilog.vl_types.all;
entity hps_sdram_p0_acv_hard_io_pads is
    generic(
        DEVICE_FAMILY   : string  := "";
        FAST_SIM_MODEL  : integer := 0;
        OCT_SERIES_TERM_CONTROL_WIDTH: string  := "";
        OCT_PARALLEL_TERM_CONTROL_WIDTH: string  := "";
        MEM_ADDRESS_WIDTH: string  := "";
        MEM_BANK_WIDTH  : string  := "";
        MEM_CHIP_SELECT_WIDTH: string  := "";
        MEM_CLK_EN_WIDTH: string  := "";
        MEM_CK_WIDTH    : string  := "";
        MEM_ODT_WIDTH   : string  := "";
        MEM_DQS_WIDTH   : string  := "";
        MEM_DM_WIDTH    : string  := "";
        MEM_CONTROL_WIDTH: string  := "";
        MEM_DQ_WIDTH    : string  := "";
        MEM_READ_DQS_WIDTH: string  := "";
        MEM_WRITE_DQS_WIDTH: string  := "";
        DLL_DELAY_CTRL_WIDTH: string  := "";
        ADC_PHASE_SETTING: string  := "";
        ADC_INVERT_PHASE: string  := "";
        IS_HHP_HPS      : string  := ""
    );
    port(
        reset_n_addr_cmd_clk: in     vl_logic;
        reset_n_afi_clk : in     vl_logic;
        oct_ctl_rs_value: in     vl_logic_vector;
        oct_ctl_rt_value: in     vl_logic_vector;
        phy_ddio_address: in     vl_logic_vector(63 downto 0);
        phy_ddio_bank   : in     vl_logic_vector(11 downto 0);
        phy_ddio_cs_n   : in     vl_logic_vector(7 downto 0);
        phy_ddio_cke    : in     vl_logic_vector(7 downto 0);
        phy_ddio_odt    : in     vl_logic_vector(7 downto 0);
        phy_ddio_we_n   : in     vl_logic_vector(3 downto 0);
        phy_ddio_ras_n  : in     vl_logic_vector(3 downto 0);
        phy_ddio_cas_n  : in     vl_logic_vector(3 downto 0);
        phy_ddio_ck     : in     vl_logic_vector(3 downto 0);
        phy_ddio_reset_n: in     vl_logic_vector(3 downto 0);
        phy_mem_address : out    vl_logic_vector;
        phy_mem_bank    : out    vl_logic_vector;
        phy_mem_cs_n    : out    vl_logic_vector;
        phy_mem_cke     : out    vl_logic_vector;
        phy_mem_odt     : out    vl_logic_vector;
        phy_mem_we_n    : out    vl_logic_vector;
        phy_mem_ras_n   : out    vl_logic_vector;
        phy_mem_cas_n   : out    vl_logic_vector;
        phy_mem_reset_n : out    vl_logic;
        pll_afi_clk     : in     vl_logic;
        pll_afi_phy_clk : in     vl_logic;
        pll_avl_phy_clk : in     vl_logic;
        pll_avl_clk     : in     vl_logic;
        avl_clk         : in     vl_logic;
        pll_mem_clk     : in     vl_logic;
        pll_mem_phy_clk : in     vl_logic;
        pll_write_clk   : in     vl_logic;
        pll_dqs_ena_clk : in     vl_logic;
        pll_addr_cmd_clk: in     vl_logic;
        phy_mem_dq      : inout  vl_logic_vector;
        phy_mem_dm      : out    vl_logic_vector;
        phy_mem_ck      : out    vl_logic_vector;
        phy_mem_ck_n    : out    vl_logic_vector;
        mem_dqs         : inout  vl_logic_vector;
        mem_dqs_n       : inout  vl_logic_vector;
        dll_phy_delayctrl: in     vl_logic_vector;
        scc_clk         : in     vl_logic;
        scc_data        : in     vl_logic;
        scc_dqs_ena     : in     vl_logic_vector;
        scc_dqs_io_ena  : in     vl_logic_vector;
        scc_dq_ena      : in     vl_logic_vector;
        scc_dm_ena      : in     vl_logic_vector;
        scc_upd         : in     vl_logic;
        seq_read_latency_counter: in     vl_logic_vector(4 downto 0);
        seq_read_increment_vfifo_fr: in     vl_logic_vector;
        seq_read_increment_vfifo_hr: in     vl_logic_vector;
        phy_ddio_dmdout : in     vl_logic_vector(24 downto 0);
        phy_ddio_dqdout : in     vl_logic_vector(179 downto 0);
        phy_ddio_dqs_oe : in     vl_logic_vector(9 downto 0);
        phy_ddio_dqsdout: in     vl_logic_vector(19 downto 0);
        phy_ddio_dqsb_oe: in     vl_logic_vector(9 downto 0);
        phy_ddio_dqslogic_oct: in     vl_logic_vector(9 downto 0);
        phy_ddio_dqslogic_fiforeset: in     vl_logic_vector(4 downto 0);
        phy_ddio_dqslogic_aclr_pstamble: in     vl_logic_vector(4 downto 0);
        phy_ddio_dqslogic_aclr_fifoctrl: in     vl_logic_vector(4 downto 0);
        phy_ddio_dqslogic_incwrptr: in     vl_logic_vector(9 downto 0);
        phy_ddio_dqslogic_readlatency: in     vl_logic_vector(24 downto 0);
        ddio_phy_dqslogic_rdatavalid: out    vl_logic_vector(4 downto 0);
        ddio_phy_dqdin  : out    vl_logic_vector(179 downto 0);
        phy_ddio_dqslogic_incrdataen: in     vl_logic_vector(9 downto 0);
        phy_ddio_dqslogic_dqsena: in     vl_logic_vector(9 downto 0);
        phy_ddio_dqoe   : in     vl_logic_vector(89 downto 0);
        capture_strobe_tracking: out    vl_logic_vector
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of DEVICE_FAMILY : constant is 1;
    attribute mti_svvh_generic_type of FAST_SIM_MODEL : constant is 1;
    attribute mti_svvh_generic_type of OCT_SERIES_TERM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of OCT_PARALLEL_TERM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_ADDRESS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_BANK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CHIP_SELECT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CLK_EN_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_ODT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_DM_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_DQ_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_READ_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_WRITE_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of DLL_DELAY_CTRL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ADC_PHASE_SETTING : constant is 1;
    attribute mti_svvh_generic_type of ADC_INVERT_PHASE : constant is 1;
    attribute mti_svvh_generic_type of IS_HHP_HPS : constant is 1;
end hps_sdram_p0_acv_hard_io_pads;
