library verilog;
use verilog.vl_types.all;
entity hps_sdram_p0_acv_hard_addr_cmd_pads is
    generic(
        DEVICE_FAMILY   : string  := "";
        MEM_ADDRESS_WIDTH: string  := "";
        MEM_BANK_WIDTH  : string  := "";
        MEM_CHIP_SELECT_WIDTH: string  := "";
        MEM_CLK_EN_WIDTH: string  := "";
        MEM_CK_WIDTH    : string  := "";
        MEM_ODT_WIDTH   : string  := "";
        MEM_CONTROL_WIDTH: string  := "";
        AFI_ADDRESS_WIDTH: string  := "";
        AFI_BANK_WIDTH  : string  := "";
        AFI_CHIP_SELECT_WIDTH: string  := "";
        AFI_CLK_EN_WIDTH: string  := "";
        AFI_ODT_WIDTH   : string  := "";
        AFI_CONTROL_WIDTH: string  := "";
        DLL_WIDTH       : string  := "";
        ADC_PHASE_SETTING: string  := "";
        ADC_INVERT_PHASE: string  := "";
        IS_HHP_HPS      : string  := ""
    );
    port(
        reset_n         : in     vl_logic;
        reset_n_afi_clk : in     vl_logic;
        pll_hr_clk      : in     vl_logic;
        pll_avl_phy_clk : in     vl_logic;
        pll_afi_clk     : in     vl_logic;
        pll_mem_clk     : in     vl_logic;
        pll_write_clk   : in     vl_logic;
        phy_ddio_address: in     vl_logic_vector;
        dll_delayctrl_in: in     vl_logic_vector;
        phy_ddio_bank   : in     vl_logic_vector;
        phy_ddio_cs_n   : in     vl_logic_vector;
        phy_ddio_cke    : in     vl_logic_vector;
        phy_ddio_odt    : in     vl_logic_vector;
        phy_ddio_we_n   : in     vl_logic_vector;
        phy_ddio_ras_n  : in     vl_logic_vector;
        phy_ddio_cas_n  : in     vl_logic_vector;
        phy_ddio_ck     : in     vl_logic_vector;
        phy_ddio_reset_n: in     vl_logic_vector;
        phy_mem_address : out    vl_logic_vector;
        phy_mem_bank    : out    vl_logic_vector;
        phy_mem_cs_n    : out    vl_logic_vector;
        phy_mem_cke     : out    vl_logic_vector;
        phy_mem_odt     : out    vl_logic_vector;
        phy_mem_we_n    : out    vl_logic_vector;
        phy_mem_ras_n   : out    vl_logic_vector;
        phy_mem_cas_n   : out    vl_logic_vector;
        phy_mem_reset_n : out    vl_logic;
        phy_mem_ck      : out    vl_logic_vector;
        phy_mem_ck_n    : out    vl_logic_vector
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of DEVICE_FAMILY : constant is 1;
    attribute mti_svvh_generic_type of MEM_ADDRESS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_BANK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CHIP_SELECT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CLK_EN_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_ODT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_ADDRESS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_BANK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_CHIP_SELECT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_CLK_EN_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_ODT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of DLL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ADC_PHASE_SETTING : constant is 1;
    attribute mti_svvh_generic_type of ADC_INVERT_PHASE : constant is 1;
    attribute mti_svvh_generic_type of IS_HHP_HPS : constant is 1;
end hps_sdram_p0_acv_hard_addr_cmd_pads;
