library verilog;
use verilog.vl_types.all;
entity altera_reset_controller is
    generic(
        NUM_RESET_INPUTS: integer := 6;
        USE_RESET_REQUEST_IN0: integer := 0;
        USE_RESET_REQUEST_IN1: integer := 0;
        USE_RESET_REQUEST_IN2: integer := 0;
        USE_RESET_REQUEST_IN3: integer := 0;
        USE_RESET_REQUEST_IN4: integer := 0;
        USE_RESET_REQUEST_IN5: integer := 0;
        USE_RESET_REQUEST_IN6: integer := 0;
        USE_RESET_REQUEST_IN7: integer := 0;
        USE_RESET_REQUEST_IN8: integer := 0;
        USE_RESET_REQUEST_IN9: integer := 0;
        USE_RESET_REQUEST_IN10: integer := 0;
        USE_RESET_REQUEST_IN11: integer := 0;
        USE_RESET_REQUEST_IN12: integer := 0;
        USE_RESET_REQUEST_IN13: integer := 0;
        USE_RESET_REQUEST_IN14: integer := 0;
        USE_RESET_REQUEST_IN15: integer := 0;
        OUTPUT_RESET_SYNC_EDGES: string  := "deassert";
        SYNC_DEPTH      : integer := 2;
        RESET_REQUEST_PRESENT: integer := 0;
        RESET_REQ_WAIT_TIME: integer := 3;
        MIN_RST_ASSERTION_TIME: integer := 11;
        RESET_REQ_EARLY_DSRT_TIME: integer := 4;
        ADAPT_RESET_REQUEST: integer := 0
    );
    port(
        reset_in0       : in     vl_logic;
        reset_in1       : in     vl_logic;
        reset_in2       : in     vl_logic;
        reset_in3       : in     vl_logic;
        reset_in4       : in     vl_logic;
        reset_in5       : in     vl_logic;
        reset_in6       : in     vl_logic;
        reset_in7       : in     vl_logic;
        reset_in8       : in     vl_logic;
        reset_in9       : in     vl_logic;
        reset_in10      : in     vl_logic;
        reset_in11      : in     vl_logic;
        reset_in12      : in     vl_logic;
        reset_in13      : in     vl_logic;
        reset_in14      : in     vl_logic;
        reset_in15      : in     vl_logic;
        reset_req_in0   : in     vl_logic;
        reset_req_in1   : in     vl_logic;
        reset_req_in2   : in     vl_logic;
        reset_req_in3   : in     vl_logic;
        reset_req_in4   : in     vl_logic;
        reset_req_in5   : in     vl_logic;
        reset_req_in6   : in     vl_logic;
        reset_req_in7   : in     vl_logic;
        reset_req_in8   : in     vl_logic;
        reset_req_in9   : in     vl_logic;
        reset_req_in10  : in     vl_logic;
        reset_req_in11  : in     vl_logic;
        reset_req_in12  : in     vl_logic;
        reset_req_in13  : in     vl_logic;
        reset_req_in14  : in     vl_logic;
        reset_req_in15  : in     vl_logic;
        clk             : in     vl_logic;
        reset_out       : out    vl_logic;
        reset_req       : out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of NUM_RESET_INPUTS : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN0 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN1 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN2 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN3 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN4 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN5 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN6 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN7 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN8 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN9 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN10 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN11 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN12 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN13 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN14 : constant is 1;
    attribute mti_svvh_generic_type of USE_RESET_REQUEST_IN15 : constant is 1;
    attribute mti_svvh_generic_type of OUTPUT_RESET_SYNC_EDGES : constant is 1;
    attribute mti_svvh_generic_type of SYNC_DEPTH : constant is 1;
    attribute mti_svvh_generic_type of RESET_REQUEST_PRESENT : constant is 1;
    attribute mti_svvh_generic_type of RESET_REQ_WAIT_TIME : constant is 1;
    attribute mti_svvh_generic_type of MIN_RST_ASSERTION_TIME : constant is 1;
    attribute mti_svvh_generic_type of RESET_REQ_EARLY_DSRT_TIME : constant is 1;
    attribute mti_svvh_generic_type of ADAPT_RESET_REQUEST : constant is 1;
end altera_reset_controller;
