library verilog;
use verilog.vl_types.all;
entity altera_merlin_width_adapter is
    generic(
        IN_PKT_ADDR_L   : integer := 0;
        IN_PKT_ADDR_H   : integer := 31;
        IN_PKT_DATA_L   : integer := 32;
        IN_PKT_DATA_H   : integer := 63;
        IN_PKT_BYTEEN_L : integer := 64;
        IN_PKT_BYTEEN_H : integer := 67;
        IN_PKT_TRANS_COMPRESSED_READ: integer := 72;
        IN_PKT_BYTE_CNT_L: integer := 73;
        IN_PKT_BYTE_CNT_H: integer := 77;
        IN_PKT_BURSTWRAP_L: integer := 78;
        IN_PKT_BURSTWRAP_H: integer := 82;
        IN_PKT_BURST_SIZE_L: integer := 83;
        IN_PKT_BURST_SIZE_H: integer := 85;
        IN_PKT_RESPONSE_STATUS_L: integer := 86;
        IN_PKT_RESPONSE_STATUS_H: integer := 87;
        IN_PKT_TRANS_EXCLUSIVE: integer := 88;
        IN_PKT_BURST_TYPE_L: integer := 89;
        IN_PKT_BURST_TYPE_H: integer := 90;
        IN_PKT_ORI_BURST_SIZE_L: integer := 91;
        IN_PKT_ORI_BURST_SIZE_H: integer := 93;
        IN_ST_DATA_W    : integer := 110;
        OUT_PKT_ADDR_L  : integer := 0;
        OUT_PKT_ADDR_H  : integer := 31;
        OUT_PKT_DATA_L  : integer := 32;
        OUT_PKT_DATA_H  : integer := 47;
        OUT_PKT_BYTEEN_L: integer := 48;
        OUT_PKT_BYTEEN_H: integer := 49;
        OUT_PKT_TRANS_COMPRESSED_READ: integer := 54;
        OUT_PKT_BYTE_CNT_L: integer := 55;
        OUT_PKT_BYTE_CNT_H: integer := 59;
        OUT_PKT_BURST_SIZE_L: integer := 60;
        OUT_PKT_BURST_SIZE_H: integer := 62;
        OUT_PKT_RESPONSE_STATUS_L: integer := 63;
        OUT_PKT_RESPONSE_STATUS_H: integer := 64;
        OUT_PKT_TRANS_EXCLUSIVE: integer := 65;
        OUT_PKT_BURST_TYPE_L: integer := 66;
        OUT_PKT_BURST_TYPE_H: integer := 67;
        OUT_PKT_ORI_BURST_SIZE_L: integer := 68;
        OUT_PKT_ORI_BURST_SIZE_H: integer := 70;
        OUT_ST_DATA_W   : integer := 92;
        ST_CHANNEL_W    : integer := 32;
        OPTIMIZE_FOR_RSP: integer := 0;
        PACKING         : integer := 1;
        CONSTANT_BURST_SIZE: integer := 1;
        RESPONSE_PATH   : integer := 0
    );
    port(
        clk             : in     vl_logic;
        reset           : in     vl_logic;
        in_ready        : out    vl_logic;
        in_valid        : in     vl_logic;
        in_channel      : in     vl_logic_vector;
        in_data         : in     vl_logic_vector;
        in_startofpacket: in     vl_logic;
        in_endofpacket  : in     vl_logic;
        out_ready       : in     vl_logic;
        out_valid       : out    vl_logic;
        out_channel     : out    vl_logic_vector;
        out_data        : out    vl_logic_vector;
        out_startofpacket: out    vl_logic;
        out_endofpacket : out    vl_logic;
        in_command_size_data: in     vl_logic_vector(2 downto 0)
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of IN_PKT_ADDR_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_ADDR_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_DATA_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_DATA_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BYTEEN_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BYTEEN_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_TRANS_COMPRESSED_READ : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BYTE_CNT_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BYTE_CNT_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BURSTWRAP_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BURSTWRAP_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_RESPONSE_STATUS_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_RESPONSE_STATUS_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_TRANS_EXCLUSIVE : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BURST_TYPE_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_BURST_TYPE_H : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_ORI_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of IN_PKT_ORI_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of IN_ST_DATA_W : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_ADDR_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_ADDR_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_DATA_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_DATA_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BYTEEN_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BYTEEN_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_TRANS_COMPRESSED_READ : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BYTE_CNT_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BYTE_CNT_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_RESPONSE_STATUS_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_RESPONSE_STATUS_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_TRANS_EXCLUSIVE : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BURST_TYPE_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_BURST_TYPE_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_ORI_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of OUT_PKT_ORI_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_ST_DATA_W : constant is 1;
    attribute mti_svvh_generic_type of ST_CHANNEL_W : constant is 1;
    attribute mti_svvh_generic_type of OPTIMIZE_FOR_RSP : constant is 1;
    attribute mti_svvh_generic_type of PACKING : constant is 1;
    attribute mti_svvh_generic_type of CONSTANT_BURST_SIZE : constant is 1;
    attribute mti_svvh_generic_type of RESPONSE_PATH : constant is 1;
end altera_merlin_width_adapter;
