library verilog;
use verilog.vl_types.all;
entity altera_merlin_slave_translator is
    generic(
        AV_ADDRESS_W    : integer := 32;
        AV_DATA_W       : integer := 32;
        AV_BURSTCOUNT_W : integer := 4;
        AV_BYTEENABLE_W : integer := 4;
        UAV_BYTEENABLE_W: integer := 4;
        AV_READLATENCY  : integer := 1;
        AV_READ_WAIT_CYCLES: integer := 0;
        AV_WRITE_WAIT_CYCLES: integer := 0;
        AV_SETUP_WAIT_CYCLES: integer := 0;
        AV_DATA_HOLD_CYCLES: integer := 0;
        USE_READDATAVALID: integer := 1;
        USE_WAITREQUEST : integer := 1;
        USE_READRESPONSE: integer := 0;
        USE_WRITERESPONSE: integer := 0;
        AV_SYMBOLS_PER_WORD: integer := 4;
        AV_ADDRESS_SYMBOLS: integer := 0;
        AV_BURSTCOUNT_SYMBOLS: integer := 0;
        BITS_PER_WORD   : vl_notype;
        UAV_ADDRESS_W   : integer := 38;
        UAV_BURSTCOUNT_W: integer := 10;
        UAV_DATA_W      : integer := 32;
        AV_CONSTANT_BURST_BEHAVIOR: integer := 0;
        UAV_CONSTANT_BURST_BEHAVIOR: integer := 0;
        CHIPSELECT_THROUGH_READLATENCY: integer := 0;
        USE_UAV_CLKEN   : integer := 0;
        AV_REQUIRE_UNALIGNED_ADDRESSES: integer := 0
    );
    port(
        clk             : in     vl_logic;
        reset           : in     vl_logic;
        uav_address     : in     vl_logic_vector;
        uav_writedata   : in     vl_logic_vector;
        uav_write       : in     vl_logic;
        uav_read        : in     vl_logic;
        uav_burstcount  : in     vl_logic_vector;
        uav_byteenable  : in     vl_logic_vector;
        uav_lock        : in     vl_logic;
        uav_debugaccess : in     vl_logic;
        uav_clken       : in     vl_logic;
        uav_readdatavalid: out    vl_logic;
        uav_waitrequest : out    vl_logic;
        uav_readdata    : out    vl_logic_vector;
        uav_response    : out    vl_logic_vector(1 downto 0);
        uav_writeresponserequest: in     vl_logic;
        uav_writeresponsevalid: out    vl_logic;
        av_address      : out    vl_logic_vector;
        av_writedata    : out    vl_logic_vector;
        av_write        : out    vl_logic;
        av_read         : out    vl_logic;
        av_burstcount   : out    vl_logic_vector;
        av_byteenable   : out    vl_logic_vector;
        av_writebyteenable: out    vl_logic_vector;
        av_begintransfer: out    vl_logic;
        av_chipselect   : out    vl_logic;
        av_beginbursttransfer: out    vl_logic;
        av_lock         : out    vl_logic;
        av_clken        : out    vl_logic;
        av_debugaccess  : out    vl_logic;
        av_outputenable : out    vl_logic;
        av_readdata     : in     vl_logic_vector;
        av_readdatavalid: in     vl_logic;
        av_waitrequest  : in     vl_logic;
        av_response     : in     vl_logic_vector(1 downto 0);
        av_writeresponserequest: out    vl_logic;
        av_writeresponsevalid: in     vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of AV_ADDRESS_W : constant is 1;
    attribute mti_svvh_generic_type of AV_DATA_W : constant is 1;
    attribute mti_svvh_generic_type of AV_BURSTCOUNT_W : constant is 1;
    attribute mti_svvh_generic_type of AV_BYTEENABLE_W : constant is 1;
    attribute mti_svvh_generic_type of UAV_BYTEENABLE_W : constant is 1;
    attribute mti_svvh_generic_type of AV_READLATENCY : constant is 1;
    attribute mti_svvh_generic_type of AV_READ_WAIT_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of AV_WRITE_WAIT_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of AV_SETUP_WAIT_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of AV_DATA_HOLD_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of USE_READDATAVALID : constant is 1;
    attribute mti_svvh_generic_type of USE_WAITREQUEST : constant is 1;
    attribute mti_svvh_generic_type of USE_READRESPONSE : constant is 1;
    attribute mti_svvh_generic_type of USE_WRITERESPONSE : constant is 1;
    attribute mti_svvh_generic_type of AV_SYMBOLS_PER_WORD : constant is 1;
    attribute mti_svvh_generic_type of AV_ADDRESS_SYMBOLS : constant is 1;
    attribute mti_svvh_generic_type of AV_BURSTCOUNT_SYMBOLS : constant is 1;
    attribute mti_svvh_generic_type of BITS_PER_WORD : constant is 3;
    attribute mti_svvh_generic_type of UAV_ADDRESS_W : constant is 1;
    attribute mti_svvh_generic_type of UAV_BURSTCOUNT_W : constant is 1;
    attribute mti_svvh_generic_type of UAV_DATA_W : constant is 1;
    attribute mti_svvh_generic_type of AV_CONSTANT_BURST_BEHAVIOR : constant is 1;
    attribute mti_svvh_generic_type of UAV_CONSTANT_BURST_BEHAVIOR : constant is 1;
    attribute mti_svvh_generic_type of CHIPSELECT_THROUGH_READLATENCY : constant is 1;
    attribute mti_svvh_generic_type of USE_UAV_CLKEN : constant is 1;
    attribute mti_svvh_generic_type of AV_REQUIRE_UNALIGNED_ADDRESSES : constant is 1;
end altera_merlin_slave_translator;
