library verilog;
use verilog.vl_types.all;
entity altera_merlin_master_agent is
    generic(
        PKT_QOS_H       : integer := 109;
        PKT_QOS_L       : integer := 106;
        PKT_DATA_SIDEBAND_H: integer := 105;
        PKT_DATA_SIDEBAND_L: integer := 98;
        PKT_ADDR_SIDEBAND_H: integer := 97;
        PKT_ADDR_SIDEBAND_L: integer := 93;
        PKT_CACHE_H     : integer := 92;
        PKT_CACHE_L     : integer := 89;
        PKT_THREAD_ID_H : integer := 88;
        PKT_THREAD_ID_L : integer := 87;
        PKT_BEGIN_BURST : integer := 81;
        PKT_PROTECTION_H: integer := 80;
        PKT_PROTECTION_L: integer := 80;
        PKT_BURSTWRAP_H : integer := 79;
        PKT_BURSTWRAP_L : integer := 77;
        PKT_BYTE_CNT_H  : integer := 76;
        PKT_BYTE_CNT_L  : integer := 74;
        PKT_ADDR_H      : integer := 73;
        PKT_ADDR_L      : integer := 42;
        PKT_BURST_SIZE_H: integer := 86;
        PKT_BURST_SIZE_L: integer := 84;
        PKT_BURST_TYPE_H: integer := 94;
        PKT_BURST_TYPE_L: integer := 93;
        PKT_TRANS_EXCLUSIVE: integer := 83;
        PKT_TRANS_LOCK  : integer := 82;
        PKT_TRANS_COMPRESSED_READ: integer := 41;
        PKT_TRANS_POSTED: integer := 40;
        PKT_TRANS_WRITE : integer := 39;
        PKT_TRANS_READ  : integer := 38;
        PKT_DATA_H      : integer := 37;
        PKT_DATA_L      : integer := 6;
        PKT_BYTEEN_H    : integer := 5;
        PKT_BYTEEN_L    : integer := 2;
        PKT_SRC_ID_H    : integer := 1;
        PKT_SRC_ID_L    : integer := 1;
        PKT_DEST_ID_H   : integer := 0;
        PKT_DEST_ID_L   : integer := 0;
        PKT_RESPONSE_STATUS_L: integer := 110;
        PKT_RESPONSE_STATUS_H: integer := 111;
        PKT_ORI_BURST_SIZE_L: integer := 112;
        PKT_ORI_BURST_SIZE_H: integer := 114;
        ST_DATA_W       : integer := 115;
        ST_CHANNEL_W    : integer := 1;
        AV_BURSTCOUNT_W : integer := 3;
        ID              : integer := 1;
        SUPPRESS_0_BYTEEN_RSP: integer := 1;
        BURSTWRAP_VALUE : integer := 4;
        CACHE_VALUE     : integer := 0;
        SECURE_ACCESS_BIT: integer := 1;
        USE_READRESPONSE: integer := 0;
        USE_WRITERESPONSE: integer := 0;
        PKT_BURSTWRAP_W : vl_notype;
        PKT_BYTE_CNT_W  : vl_notype;
        PKT_PROTECTION_W: vl_notype;
        PKT_ADDR_W      : vl_notype;
        PKT_DATA_W      : vl_notype;
        PKT_BYTEEN_W    : vl_notype;
        PKT_SRC_ID_W    : vl_notype;
        PKT_DEST_ID_W   : vl_notype
    );
    port(
        clk             : in     vl_logic;
        reset           : in     vl_logic;
        av_address      : in     vl_logic_vector;
        av_write        : in     vl_logic;
        av_read         : in     vl_logic;
        av_writedata    : in     vl_logic_vector;
        av_readdata     : out    vl_logic_vector;
        av_waitrequest  : out    vl_logic;
        av_readdatavalid: out    vl_logic;
        av_byteenable   : in     vl_logic_vector;
        av_burstcount   : in     vl_logic_vector;
        av_debugaccess  : in     vl_logic;
        av_lock         : in     vl_logic;
        av_response     : out    vl_logic_vector(1 downto 0);
        av_writeresponserequest: in     vl_logic;
        av_writeresponsevalid: out    vl_logic;
        cp_valid        : out    vl_logic;
        cp_data         : out    vl_logic_vector;
        cp_startofpacket: out    vl_logic;
        cp_endofpacket  : out    vl_logic;
        cp_ready        : in     vl_logic;
        rp_valid        : in     vl_logic;
        rp_data         : in     vl_logic_vector;
        rp_channel      : in     vl_logic_vector;
        rp_startofpacket: in     vl_logic;
        rp_endofpacket  : in     vl_logic;
        rp_ready        : out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of PKT_QOS_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_QOS_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_SIDEBAND_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_SIDEBAND_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_SIDEBAND_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_SIDEBAND_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_CACHE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_CACHE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_THREAD_ID_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_THREAD_ID_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BEGIN_BURST : constant is 1;
    attribute mti_svvh_generic_type of PKT_PROTECTION_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_PROTECTION_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_TYPE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_TYPE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_EXCLUSIVE : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_LOCK : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_COMPRESSED_READ : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_POSTED : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_WRITE : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_READ : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTEEN_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTEEN_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_SRC_ID_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_SRC_ID_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_DEST_ID_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_DEST_ID_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_RESPONSE_STATUS_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_RESPONSE_STATUS_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_ORI_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_ORI_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of ST_DATA_W : constant is 1;
    attribute mti_svvh_generic_type of ST_CHANNEL_W : constant is 1;
    attribute mti_svvh_generic_type of AV_BURSTCOUNT_W : constant is 1;
    attribute mti_svvh_generic_type of ID : constant is 1;
    attribute mti_svvh_generic_type of SUPPRESS_0_BYTEEN_RSP : constant is 1;
    attribute mti_svvh_generic_type of BURSTWRAP_VALUE : constant is 1;
    attribute mti_svvh_generic_type of CACHE_VALUE : constant is 1;
    attribute mti_svvh_generic_type of SECURE_ACCESS_BIT : constant is 1;
    attribute mti_svvh_generic_type of USE_READRESPONSE : constant is 1;
    attribute mti_svvh_generic_type of USE_WRITERESPONSE : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_PROTECTION_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_ADDR_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_DATA_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_BYTEEN_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_SRC_ID_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_DEST_ID_W : constant is 3;
end altera_merlin_master_agent;
