library verilog;
use verilog.vl_types.all;
entity altera_merlin_burst_adapter_full is
    generic(
        PKT_BEGIN_BURST : integer := 81;
        PKT_ADDR_H      : integer := 79;
        PKT_ADDR_L      : integer := 48;
        PKT_BYTE_CNT_H  : integer := 5;
        PKT_BYTE_CNT_L  : integer := 0;
        PKT_BURSTWRAP_H : integer := 11;
        PKT_BURSTWRAP_L : integer := 6;
        PKT_TRANS_COMPRESSED_READ: integer := 14;
        PKT_TRANS_WRITE : integer := 13;
        PKT_TRANS_READ  : integer := 12;
        PKT_BYTEEN_H    : integer := 83;
        PKT_BYTEEN_L    : integer := 80;
        PKT_BURST_TYPE_H: integer := 88;
        PKT_BURST_TYPE_L: integer := 87;
        PKT_BURST_SIZE_H: integer := 86;
        PKT_BURST_SIZE_L: integer := 84;
        IN_NARROW_SIZE  : integer := 0;
        OUT_NARROW_SIZE : integer := 0;
        OUT_FIXED       : integer := 0;
        OUT_COMPLETE_WRAP: integer := 0;
        ST_DATA_W       : integer := 89;
        ST_CHANNEL_W    : integer := 8;
        BYTEENABLE_SYNTHESIS: integer := 0;
        BURSTWRAP_CONST_MASK: integer := 0;
        PIPE_INPUTS     : integer := 0;
        NO_WRAP_SUPPORT : integer := 0;
        BURSTWRAP_CONST_VALUE: integer := -1;
        OUT_BYTE_CNT_H  : integer := 5;
        OUT_BURSTWRAP_H : integer := 11
    );
    port(
        clk             : in     vl_logic;
        reset           : in     vl_logic;
        sink0_valid     : in     vl_logic;
        sink0_data      : in     vl_logic_vector;
        sink0_channel   : in     vl_logic_vector;
        sink0_startofpacket: in     vl_logic;
        sink0_endofpacket: in     vl_logic;
        sink0_ready     : out    vl_logic;
        source0_valid   : out    vl_logic;
        source0_data    : out    vl_logic_vector;
        source0_channel : out    vl_logic_vector;
        source0_startofpacket: out    vl_logic;
        source0_endofpacket: out    vl_logic;
        source0_ready   : in     vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of PKT_BEGIN_BURST : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_COMPRESSED_READ : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_WRITE : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_READ : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTEEN_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTEEN_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_TYPE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_TYPE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of IN_NARROW_SIZE : constant is 1;
    attribute mti_svvh_generic_type of OUT_NARROW_SIZE : constant is 1;
    attribute mti_svvh_generic_type of OUT_FIXED : constant is 1;
    attribute mti_svvh_generic_type of OUT_COMPLETE_WRAP : constant is 1;
    attribute mti_svvh_generic_type of ST_DATA_W : constant is 1;
    attribute mti_svvh_generic_type of ST_CHANNEL_W : constant is 1;
    attribute mti_svvh_generic_type of BYTEENABLE_SYNTHESIS : constant is 1;
    attribute mti_svvh_generic_type of BURSTWRAP_CONST_MASK : constant is 1;
    attribute mti_svvh_generic_type of PIPE_INPUTS : constant is 1;
    attribute mti_svvh_generic_type of NO_WRAP_SUPPORT : constant is 1;
    attribute mti_svvh_generic_type of BURSTWRAP_CONST_VALUE : constant is 1;
    attribute mti_svvh_generic_type of OUT_BYTE_CNT_H : constant is 1;
    attribute mti_svvh_generic_type of OUT_BURSTWRAP_H : constant is 1;
end altera_merlin_burst_adapter_full;
