library verilog;
use verilog.vl_types.all;
entity altera_merlin_axi_master_ni is
    generic(
        ID_WIDTH        : integer := 2;
        ADDR_WIDTH      : integer := 32;
        RDATA_WIDTH     : integer := 32;
        WDATA_WIDTH     : integer := 32;
        ADDR_USER_WIDTH : integer := 8;
        DATA_USER_WIDTH : integer := 8;
        AXI_LOCK_WIDTH  : integer := 2;
        AXI_BURST_LENGTH_WIDTH: integer := 4;
        WRITE_ISSUING_CAPABILITY: integer := 16;
        READ_ISSUING_CAPABILITY: integer := 16;
        AXI_VERSION     : string  := "AXI3";
        PKT_THREAD_ID_H : integer := 109;
        PKT_THREAD_ID_L : integer := 108;
        PKT_QOS_H       : integer := 113;
        PKT_QOS_L       : integer := 110;
        PKT_BEGIN_BURST : integer := 104;
        PKT_CACHE_H     : integer := 103;
        PKT_CACHE_L     : integer := 100;
        PKT_ADDR_SIDEBAND_H: integer := 99;
        PKT_ADDR_SIDEBAND_L: integer := 92;
        PKT_DATA_SIDEBAND_H: integer := 124;
        PKT_DATA_SIDEBAND_L: integer := 118;
        PKT_PROTECTION_H: integer := 89;
        PKT_PROTECTION_L: integer := 87;
        PKT_BURST_SIZE_H: integer := 84;
        PKT_BURST_SIZE_L: integer := 82;
        PKT_BURST_TYPE_H: integer := 86;
        PKT_BURST_TYPE_L: integer := 85;
        PKT_RESPONSE_STATUS_L: integer := 106;
        PKT_RESPONSE_STATUS_H: integer := 107;
        PKT_BURSTWRAP_H : integer := 79;
        PKT_BURSTWRAP_L : integer := 77;
        PKT_BYTE_CNT_H  : integer := 76;
        PKT_BYTE_CNT_L  : integer := 74;
        PKT_ADDR_H      : integer := 73;
        PKT_ADDR_L      : integer := 42;
        PKT_TRANS_EXCLUSIVE: integer := 80;
        PKT_TRANS_LOCK  : integer := 105;
        PKT_TRANS_COMPRESSED_READ: integer := 41;
        PKT_TRANS_POSTED: integer := 40;
        PKT_TRANS_WRITE : integer := 39;
        PKT_TRANS_READ  : integer := 38;
        PKT_DATA_H      : integer := 37;
        PKT_DATA_L      : integer := 6;
        PKT_BYTEEN_H    : integer := 5;
        PKT_BYTEEN_L    : integer := 2;
        PKT_SRC_ID_H    : integer := 1;
        PKT_SRC_ID_L    : integer := 1;
        PKT_DEST_ID_H   : integer := 0;
        PKT_DEST_ID_L   : integer := 0;
        PKT_ORI_BURST_SIZE_H: integer := 127;
        PKT_ORI_BURST_SIZE_L: integer := 125;
        ST_DATA_W       : integer := 128;
        ST_CHANNEL_W    : integer := 1;
        ID              : integer := 1;
        PKT_BURSTWRAP_W : vl_notype;
        PKT_BYTE_CNT_W  : vl_notype;
        PKT_ADDR_W      : vl_notype;
        PKT_DATA_W      : vl_notype;
        PKT_BYTEEN_W    : vl_notype;
        PKT_SRC_ID_W    : vl_notype;
        PKT_DEST_ID_W   : vl_notype
    );
    port(
        aclk            : in     vl_logic;
        aresetn         : in     vl_logic;
        awid            : in     vl_logic_vector;
        awaddr          : in     vl_logic_vector;
        awlen           : in     vl_logic_vector;
        awsize          : in     vl_logic_vector(2 downto 0);
        awburst         : in     vl_logic_vector(1 downto 0);
        awlock          : in     vl_logic_vector;
        awcache         : in     vl_logic_vector(3 downto 0);
        awprot          : in     vl_logic_vector(2 downto 0);
        awqos           : in     vl_logic_vector(3 downto 0);
        awregion        : in     vl_logic_vector(3 downto 0);
        awuser          : in     vl_logic_vector;
        awvalid         : in     vl_logic;
        awready         : out    vl_logic;
        wid             : in     vl_logic_vector;
        wdata           : in     vl_logic_vector;
        wstrb           : in     vl_logic_vector;
        wlast           : in     vl_logic;
        wvalid          : in     vl_logic;
        wuser           : in     vl_logic_vector;
        wready          : out    vl_logic;
        bid             : out    vl_logic_vector;
        bresp           : out    vl_logic_vector(1 downto 0);
        bvalid          : out    vl_logic;
        bready          : in     vl_logic;
        buser           : out    vl_logic_vector;
        arid            : in     vl_logic_vector;
        araddr          : in     vl_logic_vector;
        arlen           : in     vl_logic_vector;
        arsize          : in     vl_logic_vector(2 downto 0);
        arburst         : in     vl_logic_vector(1 downto 0);
        arlock          : in     vl_logic_vector;
        arcache         : in     vl_logic_vector(3 downto 0);
        arprot          : in     vl_logic_vector(2 downto 0);
        arqos           : in     vl_logic_vector(3 downto 0);
        arregion        : in     vl_logic_vector(3 downto 0);
        aruser          : in     vl_logic_vector;
        arvalid         : in     vl_logic;
        arready         : out    vl_logic;
        rid             : out    vl_logic_vector;
        rdata           : out    vl_logic_vector;
        rresp           : out    vl_logic_vector(1 downto 0);
        rlast           : out    vl_logic;
        rvalid          : out    vl_logic;
        rready          : in     vl_logic;
        ruser           : out    vl_logic_vector;
        write_cp_valid  : out    vl_logic;
        write_cp_data   : out    vl_logic_vector;
        write_cp_startofpacket: out    vl_logic;
        write_cp_endofpacket: out    vl_logic;
        write_cp_ready  : in     vl_logic;
        write_rp_valid  : in     vl_logic;
        write_rp_data   : in     vl_logic_vector;
        write_rp_channel: in     vl_logic_vector;
        write_rp_startofpacket: in     vl_logic;
        write_rp_endofpacket: in     vl_logic;
        write_rp_ready  : out    vl_logic;
        read_cp_valid   : out    vl_logic;
        read_cp_data    : out    vl_logic_vector;
        read_cp_startofpacket: out    vl_logic;
        read_cp_endofpacket: out    vl_logic;
        read_cp_ready   : in     vl_logic;
        read_rp_valid   : in     vl_logic;
        read_rp_data    : in     vl_logic_vector;
        read_rp_channel : in     vl_logic_vector;
        read_rp_startofpacket: in     vl_logic;
        read_rp_endofpacket: in     vl_logic;
        read_rp_ready   : out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of ID_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of RDATA_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of WDATA_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ADDR_USER_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of DATA_USER_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AXI_LOCK_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AXI_BURST_LENGTH_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of WRITE_ISSUING_CAPABILITY : constant is 1;
    attribute mti_svvh_generic_type of READ_ISSUING_CAPABILITY : constant is 1;
    attribute mti_svvh_generic_type of AXI_VERSION : constant is 1;
    attribute mti_svvh_generic_type of PKT_THREAD_ID_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_THREAD_ID_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_QOS_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_QOS_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BEGIN_BURST : constant is 1;
    attribute mti_svvh_generic_type of PKT_CACHE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_CACHE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_SIDEBAND_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_SIDEBAND_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_SIDEBAND_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_SIDEBAND_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_PROTECTION_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_PROTECTION_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_TYPE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURST_TYPE_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_RESPONSE_STATUS_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_RESPONSE_STATUS_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_ADDR_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_EXCLUSIVE : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_LOCK : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_COMPRESSED_READ : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_POSTED : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_WRITE : constant is 1;
    attribute mti_svvh_generic_type of PKT_TRANS_READ : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_DATA_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTEEN_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_BYTEEN_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_SRC_ID_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_SRC_ID_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_DEST_ID_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_DEST_ID_L : constant is 1;
    attribute mti_svvh_generic_type of PKT_ORI_BURST_SIZE_H : constant is 1;
    attribute mti_svvh_generic_type of PKT_ORI_BURST_SIZE_L : constant is 1;
    attribute mti_svvh_generic_type of ST_DATA_W : constant is 1;
    attribute mti_svvh_generic_type of ST_CHANNEL_W : constant is 1;
    attribute mti_svvh_generic_type of ID : constant is 1;
    attribute mti_svvh_generic_type of PKT_BURSTWRAP_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_BYTE_CNT_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_ADDR_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_DATA_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_BYTEEN_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_SRC_ID_W : constant is 3;
    attribute mti_svvh_generic_type of PKT_DEST_ID_W : constant is 3;
end altera_merlin_axi_master_ni;
