library verilog;
use verilog.vl_types.all;
entity altera_mem_if_hard_memory_controller_top_cyclonev is
    generic(
        AVL_SIZE_WIDTH  : integer := 0;
        AVL_ADDR_WIDTH  : integer := 0;
        AVL_DATA_WIDTH  : integer := 0;
        MEM_IF_CLK_PAIR_COUNT: integer := 0;
        MEM_IF_CS_WIDTH : integer := 0;
        MEM_IF_DQS_WIDTH: integer := 0;
        MEM_IF_CHIP_BITS: integer := 0;
        AFI_ADDR_WIDTH  : integer := 0;
        AFI_BANKADDR_WIDTH: integer := 0;
        AFI_CONTROL_WIDTH: integer := 0;
        AFI_CS_WIDTH    : integer := 0;
        AFI_ODT_WIDTH   : integer := 0;
        AFI_DM_WIDTH    : integer := 0;
        AFI_DQ_WIDTH    : integer := 0;
        AFI_WRITE_DQS_WIDTH: integer := 0;
        AFI_RATE_RATIO  : integer := 0;
        AFI_WLAT_WIDTH  : integer := 0;
        AFI_RLAT_WIDTH  : integer := 0;
        CSR_BE_WIDTH    : integer := 0;
        CSR_ADDR_WIDTH  : integer := 0;
        CSR_DATA_WIDTH  : integer := 0;
        AVL_DATA_WIDTH_PORT_0: integer := 0;
        AVL_DATA_WIDTH_PORT_1: integer := 0;
        AVL_DATA_WIDTH_PORT_2: integer := 0;
        AVL_DATA_WIDTH_PORT_3: integer := 0;
        AVL_DATA_WIDTH_PORT_4: integer := 0;
        AVL_DATA_WIDTH_PORT_5: integer := 0;
        AVL_ADDR_WIDTH_PORT_0: integer := 0;
        AVL_ADDR_WIDTH_PORT_1: integer := 0;
        AVL_ADDR_WIDTH_PORT_2: integer := 0;
        AVL_ADDR_WIDTH_PORT_3: integer := 0;
        AVL_ADDR_WIDTH_PORT_4: integer := 0;
        AVL_ADDR_WIDTH_PORT_5: integer := 0;
        AVL_NUM_SYMBOLS_PORT_0: integer := 0;
        AVL_NUM_SYMBOLS_PORT_1: integer := 0;
        AVL_NUM_SYMBOLS_PORT_2: integer := 0;
        AVL_NUM_SYMBOLS_PORT_3: integer := 0;
        AVL_NUM_SYMBOLS_PORT_4: integer := 0;
        AVL_NUM_SYMBOLS_PORT_5: integer := 0;
        LSB_WFIFO_PORT_0: integer := 5;
        MSB_WFIFO_PORT_0: integer := 5;
        LSB_RFIFO_PORT_0: integer := 5;
        MSB_RFIFO_PORT_0: integer := 5;
        LSB_WFIFO_PORT_1: integer := 5;
        MSB_WFIFO_PORT_1: integer := 5;
        LSB_RFIFO_PORT_1: integer := 5;
        MSB_RFIFO_PORT_1: integer := 5;
        LSB_WFIFO_PORT_2: integer := 5;
        MSB_WFIFO_PORT_2: integer := 5;
        LSB_RFIFO_PORT_2: integer := 5;
        MSB_RFIFO_PORT_2: integer := 5;
        LSB_WFIFO_PORT_3: integer := 5;
        MSB_WFIFO_PORT_3: integer := 5;
        LSB_RFIFO_PORT_3: integer := 5;
        MSB_RFIFO_PORT_3: integer := 5;
        LSB_WFIFO_PORT_4: integer := 5;
        MSB_WFIFO_PORT_4: integer := 5;
        LSB_RFIFO_PORT_4: integer := 5;
        MSB_RFIFO_PORT_4: integer := 5;
        LSB_WFIFO_PORT_5: integer := 5;
        MSB_WFIFO_PORT_5: integer := 5;
        LSB_RFIFO_PORT_5: integer := 5;
        MSB_RFIFO_PORT_5: integer := 5;
        HARD_PHY        : integer := 0;
        ENUM_ATTR_COUNTER_ONE_RESET: string  := "DISABLED";
        ENUM_ATTR_COUNTER_ZERO_RESET: string  := "DISABLED";
        ENUM_ATTR_STATIC_CONFIG_VALID: string  := "DISABLED";
        ENUM_AUTO_PCH_ENABLE_0: string  := "DISABLED";
        ENUM_AUTO_PCH_ENABLE_1: string  := "DISABLED";
        ENUM_AUTO_PCH_ENABLE_2: string  := "DISABLED";
        ENUM_AUTO_PCH_ENABLE_3: string  := "DISABLED";
        ENUM_AUTO_PCH_ENABLE_4: string  := "DISABLED";
        ENUM_AUTO_PCH_ENABLE_5: string  := "DISABLED";
        ENUM_CAL_REQ    : string  := "DISABLED";
        ENUM_CFG_BURST_LENGTH: string  := "BL_8";
        ENUM_CFG_INTERFACE_WIDTH: string  := "DWIDTH_32";
        ENUM_CFG_SELF_RFSH_EXIT_CYCLES: string  := "SELF_RFSH_EXIT_CYCLES_512";
        ENUM_CFG_STARVE_LIMIT: string  := "STARVE_LIMIT_32";
        ENUM_CFG_TYPE   : string  := "DDR3";
        ENUM_CLOCK_OFF_0: string  := "DISABLED";
        ENUM_CLOCK_OFF_1: string  := "DISABLED";
        ENUM_CLOCK_OFF_2: string  := "DISABLED";
        ENUM_CLOCK_OFF_3: string  := "DISABLED";
        ENUM_CLOCK_OFF_4: string  := "DISABLED";
        ENUM_CLOCK_OFF_5: string  := "DISABLED";
        ENUM_CLR_INTR   : string  := "NO_CLR_INTR";
        ENUM_CMD_PORT_IN_USE_0: string  := "FALSE";
        ENUM_CMD_PORT_IN_USE_1: string  := "FALSE";
        ENUM_CMD_PORT_IN_USE_2: string  := "FALSE";
        ENUM_CMD_PORT_IN_USE_3: string  := "FALSE";
        ENUM_CMD_PORT_IN_USE_4: string  := "FALSE";
        ENUM_CMD_PORT_IN_USE_5: string  := "FALSE";
        ENUM_CPORT0_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_CPORT0_RFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT0_TYPE: string  := "DISABLE";
        ENUM_CPORT0_WFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT1_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_CPORT1_RFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT1_TYPE: string  := "DISABLE";
        ENUM_CPORT1_WFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT2_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_CPORT2_RFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT2_TYPE: string  := "DISABLE";
        ENUM_CPORT2_WFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT3_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_CPORT3_RFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT3_TYPE: string  := "DISABLE";
        ENUM_CPORT3_WFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT4_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_CPORT4_RFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT4_TYPE: string  := "DISABLE";
        ENUM_CPORT4_WFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT5_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_CPORT5_RFIFO_MAP: string  := "FIFO_0";
        ENUM_CPORT5_TYPE: string  := "DISABLE";
        ENUM_CPORT5_WFIFO_MAP: string  := "FIFO_0";
        ENUM_CTL_ADDR_ORDER: string  := "CHIP_BANK_ROW_COL";
        ENUM_CTL_ECC_ENABLED: string  := "CTL_ECC_DISABLED";
        ENUM_CTL_ECC_RMW_ENABLED: string  := "CTL_ECC_RMW_DISABLED";
        ENUM_CTL_REGDIMM_ENABLED: string  := "REGDIMM_DISABLED";
        ENUM_CTL_USR_REFRESH: string  := "CTL_USR_REFRESH_DISABLED";
        ENUM_CTRL_WIDTH : string  := "DATA_WIDTH_64_BIT";
        ENUM_DELAY_BONDING: string  := "BONDING_LATENCY_0";
        ENUM_DFX_BYPASS_ENABLE: string  := "DFX_BYPASS_DISABLED";
        ENUM_DISABLE_MERGING: string  := "MERGING_ENABLED";
        ENUM_ECC_DQ_WIDTH: string  := "ECC_DQ_WIDTH_0";
        ENUM_ENABLE_ATPG: string  := "DISABLED";
        ENUM_ENABLE_BONDING_0: string  := "DISABLED";
        ENUM_ENABLE_BONDING_1: string  := "DISABLED";
        ENUM_ENABLE_BONDING_2: string  := "DISABLED";
        ENUM_ENABLE_BONDING_3: string  := "DISABLED";
        ENUM_ENABLE_BONDING_4: string  := "DISABLED";
        ENUM_ENABLE_BONDING_5: string  := "DISABLED";
        ENUM_ENABLE_BONDING_WRAPBACK: string  := "DISABLED";
        ENUM_ENABLE_DQS_TRACKING: string  := "DISABLED";
        ENUM_ENABLE_ECC_CODE_OVERWRITES: string  := "DISABLED";
        ENUM_ENABLE_FAST_EXIT_PPD: string  := "DISABLED";
        ENUM_ENABLE_INTR: string  := "DISABLED";
        ENUM_ENABLE_NO_DM: string  := "DISABLED";
        ENUM_ENABLE_PIPELINEGLOBAL: string  := "DISABLED";
        ENUM_GANGED_ARF : string  := "DISABLED";
        ENUM_GEN_DBE    : string  := "GEN_DBE_DISABLED";
        ENUM_GEN_SBE    : string  := "GEN_SBE_DISABLED";
        ENUM_INC_SYNC   : string  := "FIFO_SET_2";
        ENUM_LOCAL_IF_CS_WIDTH: string  := "ADDR_WIDTH_2";
        ENUM_MASK_CORR_DROPPED_INTR: string  := "DISABLED";
        ENUM_MASK_DBE_INTR: string  := "DISABLED";
        ENUM_MASK_SBE_INTR: string  := "DISABLED";
        ENUM_MEM_IF_AL  : string  := "AL_0";
        ENUM_MEM_IF_BANKADDR_WIDTH: string  := "ADDR_WIDTH_3";
        ENUM_MEM_IF_BURSTLENGTH: string  := "MEM_IF_BURSTLENGTH_8";
        ENUM_MEM_IF_COLADDR_WIDTH: string  := "ADDR_WIDTH_12";
        ENUM_MEM_IF_CS_PER_RANK: string  := "MEM_IF_CS_PER_RANK_1";
        ENUM_MEM_IF_CS_WIDTH: string  := "MEM_IF_CS_WIDTH_1";
        ENUM_MEM_IF_DQ_PER_CHIP: string  := "MEM_IF_DQ_PER_CHIP_8";
        ENUM_MEM_IF_DQS_WIDTH: string  := "DQS_WIDTH_4";
        ENUM_MEM_IF_DWIDTH: string  := "MEM_IF_DWIDTH_32";
        ENUM_MEM_IF_MEMTYPE: string  := "DDR3_SDRAM";
        ENUM_MEM_IF_ROWADDR_WIDTH: string  := "ADDR_WIDTH_16";
        ENUM_MEM_IF_SPEEDBIN: string  := "DDR3_1066_6_6_6";
        ENUM_MEM_IF_TCCD: string  := "TCCD_4";
        ENUM_MEM_IF_TCL : string  := "TCL_6";
        ENUM_MEM_IF_TCWL: string  := "TCWL_5";
        ENUM_MEM_IF_TFAW: string  := "TFAW_16";
        ENUM_MEM_IF_TMRD: string  := "TMRD_4";
        ENUM_MEM_IF_TRAS: string  := "TRAS_16";
        ENUM_MEM_IF_TRC : string  := "TRC_22";
        ENUM_MEM_IF_TRCD: string  := "TRCD_6";
        ENUM_MEM_IF_TRP : string  := "TRP_6";
        ENUM_MEM_IF_TRRD: string  := "TRRD_4";
        ENUM_MEM_IF_TRTP: string  := "TRTP_4";
        ENUM_MEM_IF_TWR : string  := "TWR_6";
        ENUM_MEM_IF_TWTR: string  := "TWTR_4";
        ENUM_MMR_CFG_MEM_BL: string  := "MP_BL_8";
        ENUM_OUTPUT_REGD: string  := "DISABLED";
        ENUM_PDN_EXIT_CYCLES: string  := "SLOW_EXIT";
        ENUM_PORT0_WIDTH: string  := "PORT_64_BIT";
        ENUM_PORT1_WIDTH: string  := "PORT_64_BIT";
        ENUM_PORT2_WIDTH: string  := "PORT_64_BIT";
        ENUM_PORT3_WIDTH: string  := "PORT_64_BIT";
        ENUM_PORT4_WIDTH: string  := "PORT_64_BIT";
        ENUM_PORT5_WIDTH: string  := "PORT_64_BIT";
        ENUM_PRIORITY_0_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_0_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_0_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_0_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_0_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_0_5: string  := "WEIGHT_0";
        ENUM_PRIORITY_1_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_1_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_1_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_1_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_1_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_1_5: string  := "WEIGHT_0";
        ENUM_PRIORITY_2_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_2_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_2_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_2_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_2_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_2_5: string  := "WEIGHT_0";
        ENUM_PRIORITY_3_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_3_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_3_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_3_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_3_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_3_5: string  := "WEIGHT_0";
        ENUM_PRIORITY_4_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_4_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_4_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_4_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_4_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_4_5: string  := "WEIGHT_0";
        ENUM_PRIORITY_5_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_5_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_5_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_5_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_5_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_5_5: string  := "WEIGHT_0";
        ENUM_PRIORITY_6_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_6_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_6_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_6_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_6_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_6_5: string  := "WEIGHT_0";
        ENUM_PRIORITY_7_0: string  := "WEIGHT_0";
        ENUM_PRIORITY_7_1: string  := "WEIGHT_0";
        ENUM_PRIORITY_7_2: string  := "WEIGHT_0";
        ENUM_PRIORITY_7_3: string  := "WEIGHT_0";
        ENUM_PRIORITY_7_4: string  := "WEIGHT_0";
        ENUM_PRIORITY_7_5: string  := "WEIGHT_0";
        ENUM_RCFG_STATIC_WEIGHT_0: string  := "WEIGHT_0";
        ENUM_RCFG_STATIC_WEIGHT_1: string  := "WEIGHT_0";
        ENUM_RCFG_STATIC_WEIGHT_2: string  := "WEIGHT_0";
        ENUM_RCFG_STATIC_WEIGHT_3: string  := "WEIGHT_0";
        ENUM_RCFG_STATIC_WEIGHT_4: string  := "WEIGHT_0";
        ENUM_RCFG_STATIC_WEIGHT_5: string  := "WEIGHT_0";
        ENUM_RCFG_USER_PRIORITY_0: string  := "PRIORITY_0";
        ENUM_RCFG_USER_PRIORITY_1: string  := "PRIORITY_0";
        ENUM_RCFG_USER_PRIORITY_2: string  := "PRIORITY_0";
        ENUM_RCFG_USER_PRIORITY_3: string  := "PRIORITY_0";
        ENUM_RCFG_USER_PRIORITY_4: string  := "PRIORITY_0";
        ENUM_RCFG_USER_PRIORITY_5: string  := "PRIORITY_0";
        ENUM_RD_DWIDTH_0: string  := "DWIDTH_0";
        ENUM_RD_DWIDTH_1: string  := "DWIDTH_0";
        ENUM_RD_DWIDTH_2: string  := "DWIDTH_0";
        ENUM_RD_DWIDTH_3: string  := "DWIDTH_0";
        ENUM_RD_DWIDTH_4: string  := "DWIDTH_0";
        ENUM_RD_DWIDTH_5: string  := "DWIDTH_0";
        ENUM_RD_FIFO_IN_USE_0: string  := "FALSE";
        ENUM_RD_FIFO_IN_USE_1: string  := "FALSE";
        ENUM_RD_FIFO_IN_USE_2: string  := "FALSE";
        ENUM_RD_FIFO_IN_USE_3: string  := "FALSE";
        ENUM_RD_PORT_INFO_0: string  := "USE_NO";
        ENUM_RD_PORT_INFO_1: string  := "USE_NO";
        ENUM_RD_PORT_INFO_2: string  := "USE_NO";
        ENUM_RD_PORT_INFO_3: string  := "USE_NO";
        ENUM_RD_PORT_INFO_4: string  := "USE_NO";
        ENUM_RD_PORT_INFO_5: string  := "USE_NO";
        ENUM_READ_ODT_CHIP: string  := "ODT_DISABLED";
        ENUM_REORDER_DATA: string  := "DATA_REORDERING";
        ENUM_RFIFO0_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_RFIFO1_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_RFIFO2_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_RFIFO3_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_SINGLE_READY_0: string  := "CONCATENATE_RDY";
        ENUM_SINGLE_READY_1: string  := "CONCATENATE_RDY";
        ENUM_SINGLE_READY_2: string  := "CONCATENATE_RDY";
        ENUM_SINGLE_READY_3: string  := "CONCATENATE_RDY";
        ENUM_STATIC_WEIGHT_0: string  := "WEIGHT_0";
        ENUM_STATIC_WEIGHT_1: string  := "WEIGHT_0";
        ENUM_STATIC_WEIGHT_2: string  := "WEIGHT_0";
        ENUM_STATIC_WEIGHT_3: string  := "WEIGHT_0";
        ENUM_STATIC_WEIGHT_4: string  := "WEIGHT_0";
        ENUM_STATIC_WEIGHT_5: string  := "WEIGHT_0";
        ENUM_SYNC_MODE_0: string  := "ASYNCHRONOUS";
        ENUM_SYNC_MODE_1: string  := "ASYNCHRONOUS";
        ENUM_SYNC_MODE_2: string  := "ASYNCHRONOUS";
        ENUM_SYNC_MODE_3: string  := "ASYNCHRONOUS";
        ENUM_SYNC_MODE_4: string  := "ASYNCHRONOUS";
        ENUM_SYNC_MODE_5: string  := "ASYNCHRONOUS";
        ENUM_TEST_MODE  : string  := "NORMAL_MODE";
        ENUM_THLD_JAR1_0: string  := "THRESHOLD_32";
        ENUM_THLD_JAR1_1: string  := "THRESHOLD_32";
        ENUM_THLD_JAR1_2: string  := "THRESHOLD_32";
        ENUM_THLD_JAR1_3: string  := "THRESHOLD_32";
        ENUM_THLD_JAR1_4: string  := "THRESHOLD_32";
        ENUM_THLD_JAR1_5: string  := "THRESHOLD_32";
        ENUM_THLD_JAR2_0: string  := "THRESHOLD_16";
        ENUM_THLD_JAR2_1: string  := "THRESHOLD_16";
        ENUM_THLD_JAR2_2: string  := "THRESHOLD_16";
        ENUM_THLD_JAR2_3: string  := "THRESHOLD_16";
        ENUM_THLD_JAR2_4: string  := "THRESHOLD_16";
        ENUM_THLD_JAR2_5: string  := "THRESHOLD_16";
        ENUM_USE_ALMOST_EMPTY_0: string  := "EMPTY";
        ENUM_USE_ALMOST_EMPTY_1: string  := "EMPTY";
        ENUM_USE_ALMOST_EMPTY_2: string  := "EMPTY";
        ENUM_USE_ALMOST_EMPTY_3: string  := "EMPTY";
        ENUM_USER_ECC_EN: string  := "DISABLE";
        ENUM_USER_PRIORITY_0: string  := "PRIORITY_0";
        ENUM_USER_PRIORITY_1: string  := "PRIORITY_0";
        ENUM_USER_PRIORITY_2: string  := "PRIORITY_0";
        ENUM_USER_PRIORITY_3: string  := "PRIORITY_0";
        ENUM_USER_PRIORITY_4: string  := "PRIORITY_0";
        ENUM_USER_PRIORITY_5: string  := "PRIORITY_0";
        ENUM_WFIFO0_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_WFIFO0_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_WFIFO1_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_WFIFO1_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_WFIFO2_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_WFIFO2_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_WFIFO3_CPORT_MAP: string  := "CMD_PORT_0";
        ENUM_WFIFO3_RDY_ALMOST_FULL: string  := "NOT_FULL";
        ENUM_WR_DWIDTH_0: string  := "DWIDTH_0";
        ENUM_WR_DWIDTH_1: string  := "DWIDTH_0";
        ENUM_WR_DWIDTH_2: string  := "DWIDTH_0";
        ENUM_WR_DWIDTH_3: string  := "DWIDTH_0";
        ENUM_WR_DWIDTH_4: string  := "DWIDTH_0";
        ENUM_WR_DWIDTH_5: string  := "DWIDTH_0";
        ENUM_WR_FIFO_IN_USE_0: string  := "FALSE";
        ENUM_WR_FIFO_IN_USE_1: string  := "FALSE";
        ENUM_WR_FIFO_IN_USE_2: string  := "FALSE";
        ENUM_WR_FIFO_IN_USE_3: string  := "FALSE";
        ENUM_WR_PORT_INFO_0: string  := "USE_NO";
        ENUM_WR_PORT_INFO_1: string  := "USE_NO";
        ENUM_WR_PORT_INFO_2: string  := "USE_NO";
        ENUM_WR_PORT_INFO_3: string  := "USE_NO";
        ENUM_WR_PORT_INFO_4: string  := "USE_NO";
        ENUM_WR_PORT_INFO_5: string  := "USE_NO";
        ENUM_WRITE_ODT_CHIP: string  := "ODT_DISABLED";
        ENUM_ENABLE_BURST_INTERRUPT: string  := "DISABLED";
        ENUM_ENABLE_BURST_TERMINATE: string  := "DISABLED";
        INTG_POWER_SAVING_EXIT_CYCLES: integer := 5;
        INTG_MEM_CLK_ENTRY_CYCLES: integer := 10;
        INTG_PRIORITY_REMAP: integer := 0;
        INTG_MEM_AUTO_PD_CYCLES: integer := 0;
        INTG_CYC_TO_RLD_JARS_0: integer := 128;
        INTG_CYC_TO_RLD_JARS_1: integer := 128;
        INTG_CYC_TO_RLD_JARS_2: integer := 128;
        INTG_CYC_TO_RLD_JARS_3: integer := 128;
        INTG_CYC_TO_RLD_JARS_4: integer := 128;
        INTG_CYC_TO_RLD_JARS_5: integer := 128;
        INTG_EXTRA_CTL_CLK_ACT_TO_ACT: integer := 0;
        INTG_EXTRA_CTL_CLK_ACT_TO_ACT_DIFF_BANK: integer := 0;
        INTG_EXTRA_CTL_CLK_ACT_TO_PCH: integer := 0;
        INTG_EXTRA_CTL_CLK_ACT_TO_RDWR: integer := 0;
        INTG_EXTRA_CTL_CLK_ARF_PERIOD: integer := 0;
        INTG_EXTRA_CTL_CLK_ARF_TO_VALID: integer := 0;
        INTG_EXTRA_CTL_CLK_FOUR_ACT_TO_ACT: integer := 0;
        INTG_EXTRA_CTL_CLK_PCH_ALL_TO_VALID: integer := 0;
        INTG_EXTRA_CTL_CLK_PCH_TO_VALID: integer := 0;
        INTG_EXTRA_CTL_CLK_PDN_PERIOD: integer := 0;
        INTG_EXTRA_CTL_CLK_PDN_TO_VALID: integer := 0;
        INTG_EXTRA_CTL_CLK_RD_AP_TO_VALID: integer := 0;
        INTG_EXTRA_CTL_CLK_RD_TO_PCH: integer := 0;
        INTG_EXTRA_CTL_CLK_RD_TO_RD: integer := 0;
        INTG_EXTRA_CTL_CLK_RD_TO_RD_DIFF_CHIP: integer := 0;
        INTG_EXTRA_CTL_CLK_RD_TO_WR: integer := 0;
        INTG_EXTRA_CTL_CLK_RD_TO_WR_BC: integer := 0;
        INTG_EXTRA_CTL_CLK_RD_TO_WR_DIFF_CHIP: integer := 0;
        INTG_EXTRA_CTL_CLK_SRF_TO_VALID: integer := 0;
        INTG_EXTRA_CTL_CLK_SRF_TO_ZQ_CAL: integer := 0;
        INTG_EXTRA_CTL_CLK_WR_AP_TO_VALID: integer := 0;
        INTG_EXTRA_CTL_CLK_WR_TO_PCH: integer := 0;
        INTG_EXTRA_CTL_CLK_WR_TO_RD: integer := 0;
        INTG_EXTRA_CTL_CLK_WR_TO_RD_BC: integer := 0;
        INTG_EXTRA_CTL_CLK_WR_TO_RD_DIFF_CHIP: integer := 0;
        INTG_EXTRA_CTL_CLK_WR_TO_WR: integer := 0;
        INTG_EXTRA_CTL_CLK_WR_TO_WR_DIFF_CHIP: integer := 0;
        INTG_MEM_IF_TREFI: integer := 3120;
        INTG_MEM_IF_TRFC: integer := 34;
        INTG_RCFG_SUM_WT_PRIORITY_0: integer := 0;
        INTG_RCFG_SUM_WT_PRIORITY_1: integer := 0;
        INTG_RCFG_SUM_WT_PRIORITY_2: integer := 0;
        INTG_RCFG_SUM_WT_PRIORITY_3: integer := 0;
        INTG_RCFG_SUM_WT_PRIORITY_4: integer := 0;
        INTG_RCFG_SUM_WT_PRIORITY_5: integer := 0;
        INTG_RCFG_SUM_WT_PRIORITY_6: integer := 0;
        INTG_RCFG_SUM_WT_PRIORITY_7: integer := 0;
        INTG_SUM_WT_PRIORITY_0: integer := 0;
        INTG_SUM_WT_PRIORITY_1: integer := 0;
        INTG_SUM_WT_PRIORITY_2: integer := 0;
        INTG_SUM_WT_PRIORITY_3: integer := 0;
        INTG_SUM_WT_PRIORITY_4: integer := 0;
        INTG_SUM_WT_PRIORITY_5: integer := 0;
        INTG_SUM_WT_PRIORITY_6: integer := 0;
        INTG_SUM_WT_PRIORITY_7: integer := 0;
        VECT_ATTR_COUNTER_ONE_MASK: vl_logic_vector(0 to 63) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0);
        VECT_ATTR_COUNTER_ONE_MATCH: vl_logic_vector(0 to 63) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0);
        VECT_ATTR_COUNTER_ZERO_MASK: vl_logic_vector(0 to 63) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0);
        VECT_ATTR_COUNTER_ZERO_MATCH: vl_logic_vector(0 to 63) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0);
        VECT_ATTR_DEBUG_SELECT_BYTE: integer := 0
    );
    port(
        afi_clk         : in     vl_logic;
        afi_half_clk    : in     vl_logic;
        ctl_clk         : in     vl_logic;
        mp_cmd_clk_0    : in     vl_logic;
        mp_cmd_clk_1    : in     vl_logic;
        mp_cmd_clk_2    : in     vl_logic;
        mp_cmd_clk_3    : in     vl_logic;
        mp_cmd_clk_4    : in     vl_logic;
        mp_cmd_clk_5    : in     vl_logic;
        mp_cmd_reset_n_0: in     vl_logic;
        mp_cmd_reset_n_1: in     vl_logic;
        mp_cmd_reset_n_2: in     vl_logic;
        mp_cmd_reset_n_3: in     vl_logic;
        mp_cmd_reset_n_4: in     vl_logic;
        mp_cmd_reset_n_5: in     vl_logic;
        mp_rfifo_clk_0  : in     vl_logic;
        mp_rfifo_clk_1  : in     vl_logic;
        mp_rfifo_clk_2  : in     vl_logic;
        mp_rfifo_clk_3  : in     vl_logic;
        mp_rfifo_reset_n_0: in     vl_logic;
        mp_rfifo_reset_n_1: in     vl_logic;
        mp_rfifo_reset_n_2: in     vl_logic;
        mp_rfifo_reset_n_3: in     vl_logic;
        mp_wfifo_clk_0  : in     vl_logic;
        mp_wfifo_clk_1  : in     vl_logic;
        mp_wfifo_clk_2  : in     vl_logic;
        mp_wfifo_clk_3  : in     vl_logic;
        mp_wfifo_reset_n_0: in     vl_logic;
        mp_wfifo_reset_n_1: in     vl_logic;
        mp_wfifo_reset_n_2: in     vl_logic;
        mp_wfifo_reset_n_3: in     vl_logic;
        csr_clk         : in     vl_logic;
        csr_reset_n     : in     vl_logic;
        afi_reset_n     : in     vl_logic;
        ctl_reset_n     : in     vl_logic;
        avl_ready_0     : out    vl_logic;
        avl_write_req_0 : in     vl_logic;
        avl_read_req_0  : in     vl_logic;
        avl_addr_0      : in     vl_logic_vector;
        avl_be_0        : in     vl_logic_vector;
        avl_wdata_0     : in     vl_logic_vector;
        avl_size_0      : in     vl_logic_vector;
        avl_burstbegin_0: in     vl_logic;
        avl_rdata_0     : out    vl_logic_vector;
        avl_rdata_valid_0: out    vl_logic;
        avl_ready_1     : out    vl_logic;
        avl_write_req_1 : in     vl_logic;
        avl_read_req_1  : in     vl_logic;
        avl_addr_1      : in     vl_logic_vector;
        avl_be_1        : in     vl_logic_vector;
        avl_wdata_1     : in     vl_logic_vector;
        avl_size_1      : in     vl_logic_vector;
        avl_burstbegin_1: in     vl_logic;
        avl_rdata_1     : out    vl_logic_vector;
        avl_rdata_valid_1: out    vl_logic;
        avl_ready_2     : out    vl_logic;
        avl_write_req_2 : in     vl_logic;
        avl_read_req_2  : in     vl_logic;
        avl_addr_2      : in     vl_logic_vector;
        avl_be_2        : in     vl_logic_vector;
        avl_wdata_2     : in     vl_logic_vector;
        avl_size_2      : in     vl_logic_vector;
        avl_burstbegin_2: in     vl_logic;
        avl_rdata_2     : out    vl_logic_vector;
        avl_rdata_valid_2: out    vl_logic;
        avl_ready_3     : out    vl_logic;
        avl_write_req_3 : in     vl_logic;
        avl_read_req_3  : in     vl_logic;
        avl_addr_3      : in     vl_logic_vector;
        avl_be_3        : in     vl_logic_vector;
        avl_wdata_3     : in     vl_logic_vector;
        avl_size_3      : in     vl_logic_vector;
        avl_burstbegin_3: in     vl_logic;
        avl_rdata_3     : out    vl_logic_vector;
        avl_rdata_valid_3: out    vl_logic;
        avl_ready_4     : out    vl_logic;
        avl_write_req_4 : in     vl_logic;
        avl_read_req_4  : in     vl_logic;
        avl_addr_4      : in     vl_logic_vector;
        avl_be_4        : in     vl_logic_vector;
        avl_wdata_4     : in     vl_logic_vector;
        avl_size_4      : in     vl_logic_vector;
        avl_burstbegin_4: in     vl_logic;
        avl_rdata_4     : out    vl_logic_vector;
        avl_rdata_valid_4: out    vl_logic;
        avl_ready_5     : out    vl_logic;
        avl_write_req_5 : in     vl_logic;
        avl_read_req_5  : in     vl_logic;
        avl_addr_5      : in     vl_logic_vector;
        avl_be_5        : in     vl_logic_vector;
        avl_wdata_5     : in     vl_logic_vector;
        avl_size_5      : in     vl_logic_vector;
        avl_burstbegin_5: in     vl_logic;
        avl_rdata_5     : out    vl_logic_vector;
        avl_rdata_valid_5: out    vl_logic;
        afi_rst_n       : out    vl_logic_vector;
        afi_cs_n        : out    vl_logic_vector;
        afi_cke         : out    vl_logic_vector;
        afi_odt         : out    vl_logic_vector;
        afi_addr        : out    vl_logic_vector;
        afi_ba          : out    vl_logic_vector;
        afi_ras_n       : out    vl_logic_vector;
        afi_cas_n       : out    vl_logic_vector;
        afi_we_n        : out    vl_logic_vector;
        afi_dqs_burst   : out    vl_logic_vector;
        afi_wdata_valid : out    vl_logic_vector;
        afi_wdata       : out    vl_logic_vector;
        afi_dm          : out    vl_logic_vector;
        afi_wlat        : in     vl_logic_vector;
        afi_rdata_en    : out    vl_logic_vector;
        afi_rdata_en_full: out    vl_logic_vector;
        afi_rdata       : in     vl_logic_vector;
        afi_rdata_valid : in     vl_logic_vector(0 downto 0);
        afi_rlat        : in     vl_logic_vector;
        afi_cal_success : in     vl_logic;
        afi_mem_clk_disable: out    vl_logic_vector;
        afi_ctl_refresh_done: out    vl_logic_vector;
        afi_seq_busy    : in     vl_logic_vector;
        afi_ctl_long_idle: out    vl_logic_vector;
        afi_cal_fail    : in     vl_logic;
        afi_cal_req     : out    vl_logic;
        afi_init_req    : out    vl_logic;
        cfg_dramconfig  : out    vl_logic_vector(23 downto 0);
        cfg_caswrlat    : out    vl_logic_vector(7 downto 0);
        cfg_addlat      : out    vl_logic_vector(7 downto 0);
        cfg_tcl         : out    vl_logic_vector(7 downto 0);
        cfg_trfc        : out    vl_logic_vector(7 downto 0);
        cfg_trefi       : out    vl_logic_vector(15 downto 0);
        cfg_twr         : out    vl_logic_vector(7 downto 0);
        cfg_tmrd        : out    vl_logic_vector(7 downto 0);
        cfg_coladdrwidth: out    vl_logic_vector(7 downto 0);
        cfg_rowaddrwidth: out    vl_logic_vector(7 downto 0);
        cfg_bankaddrwidth: out    vl_logic_vector(7 downto 0);
        cfg_csaddrwidth : out    vl_logic_vector(7 downto 0);
        cfg_interfacewidth: out    vl_logic_vector(7 downto 0);
        cfg_devicewidth : out    vl_logic_vector(7 downto 0);
        local_refresh_ack: out    vl_logic;
        local_powerdn_ack: out    vl_logic;
        local_self_rfsh_ack: out    vl_logic;
        local_deep_powerdn_ack: out    vl_logic;
        local_refresh_req: in     vl_logic;
        local_refresh_chip: in     vl_logic_vector;
        local_self_rfsh_req: in     vl_logic;
        local_self_rfsh_chip: in     vl_logic_vector;
        local_deep_powerdn_req: in     vl_logic;
        local_deep_powerdn_chip: in     vl_logic_vector;
        local_multicast : in     vl_logic;
        local_priority  : in     vl_logic;
        local_init_done : out    vl_logic;
        local_cal_success: out    vl_logic;
        local_cal_fail  : out    vl_logic;
        csr_read_req    : in     vl_logic;
        csr_write_req   : in     vl_logic;
        csr_addr        : in     vl_logic_vector;
        csr_wdata       : in     vl_logic_vector;
        csr_rdata       : out    vl_logic_vector;
        csr_be          : in     vl_logic_vector;
        csr_rdata_valid : out    vl_logic;
        csr_waitrequest : out    vl_logic;
        bonding_out_1   : out    vl_logic_vector(3 downto 0);
        bonding_in_1    : in     vl_logic_vector(3 downto 0);
        bonding_out_2   : out    vl_logic_vector(5 downto 0);
        bonding_in_2    : in     vl_logic_vector(5 downto 0);
        bonding_out_3   : out    vl_logic_vector(5 downto 0);
        bonding_in_3    : in     vl_logic_vector(5 downto 0);
        io_intaficalfail: in     vl_logic;
        ctl_init_req    : out    vl_logic;
        local_sts_ctl_empty: out    vl_logic;
        io_intaficalsuccess: in     vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of AVL_SIZE_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AVL_ADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AVL_DATA_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_IF_CLK_PAIR_COUNT : constant is 1;
    attribute mti_svvh_generic_type of MEM_IF_CS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_IF_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of MEM_IF_CHIP_BITS : constant is 1;
    attribute mti_svvh_generic_type of AFI_ADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_BANKADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_CS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_ODT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_DM_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_DQ_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_WRITE_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_RATE_RATIO : constant is 1;
    attribute mti_svvh_generic_type of AFI_WLAT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AFI_RLAT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of CSR_BE_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of CSR_ADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of CSR_DATA_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of AVL_DATA_WIDTH_PORT_0 : constant is 1;
    attribute mti_svvh_generic_type of AVL_DATA_WIDTH_PORT_1 : constant is 1;
    attribute mti_svvh_generic_type of AVL_DATA_WIDTH_PORT_2 : constant is 1;
    attribute mti_svvh_generic_type of AVL_DATA_WIDTH_PORT_3 : constant is 1;
    attribute mti_svvh_generic_type of AVL_DATA_WIDTH_PORT_4 : constant is 1;
    attribute mti_svvh_generic_type of AVL_DATA_WIDTH_PORT_5 : constant is 1;
    attribute mti_svvh_generic_type of AVL_ADDR_WIDTH_PORT_0 : constant is 1;
    attribute mti_svvh_generic_type of AVL_ADDR_WIDTH_PORT_1 : constant is 1;
    attribute mti_svvh_generic_type of AVL_ADDR_WIDTH_PORT_2 : constant is 1;
    attribute mti_svvh_generic_type of AVL_ADDR_WIDTH_PORT_3 : constant is 1;
    attribute mti_svvh_generic_type of AVL_ADDR_WIDTH_PORT_4 : constant is 1;
    attribute mti_svvh_generic_type of AVL_ADDR_WIDTH_PORT_5 : constant is 1;
    attribute mti_svvh_generic_type of AVL_NUM_SYMBOLS_PORT_0 : constant is 1;
    attribute mti_svvh_generic_type of AVL_NUM_SYMBOLS_PORT_1 : constant is 1;
    attribute mti_svvh_generic_type of AVL_NUM_SYMBOLS_PORT_2 : constant is 1;
    attribute mti_svvh_generic_type of AVL_NUM_SYMBOLS_PORT_3 : constant is 1;
    attribute mti_svvh_generic_type of AVL_NUM_SYMBOLS_PORT_4 : constant is 1;
    attribute mti_svvh_generic_type of AVL_NUM_SYMBOLS_PORT_5 : constant is 1;
    attribute mti_svvh_generic_type of LSB_WFIFO_PORT_0 : constant is 1;
    attribute mti_svvh_generic_type of MSB_WFIFO_PORT_0 : constant is 1;
    attribute mti_svvh_generic_type of LSB_RFIFO_PORT_0 : constant is 1;
    attribute mti_svvh_generic_type of MSB_RFIFO_PORT_0 : constant is 1;
    attribute mti_svvh_generic_type of LSB_WFIFO_PORT_1 : constant is 1;
    attribute mti_svvh_generic_type of MSB_WFIFO_PORT_1 : constant is 1;
    attribute mti_svvh_generic_type of LSB_RFIFO_PORT_1 : constant is 1;
    attribute mti_svvh_generic_type of MSB_RFIFO_PORT_1 : constant is 1;
    attribute mti_svvh_generic_type of LSB_WFIFO_PORT_2 : constant is 1;
    attribute mti_svvh_generic_type of MSB_WFIFO_PORT_2 : constant is 1;
    attribute mti_svvh_generic_type of LSB_RFIFO_PORT_2 : constant is 1;
    attribute mti_svvh_generic_type of MSB_RFIFO_PORT_2 : constant is 1;
    attribute mti_svvh_generic_type of LSB_WFIFO_PORT_3 : constant is 1;
    attribute mti_svvh_generic_type of MSB_WFIFO_PORT_3 : constant is 1;
    attribute mti_svvh_generic_type of LSB_RFIFO_PORT_3 : constant is 1;
    attribute mti_svvh_generic_type of MSB_RFIFO_PORT_3 : constant is 1;
    attribute mti_svvh_generic_type of LSB_WFIFO_PORT_4 : constant is 1;
    attribute mti_svvh_generic_type of MSB_WFIFO_PORT_4 : constant is 1;
    attribute mti_svvh_generic_type of LSB_RFIFO_PORT_4 : constant is 1;
    attribute mti_svvh_generic_type of MSB_RFIFO_PORT_4 : constant is 1;
    attribute mti_svvh_generic_type of LSB_WFIFO_PORT_5 : constant is 1;
    attribute mti_svvh_generic_type of MSB_WFIFO_PORT_5 : constant is 1;
    attribute mti_svvh_generic_type of LSB_RFIFO_PORT_5 : constant is 1;
    attribute mti_svvh_generic_type of MSB_RFIFO_PORT_5 : constant is 1;
    attribute mti_svvh_generic_type of HARD_PHY : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ATTR_COUNTER_ONE_RESET : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ATTR_COUNTER_ZERO_RESET : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ATTR_STATIC_CONFIG_VALID : constant is 1;
    attribute mti_svvh_generic_type of ENUM_AUTO_PCH_ENABLE_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_AUTO_PCH_ENABLE_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_AUTO_PCH_ENABLE_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_AUTO_PCH_ENABLE_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_AUTO_PCH_ENABLE_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_AUTO_PCH_ENABLE_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CAL_REQ : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CFG_BURST_LENGTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CFG_INTERFACE_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CFG_SELF_RFSH_EXIT_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CFG_STARVE_LIMIT : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CFG_TYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CLOCK_OFF_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CLOCK_OFF_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CLOCK_OFF_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CLOCK_OFF_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CLOCK_OFF_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CLOCK_OFF_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CLR_INTR : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CMD_PORT_IN_USE_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CMD_PORT_IN_USE_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CMD_PORT_IN_USE_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CMD_PORT_IN_USE_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CMD_PORT_IN_USE_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CMD_PORT_IN_USE_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT0_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT0_RFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT0_TYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT0_WFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT1_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT1_RFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT1_TYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT1_WFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT2_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT2_RFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT2_TYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT2_WFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT3_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT3_RFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT3_TYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT3_WFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT4_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT4_RFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT4_TYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT4_WFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT5_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT5_RFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT5_TYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CPORT5_WFIFO_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CTL_ADDR_ORDER : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CTL_ECC_ENABLED : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CTL_ECC_RMW_ENABLED : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CTL_REGDIMM_ENABLED : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CTL_USR_REFRESH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_CTRL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_DELAY_BONDING : constant is 1;
    attribute mti_svvh_generic_type of ENUM_DFX_BYPASS_ENABLE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_DISABLE_MERGING : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ECC_DQ_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_ATPG : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BONDING_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BONDING_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BONDING_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BONDING_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BONDING_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BONDING_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BONDING_WRAPBACK : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_DQS_TRACKING : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_ECC_CODE_OVERWRITES : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_FAST_EXIT_PPD : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_INTR : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_NO_DM : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_PIPELINEGLOBAL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_GANGED_ARF : constant is 1;
    attribute mti_svvh_generic_type of ENUM_GEN_DBE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_GEN_SBE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_INC_SYNC : constant is 1;
    attribute mti_svvh_generic_type of ENUM_LOCAL_IF_CS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MASK_CORR_DROPPED_INTR : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MASK_DBE_INTR : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MASK_SBE_INTR : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_AL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_BANKADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_BURSTLENGTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_COLADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_CS_PER_RANK : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_CS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_DQ_PER_CHIP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_DQS_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_DWIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_MEMTYPE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_ROWADDR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_SPEEDBIN : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TCCD : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TCL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TCWL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TFAW : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TMRD : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TRAS : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TRC : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TRCD : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TRP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TRRD : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TRTP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TWR : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MEM_IF_TWTR : constant is 1;
    attribute mti_svvh_generic_type of ENUM_MMR_CFG_MEM_BL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_OUTPUT_REGD : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PDN_EXIT_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PORT0_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PORT1_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PORT2_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PORT3_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PORT4_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PORT5_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_0_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_0_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_0_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_0_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_0_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_0_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_1_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_1_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_1_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_1_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_1_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_1_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_2_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_2_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_2_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_2_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_2_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_2_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_3_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_3_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_3_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_3_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_3_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_3_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_4_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_4_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_4_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_4_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_4_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_4_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_5_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_5_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_5_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_5_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_5_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_5_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_6_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_6_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_6_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_6_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_6_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_6_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_7_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_7_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_7_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_7_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_7_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_PRIORITY_7_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_STATIC_WEIGHT_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_STATIC_WEIGHT_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_STATIC_WEIGHT_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_STATIC_WEIGHT_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_STATIC_WEIGHT_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_STATIC_WEIGHT_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_USER_PRIORITY_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_USER_PRIORITY_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_USER_PRIORITY_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_USER_PRIORITY_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_USER_PRIORITY_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RCFG_USER_PRIORITY_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_DWIDTH_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_DWIDTH_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_DWIDTH_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_DWIDTH_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_DWIDTH_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_DWIDTH_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_FIFO_IN_USE_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_FIFO_IN_USE_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_FIFO_IN_USE_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_FIFO_IN_USE_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_PORT_INFO_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_PORT_INFO_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_PORT_INFO_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_PORT_INFO_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_PORT_INFO_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RD_PORT_INFO_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_READ_ODT_CHIP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_REORDER_DATA : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RFIFO0_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RFIFO1_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RFIFO2_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_RFIFO3_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SINGLE_READY_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SINGLE_READY_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SINGLE_READY_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SINGLE_READY_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_STATIC_WEIGHT_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_STATIC_WEIGHT_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_STATIC_WEIGHT_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_STATIC_WEIGHT_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_STATIC_WEIGHT_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_STATIC_WEIGHT_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SYNC_MODE_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SYNC_MODE_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SYNC_MODE_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SYNC_MODE_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SYNC_MODE_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_SYNC_MODE_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_TEST_MODE : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR1_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR1_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR1_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR1_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR1_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR1_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR2_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR2_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR2_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR2_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR2_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_THLD_JAR2_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USE_ALMOST_EMPTY_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USE_ALMOST_EMPTY_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USE_ALMOST_EMPTY_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USE_ALMOST_EMPTY_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USER_ECC_EN : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USER_PRIORITY_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USER_PRIORITY_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USER_PRIORITY_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USER_PRIORITY_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USER_PRIORITY_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_USER_PRIORITY_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO0_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO0_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO1_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO1_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO2_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO2_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO3_CPORT_MAP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WFIFO3_RDY_ALMOST_FULL : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_DWIDTH_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_DWIDTH_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_DWIDTH_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_DWIDTH_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_DWIDTH_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_DWIDTH_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_FIFO_IN_USE_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_FIFO_IN_USE_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_FIFO_IN_USE_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_FIFO_IN_USE_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_PORT_INFO_0 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_PORT_INFO_1 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_PORT_INFO_2 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_PORT_INFO_3 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_PORT_INFO_4 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WR_PORT_INFO_5 : constant is 1;
    attribute mti_svvh_generic_type of ENUM_WRITE_ODT_CHIP : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BURST_INTERRUPT : constant is 1;
    attribute mti_svvh_generic_type of ENUM_ENABLE_BURST_TERMINATE : constant is 1;
    attribute mti_svvh_generic_type of INTG_POWER_SAVING_EXIT_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of INTG_MEM_CLK_ENTRY_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of INTG_PRIORITY_REMAP : constant is 1;
    attribute mti_svvh_generic_type of INTG_MEM_AUTO_PD_CYCLES : constant is 1;
    attribute mti_svvh_generic_type of INTG_CYC_TO_RLD_JARS_0 : constant is 1;
    attribute mti_svvh_generic_type of INTG_CYC_TO_RLD_JARS_1 : constant is 1;
    attribute mti_svvh_generic_type of INTG_CYC_TO_RLD_JARS_2 : constant is 1;
    attribute mti_svvh_generic_type of INTG_CYC_TO_RLD_JARS_3 : constant is 1;
    attribute mti_svvh_generic_type of INTG_CYC_TO_RLD_JARS_4 : constant is 1;
    attribute mti_svvh_generic_type of INTG_CYC_TO_RLD_JARS_5 : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_ACT_TO_ACT : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_ACT_TO_ACT_DIFF_BANK : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_ACT_TO_PCH : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_ACT_TO_RDWR : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_ARF_PERIOD : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_ARF_TO_VALID : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_FOUR_ACT_TO_ACT : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_PCH_ALL_TO_VALID : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_PCH_TO_VALID : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_PDN_PERIOD : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_PDN_TO_VALID : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_RD_AP_TO_VALID : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_RD_TO_PCH : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_RD_TO_RD : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_RD_TO_RD_DIFF_CHIP : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_RD_TO_WR : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_RD_TO_WR_BC : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_RD_TO_WR_DIFF_CHIP : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_SRF_TO_VALID : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_SRF_TO_ZQ_CAL : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_WR_AP_TO_VALID : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_WR_TO_PCH : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_WR_TO_RD : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_WR_TO_RD_BC : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_WR_TO_RD_DIFF_CHIP : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_WR_TO_WR : constant is 1;
    attribute mti_svvh_generic_type of INTG_EXTRA_CTL_CLK_WR_TO_WR_DIFF_CHIP : constant is 1;
    attribute mti_svvh_generic_type of INTG_MEM_IF_TREFI : constant is 1;
    attribute mti_svvh_generic_type of INTG_MEM_IF_TRFC : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_0 : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_1 : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_2 : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_3 : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_4 : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_5 : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_6 : constant is 1;
    attribute mti_svvh_generic_type of INTG_RCFG_SUM_WT_PRIORITY_7 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_0 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_1 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_2 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_3 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_4 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_5 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_6 : constant is 1;
    attribute mti_svvh_generic_type of INTG_SUM_WT_PRIORITY_7 : constant is 1;
    attribute mti_svvh_generic_type of VECT_ATTR_COUNTER_ONE_MASK : constant is 1;
    attribute mti_svvh_generic_type of VECT_ATTR_COUNTER_ONE_MATCH : constant is 1;
    attribute mti_svvh_generic_type of VECT_ATTR_COUNTER_ZERO_MASK : constant is 1;
    attribute mti_svvh_generic_type of VECT_ATTR_COUNTER_ZERO_MATCH : constant is 1;
    attribute mti_svvh_generic_type of VECT_ATTR_DEBUG_SELECT_BYTE : constant is 1;
end altera_mem_if_hard_memory_controller_top_cyclonev;
