library verilog;
use verilog.vl_types.all;
entity altera_avalon_sc_fifo is
    generic(
        SYMBOLS_PER_BEAT: integer := 1;
        BITS_PER_SYMBOL : integer := 8;
        FIFO_DEPTH      : integer := 16;
        CHANNEL_WIDTH   : integer := 0;
        ERROR_WIDTH     : integer := 0;
        USE_PACKETS     : integer := 0;
        USE_FILL_LEVEL  : integer := 0;
        USE_STORE_FORWARD: integer := 0;
        USE_ALMOST_FULL_IF: integer := 0;
        USE_ALMOST_EMPTY_IF: integer := 0;
        EMPTY_LATENCY   : integer := 3;
        USE_MEMORY_BLOCKS: integer := 1;
        DATA_WIDTH      : vl_notype;
        EMPTY_WIDTH     : vl_notype
    );
    port(
        clk             : in     vl_logic;
        reset           : in     vl_logic;
        in_data         : in     vl_logic_vector;
        in_valid        : in     vl_logic;
        in_startofpacket: in     vl_logic;
        in_endofpacket  : in     vl_logic;
        in_empty        : in     vl_logic_vector;
        in_error        : in     vl_logic_vector;
        in_channel      : in     vl_logic_vector;
        in_ready        : out    vl_logic;
        out_data        : out    vl_logic_vector;
        out_valid       : out    vl_logic;
        out_startofpacket: out    vl_logic;
        out_endofpacket : out    vl_logic;
        out_empty       : out    vl_logic_vector;
        out_error       : out    vl_logic_vector;
        out_channel     : out    vl_logic_vector;
        out_ready       : in     vl_logic;
        csr_address     : in     vl_logic_vector;
        csr_write       : in     vl_logic;
        csr_read        : in     vl_logic;
        csr_writedata   : in     vl_logic_vector(31 downto 0);
        csr_readdata    : out    vl_logic_vector(31 downto 0);
        almost_full_data: out    vl_logic;
        almost_empty_data: out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of SYMBOLS_PER_BEAT : constant is 1;
    attribute mti_svvh_generic_type of BITS_PER_SYMBOL : constant is 1;
    attribute mti_svvh_generic_type of FIFO_DEPTH : constant is 1;
    attribute mti_svvh_generic_type of CHANNEL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of ERROR_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of USE_PACKETS : constant is 1;
    attribute mti_svvh_generic_type of USE_FILL_LEVEL : constant is 1;
    attribute mti_svvh_generic_type of USE_STORE_FORWARD : constant is 1;
    attribute mti_svvh_generic_type of USE_ALMOST_FULL_IF : constant is 1;
    attribute mti_svvh_generic_type of USE_ALMOST_EMPTY_IF : constant is 1;
    attribute mti_svvh_generic_type of EMPTY_LATENCY : constant is 1;
    attribute mti_svvh_generic_type of USE_MEMORY_BLOCKS : constant is 1;
    attribute mti_svvh_generic_type of DATA_WIDTH : constant is 3;
    attribute mti_svvh_generic_type of EMPTY_WIDTH : constant is 3;
end altera_avalon_sc_fifo;
