library verilog;
use verilog.vl_types.all;
entity altdq_dqs2_acv_connect_to_hard_phy_cyclonev is
    generic(
        PIN_WIDTH       : integer := 8;
        PIN_TYPE        : string  := "bidir";
        USE_INPUT_PHASE_ALIGNMENT: string  := "false";
        USE_OUTPUT_PHASE_ALIGNMENT: string  := "false";
        USE_HALF_RATE_INPUT: string  := "false";
        USE_HALF_RATE_OUTPUT: string  := "false";
        DIFFERENTIAL_CAPTURE_STROBE: string  := "false";
        SEPARATE_CAPTURE_STROBE: string  := "false";
        INPUT_FREQ      : real    := 0.000000;
        INPUT_FREQ_PS   : string  := "0 ps";
        DELAY_CHAIN_BUFFER_MODE: string  := "high";
        DQS_PHASE_SETTING: integer := 3;
        DQS_PHASE_SHIFT : integer := 9000;
        DQS_ENABLE_PHASE_SETTING: integer := 2;
        USE_DYNAMIC_CONFIG: string  := "true";
        INVERT_CAPTURE_STROBE: string  := "false";
        SWAP_CAPTURE_STROBE_POLARITY: string  := "false";
        USE_TERMINATION_CONTROL: string  := "false";
        USE_OCT_ENA_IN_FOR_OCT: string  := "false";
        USE_DQS_ENABLE  : string  := "false";
        USE_IO_CONFIG   : string  := "false";
        USE_DQS_CONFIG  : string  := "false";
        USE_OFFSET_CTRL : string  := "false";
        HR_DDIO_OUT_HAS_THREE_REGS: string  := "true";
        USE_OUTPUT_STROBE: string  := "true";
        DIFFERENTIAL_OUTPUT_STROBE: string  := "false";
        USE_OUTPUT_STROBE_RESET: string  := "true";
        USE_BIDIR_STROBE: string  := "false";
        REVERSE_READ_WORDS: string  := "false";
        NATURAL_ALIGNMENT: string  := "false";
        EXTRA_OUTPUT_WIDTH: integer := 0;
        PREAMBLE_TYPE   : string  := "none";
        USE_DATA_OE_FOR_OCT: string  := "false";
        DQS_ENABLE_WIDTH: integer := 1;
        EMIF_UNALIGNED_PREAMBLE_SUPPORT: string  := "false";
        USE_2X_FF       : string  := "false";
        USE_DQS_TRACKING: string  := "false";
        SEPERATE_LDC_FOR_WRITE_STROBE: string  := "false";
        DQS_ENABLE_PHASECTRL: string  := "true";
        DYNAMIC_MODE    : string  := "dynamic";
        OCT_SERIES_TERM_CONTROL_WIDTH: integer := 16;
        OCT_PARALLEL_TERM_CONTROL_WIDTH: integer := 16;
        DLL_WIDTH       : integer := 6;
        REGULAR_WRITE_BUS_ORDERING: string  := "true";
        ALTERA_ALTDQ_DQS2_FAST_SIM_MODEL: integer := 0;
        USE_HARD_FIFOS  : string  := "false";
        CALIBRATION_SUPPORT: string  := "false";
        USE_DQSIN_FOR_VFIFO_READ: string  := "false";
        HHP_HPS         : string  := "false";
        USE_LDC_AS_LOW_SKEW_CLOCK: string  := "false";
        DLL_USE_2X_CLK  : string  := "false";
        DQS_ENABLE_AFTER_T7: string  := "true";
        LFIFO_OCT_EN_MASK: integer := -1
    );
    port(
        dll_delayctrl_in: in     vl_logic_vector;
        dll_offsetdelay_in: in     vl_logic_vector;
        capture_strobe_in: in     vl_logic;
        capture_strobe_n_in: in     vl_logic;
        capture_strobe_ena: in     vl_logic_vector;
        capture_strobe_out: out    vl_logic;
        output_strobe_ena: in     vl_logic_vector;
        output_strobe_out: out    vl_logic;
        output_strobe_n_out: out    vl_logic;
        oct_ena_in      : in     vl_logic_vector(1 downto 0);
        strobe_io       : inout  vl_logic;
        strobe_n_io     : inout  vl_logic;
        core_clock_in   : in     vl_logic;
        fr_clock_in     : in     vl_logic;
        hr_clock_in     : in     vl_logic;
        dr_clock_in     : in     vl_logic;
        strobe_ena_hr_clock_in: in     vl_logic;
        write_strobe_clock_in: in     vl_logic;
        write_strobe    : in     vl_logic_vector(3 downto 0);
        reset_n_core_clock_in: in     vl_logic;
        parallelterminationcontrol_in: in     vl_logic_vector;
        seriesterminationcontrol_in: in     vl_logic_vector;
        read_data_in    : in     vl_logic_vector;
        write_data_out  : out    vl_logic_vector;
        read_write_data_io: inout  vl_logic_vector;
        write_oe_in     : in     vl_logic_vector;
        read_data_out   : out    vl_logic_vector;
        write_data_in   : in     vl_logic_vector;
        extra_write_data_in: in     vl_logic_vector;
        extra_write_data_out: out    vl_logic_vector;
        capture_strobe_tracking: out    vl_logic;
        lfifo_rdata_en  : in     vl_logic_vector;
        lfifo_rdata_en_full: in     vl_logic_vector;
        lfifo_rd_latency: in     vl_logic_vector(4 downto 0);
        lfifo_reset_n   : in     vl_logic;
        lfifo_rdata_valid: out    vl_logic;
        vfifo_qvld      : in     vl_logic_vector;
        vfifo_inc_wr_ptr: in     vl_logic_vector;
        vfifo_reset_n   : in     vl_logic;
        rfifo_reset_n   : in     vl_logic;
        config_data_in  : in     vl_logic;
        config_dqs_ena  : in     vl_logic;
        config_io_ena   : in     vl_logic_vector;
        config_extra_io_ena: in     vl_logic_vector;
        config_dqs_io_ena: in     vl_logic;
        config_update   : in     vl_logic;
        config_clock_in : in     vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of PIN_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of PIN_TYPE : constant is 1;
    attribute mti_svvh_generic_type of USE_INPUT_PHASE_ALIGNMENT : constant is 1;
    attribute mti_svvh_generic_type of USE_OUTPUT_PHASE_ALIGNMENT : constant is 1;
    attribute mti_svvh_generic_type of USE_HALF_RATE_INPUT : constant is 1;
    attribute mti_svvh_generic_type of USE_HALF_RATE_OUTPUT : constant is 1;
    attribute mti_svvh_generic_type of DIFFERENTIAL_CAPTURE_STROBE : constant is 1;
    attribute mti_svvh_generic_type of SEPARATE_CAPTURE_STROBE : constant is 1;
    attribute mti_svvh_generic_type of INPUT_FREQ : constant is 1;
    attribute mti_svvh_generic_type of INPUT_FREQ_PS : constant is 1;
    attribute mti_svvh_generic_type of DELAY_CHAIN_BUFFER_MODE : constant is 1;
    attribute mti_svvh_generic_type of DQS_PHASE_SETTING : constant is 1;
    attribute mti_svvh_generic_type of DQS_PHASE_SHIFT : constant is 1;
    attribute mti_svvh_generic_type of DQS_ENABLE_PHASE_SETTING : constant is 1;
    attribute mti_svvh_generic_type of USE_DYNAMIC_CONFIG : constant is 1;
    attribute mti_svvh_generic_type of INVERT_CAPTURE_STROBE : constant is 1;
    attribute mti_svvh_generic_type of SWAP_CAPTURE_STROBE_POLARITY : constant is 1;
    attribute mti_svvh_generic_type of USE_TERMINATION_CONTROL : constant is 1;
    attribute mti_svvh_generic_type of USE_OCT_ENA_IN_FOR_OCT : constant is 1;
    attribute mti_svvh_generic_type of USE_DQS_ENABLE : constant is 1;
    attribute mti_svvh_generic_type of USE_IO_CONFIG : constant is 1;
    attribute mti_svvh_generic_type of USE_DQS_CONFIG : constant is 1;
    attribute mti_svvh_generic_type of USE_OFFSET_CTRL : constant is 1;
    attribute mti_svvh_generic_type of HR_DDIO_OUT_HAS_THREE_REGS : constant is 1;
    attribute mti_svvh_generic_type of USE_OUTPUT_STROBE : constant is 1;
    attribute mti_svvh_generic_type of DIFFERENTIAL_OUTPUT_STROBE : constant is 1;
    attribute mti_svvh_generic_type of USE_OUTPUT_STROBE_RESET : constant is 1;
    attribute mti_svvh_generic_type of USE_BIDIR_STROBE : constant is 1;
    attribute mti_svvh_generic_type of REVERSE_READ_WORDS : constant is 1;
    attribute mti_svvh_generic_type of NATURAL_ALIGNMENT : constant is 1;
    attribute mti_svvh_generic_type of EXTRA_OUTPUT_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of PREAMBLE_TYPE : constant is 1;
    attribute mti_svvh_generic_type of USE_DATA_OE_FOR_OCT : constant is 1;
    attribute mti_svvh_generic_type of DQS_ENABLE_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of EMIF_UNALIGNED_PREAMBLE_SUPPORT : constant is 1;
    attribute mti_svvh_generic_type of USE_2X_FF : constant is 1;
    attribute mti_svvh_generic_type of USE_DQS_TRACKING : constant is 1;
    attribute mti_svvh_generic_type of SEPERATE_LDC_FOR_WRITE_STROBE : constant is 1;
    attribute mti_svvh_generic_type of DQS_ENABLE_PHASECTRL : constant is 1;
    attribute mti_svvh_generic_type of DYNAMIC_MODE : constant is 1;
    attribute mti_svvh_generic_type of OCT_SERIES_TERM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of OCT_PARALLEL_TERM_CONTROL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of DLL_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of REGULAR_WRITE_BUS_ORDERING : constant is 1;
    attribute mti_svvh_generic_type of ALTERA_ALTDQ_DQS2_FAST_SIM_MODEL : constant is 1;
    attribute mti_svvh_generic_type of USE_HARD_FIFOS : constant is 1;
    attribute mti_svvh_generic_type of CALIBRATION_SUPPORT : constant is 1;
    attribute mti_svvh_generic_type of USE_DQSIN_FOR_VFIFO_READ : constant is 1;
    attribute mti_svvh_generic_type of HHP_HPS : constant is 1;
    attribute mti_svvh_generic_type of USE_LDC_AS_LOW_SKEW_CLOCK : constant is 1;
    attribute mti_svvh_generic_type of DLL_USE_2X_CLK : constant is 1;
    attribute mti_svvh_generic_type of DQS_ENABLE_AFTER_T7 : constant is 1;
    attribute mti_svvh_generic_type of LFIFO_OCT_EN_MASK : constant is 1;
end altdq_dqs2_acv_connect_to_hard_phy_cyclonev;
