library verilog;
use verilog.vl_types.all;
entity VGA_LED_Emulator is
    generic(
        HACTIVE         : vl_logic_vector(0 to 10) := (Hi1, Hi0, Hi1, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0);
        HFRONT_PORCH    : vl_logic_vector(0 to 10) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi1, Hi0, Hi0, Hi0, Hi0, Hi0);
        HSYNC           : vl_logic_vector(0 to 10) := (Hi0, Hi0, Hi0, Hi1, Hi1, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0);
        HBACK_PORCH     : vl_logic_vector(0 to 10) := (Hi0, Hi0, Hi0, Hi0, Hi1, Hi1, Hi0, Hi0, Hi0, Hi0, Hi0);
        HTOTAL          : vl_notype;
        VACTIVE         : vl_logic_vector(0 to 9) := (Hi0, Hi1, Hi1, Hi1, Hi1, Hi0, Hi0, Hi0, Hi0, Hi0);
        VFRONT_PORCH    : vl_logic_vector(0 to 9) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi1, Hi0, Hi1, Hi0);
        VSYNC           : vl_logic_vector(0 to 9) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi1, Hi0);
        VBACK_PORCH     : vl_logic_vector(0 to 9) := (Hi0, Hi0, Hi0, Hi0, Hi1, Hi0, Hi0, Hi0, Hi0, Hi1);
        VTOTAL          : vl_notype;
        R2              : integer := 1600
    );
    port(
        clk50           : in     vl_logic;
        reset           : in     vl_logic;
        cx              : in     vl_logic_vector(9 downto 0);
        cy              : in     vl_logic_vector(9 downto 0);
        VGA_R           : out    vl_logic_vector(7 downto 0);
        VGA_G           : out    vl_logic_vector(7 downto 0);
        VGA_B           : out    vl_logic_vector(7 downto 0);
        VGA_CLK         : out    vl_logic;
        VGA_HS          : out    vl_logic;
        VGA_VS          : out    vl_logic;
        VGA_BLANK_n     : out    vl_logic;
        VGA_SYNC_n      : out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of HACTIVE : constant is 1;
    attribute mti_svvh_generic_type of HFRONT_PORCH : constant is 1;
    attribute mti_svvh_generic_type of HSYNC : constant is 1;
    attribute mti_svvh_generic_type of HBACK_PORCH : constant is 1;
    attribute mti_svvh_generic_type of HTOTAL : constant is 3;
    attribute mti_svvh_generic_type of VACTIVE : constant is 1;
    attribute mti_svvh_generic_type of VFRONT_PORCH : constant is 1;
    attribute mti_svvh_generic_type of VSYNC : constant is 1;
    attribute mti_svvh_generic_type of VBACK_PORCH : constant is 1;
    attribute mti_svvh_generic_type of VTOTAL : constant is 3;
    attribute mti_svvh_generic_type of R2 : constant is 1;
end VGA_LED_Emulator;
