#ifndef _HELLO_H
#define _HELLO_H

#include <libusb-1.0/libusb.h>

#define SEGMENTS 44 //number of data to transmit

#define LEFT_MIN 0x7f
#define LEFT_MAX 0xef
#define RIGHT_MIN 0x10
#define RIGHT_MAX 0x80

#define BUTTON_UP 0x20
#define BUTTON_SHOOT 0x10
#define BUTTON_BOTH 0x30

#define ACC 0.0003  //accelerated v

struct item {
    uint16_t x;
    uint16_t y;
    uint16_t flag;
};

extern void init(struct item new_node) {
    new_node.x = 0;
    new_node.y = 0;
    new_node.flag = 0;
}

#endif
