	/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdlib.h>
#include <stdio.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include "usbkeyboard.h"
struct libusb_device_handle *keyboard;
uint8_t endpoint_address;
int vga_led_fd;

/* Read and print the segment values */
void print_segment_info() {
  vga_led_arg_t vla;
  int i;

  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    if (ioctl(vga_led_fd, VGA_LED_READ_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_READ_DIGIT) failed");
      return;
    }
    printf("%02x ", vla.segments);
  }
  printf("\n");
}

/* Write the contents of the array to the display */
void write_segments(const int segs[38])
{
  vga_led_arg_t vla;
  int i;
  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    vla.segments = segs[i];
    if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
      return;
    }
  }
}

int main()
{
    struct usb_keyboard_packet packet;
  	int transferred;
    char keystate[12];
    if ( (keyboard = openkeyboard(&endpoint_address)) == NULL )
    {
        fprintf(stderr, "Did not find a keyboard\n");
        exit(1);
  	}

    //int left,leftup,up,leftdown,down,rightdown,right,rightup;
  	//int clear_key = 1;



    vga_led_arg_t vla;
    //printf("01\n");
    static const char filename[] = "/dev/vga_led";// the driver.c
    //printf("02\n");
    //initial position of every enemy and its flag,
    static int xyf[38] = {
			300, 200, 1,	//chara x0-0 y0-1 f0-2 
			500,200,0,	//bullet1 x1-3 y1-4 f1-5
			500,300,0,		//bullet2 x2-6 y2-7 f2-8
			500,400,0,	//bullet3 x3-9 y3-10 f3-11
			700,100,0,1,	//enemy1 x4-12 y4-13 f4-14 id4-15
			700,200,0,2,	//enemy2 x5-16 y5-17 f5-18 id5-19
			700,300,0,2,	//enemy3 x6-20 y6-21 f6-22 id6-23
			0,		//floor	x7-24
			0,		//brick x8-25
			100,400,0,		//explosion1 x9-26 y9-27 f9-28
			300,400,0,		//explosion2 x10-29 y10-30 f10-31 
			500,400,0,		//exlposion3 x11-32 y11-33 f11-34
			300,100,0		//airflow x12-35 y12-36 f12-37
			};	
    printf("VGA axis Userspace program started\n");

    if ( (vga_led_fd = open(filename, O_RDWR)) == -1)
    {
        fprintf(stderr, "could not open %s\n", filename);
        return -1;
    }

    printf("initial state: ");
    print_segment_info();
    //write the initial value to the register
    write_segments(xyf);
    printf("fuck you \n");

    printf("current state: ");
    print_segment_info();
  
    int xmove, ymove;
    int t1=0;   //t used in calculate the y speed of chara
    int t2=0;
    //int v1=0;
    //int v2=0;
    //int v=0;
    int updown=0;
    int bulletx[3]={0,0,0};
    int bullety[3]={0,0,0};
    int enemyx[3]={700,700,700};
    int enemyy[3]={0,0,0};
    int explosionx[3]={0,0,0};
	int explosiony[3]={0,0,0};
    //int airx;
    //int airy;

    int collisioncount[3]={0,0,0};
    int bulletflag[3]={0,0,0};	//bulletflag[0]=0 1 2
    int enemyflag[3]={1,2,1};
	int explosionflag[3]={0,0,0};
    int airflag=0;
    int dead=0;
    int start=0;
    int numberofbullet=0;
	int j,i;
    int count=1;
    int justshoot=0;
    int enemynumber=0;
    int generate=0;
    int fellcount=1;
    int enemycount =0;
    int enemyId[3];
	int enemyID;
    int justleft=1;
    int justright=1;
    int juststraight=1;
	//int i;
    //int othercount=0;//count for cloud and tree
   

    //control the movement of every enemy
	while(1) 
	{
	for(i=0;i<3;i++)
		{
		enemyx[i]--;
		//enemyy++;
        	if (enemyflag[i]==1)
		   enemyflag[i]=2;
		else
		   enemyflag[i]=1;
		}
	xyf[14]=enemyflag[0];
	xyf[18]=enemyflag[1];
	xyf[22]=enemyflag[2];
	xyf[20] = enemyx[2];
	xyf[16] = enemyx[1];
	xyf[12] = enemyx[0];
	printf("enemy1 %d\n",xyf[14]);
	printf("enemy2 %d\n",xyf[18]);
	printf("enemy3 %d\n",xyf[22]);
	write_segments(xyf);
        usleep(1000000);/////////

}
  
  
  printf("VGA LED Userspace program terminating\n");
  return 0;

}

