/*
 * Seven-segment LED emulator
 *
 * Stephen A. Edwards, Columbia University
 *
 */

module VGA_LED_Emulator(
 input logic 	    clk50, reset,
 input logic[15:0]         //Character
									x0, y0, flag0,
									//3 bullets
	                       x1,y1,flag1,x2,y2,flag2,x3,y3,flag3,
								   //3 enemies
								  x4,y4,flag4,eid4,x5,y5,flag5,eid5,x6,y6,flag6,eid6,
								  //floor, brick
									x7,x8,
								  //3 explosions,
									x9,x10,x11,y9,y10,y11,flag9,flag10,flag11,
									//airflow
									x12,y12,flag12,
									//number
									flag13,flag14,flag15,
									//press
									flag16,
									//over
									flag17,
									//power
									x19,
									y19,
									flag19,
									//energy
									x20,
 output logic [7:0] VGA_R, VGA_G, VGA_B,
 output logic 	    VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n,VBLANK,
 output logic  inBullet1,inBullet2,inBullet3,inEnemy1,inEnemy2,inEnemy3,inExplosion1,inExplosion2,inExplosion3, inNumber1, inNumber2, inNumber3,
 //input RGB      //input RGB
 input logic[7:0] chara1R,chara1G,chara1B,
 input logic[7:0] chara2R,chara2G,chara2B,
 input logic[7:0] chara3R,chara3G,chara3B,
 input logic[7:0] shoot1R,shoot1G,shoot1B,
 input logic[7:0] shoot2R,shoot2G,shoot2B,
 input logic[7:0] falling1R,falling1G,falling1B,
 input logic[7:0] falling2R,falling2G,falling2B,
 input logic[7:0] fell1R,fell1G,fell1B,
 input logic[7:0] fell2R,fell2G,fell2B,
 input logic[7:0] fell3R,fell3G,fell3B,
 input logic[7:0] fell4R,fell4G,fell4B,
 
 input logic[7:0] left1R,left1G,left1B,
 input logic[7:0] left2R,left2G,left2B,
 input logic[7:0] right1R,right1G,right1B,
 input logic[7:0] right2R,right2G,right2B,
 input logic[7:0] straight1R,straight1G,straight1B,
 input logic[7:0] straight2R,straight2G,straight2B,
 
 input logic[7:0] enemyA1R,enemyA1G,enemyA1B,enemyA2R,enemyA2G,enemyA2B,enemyB1R,enemyB1G,enemyB1B,enemyB2R,enemyB2G,enemyB2B,
 input logic[7:0] bullet1R,bullet1G,bullet1B,
 input logic[7:0] bullet2R,bullet2G,bullet2B,
 input logic[7:0] floorR,floorG,floorB,
 input logic[7:0] brickR,brickG,brickB,
 input logic[7:0] explosionR,explosionG,explosionB,
 input logic[7:0] number1R,number1G,number1B,number2R,number2G,number2B,number3R,number3G,number3B,number4R,number4G,number4B,number5R,number5G,number5B,number6R,number6G,number6B,number7R,number7G,number7B,number8R,number8G,number8B,number9R,number9G,number9B,number10R,number10G,number10B,
 input logic[7:0] pressR,pressG,pressB,
 input logic[7:0] overR, overG, overB,
 
 input logic[7:0] powerR, powerG, powerB,
 input logic[7:0] energyR, energyG, energyB,
 
 //output hv
 output logic[9:0] hchara,vchara,henemy1,venemy1,henemy2,venemy2,henemy3,venemy3,hbullet1,vbullet1,hbullet2,vbullet2,hbullet3,vbullet3,hair,vair,
						hfloor,vfloor,hexplosion1,vexplosion1,hexplosion2,vexplosion2,hexplosion3,vexplosion3, hbrick, vbrick,hnumber1,vnumber1,hnumber2,vnumber2,hnumber3,vnumber3,
						hpress, vpress, hover, vover, hpower, vpower, henergy, venergy
 //output logic[1:0] enemyID,obID
 );
 
 

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 *HCOUNT 1599 0             1279       1599 0
 *            _______________              ________
 * __________|    Video      |__________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */

   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC + HBACK_PORCH; //1600

   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC + VBACK_PORCH; //525

   logic [10:0]			     hcount; // Horizontal counter
   logic 			     endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;

   // Vertical counter
   logic [9:0] 			     vcount;
   logic 			     endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x57F
   // 101 0010 0000 to 101 0111 1111
   assign VGA_HS = !( (hcount[10:7] == 4'b1010) & (hcount[6] | hcount[5]));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);
   assign VBLANK = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);
	
   assign VGA_SYNC_n = 1; // For adding sync to video signals; not used for VGA
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480	       
   // 110 0011 1111  1599	       10 0000 1100  524        
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );   

  
//////////////////////////////////////////////////////////////////////////////////////////////////
   assign VGA_CLK = hcount[0]; // 25 MHz clock: pixel latched on rising edge
  
  
  
  
///////////////////////////////////////////////h,v/////////////////////////////////////////////////////////  
 

 //logic [1:0] enemyID;
 //calculate the address of every object simultaneously
 //character
 assign hchara=hcount[10:1]-x0;
 assign vchara=vcount[9:0]-y0;
 //always begin
 //if in enemy1
 //if(flag3&&hcount[10:1]>x3-100&&hcount[10:1]<x3&&vcount[9:0]>y3&&vcount[9:0]<y3+100) 
 
 assign henemy1=hcount[10:1]-x4+100;//the objects' x which software pass to hardware is real coordinate-100
 assign venemy1=vcount[9:0]-y4;
 //enemyID=EID1;
 //enemy2
 
 //if(flag4&&hcount[10:1]>x4-100&&hcount[10:1]<x4&&vcount[9:0]>y4&&vcount[9:0]<y4+100) 
 assign henemy2=hcount[10:1]-x5+100;
 assign venemy2=vcount[9:0]-y5;
 //enemy3
 assign henemy3=hcount[10:1]-x6+100;
 assign venemy3=vcount[9:0]-y6;
 //bullet1
 assign hbullet1=hcount[10:1]-x1;
 assign vbullet1=vcount[9:0]-y1;
 //bullet2
 assign hbullet2=hcount[10:1]-x2;
 assign vbullet2=vcount[9:0]-y2;
 //bullet3
 assign hbullet3=hcount[10:1]-x3;
 assign vbullet3=vcount[9:0]-y3;
 //explosion1
 assign hexplosion1=hcount[10:1]-x9+100;
 assign vexplosion1=vcount[9:0]-y9;
 //explosion2
 assign hexplosion2=hcount[10:1]-x10+100;
 assign vexplosion2=vcount[9:0]-y10;
 //explosion3
 assign hexplosion3=hcount[10:1]-x11+100;
 assign vexplosion3=vcount[9:0]-y11;
 
 //airflow
 assign hair=hcount[10:1]-x12;
 assign vair=vcount[9:0]-y12;
 
 //background
 //assign hc=hcount[10:1]%40;
 assign vbrick=vcount[9:0]%40;
 //logic [3:0] count;

 always begin
 
		if(hcount[10:1]%40>=x8)
			hbrick=hcount[10:1]%40-x8;
		else
			hbrick=hcount[10:1]%40+40-x8;
	end
	
  //floor
 //assign hc=hcount[10:1]%40;
 assign vfloor=vcount[9:0]-420;
 //logic [3:0] count;

 always begin
 
		if(hcount[10:1]%60>=x7)
			hfloor=hcount[10:1]%60-x7;
		else
			hfloor=hcount[10:1]%60+60-x7;
	end	

	//number1
	assign hnumber1=hcount[10:1];
	assign vnumber1=vcount[9:0];
	//number2
	assign hnumber2=hcount[10:1]-42;
	assign vnumber2=vcount[9:0];
	//number3
	assign hnumber3=hcount[10:1]-84;
	assign vnumber3=vcount[9:0];
	//press
	assign hpress=hcount[10:1]-220;
	assign vpress=vcount[9:0]-200;
	//over
	assign hover=hcount[10:1]-220;
	assign vover=vcount[9:0]-150;

	//power
	assign hpower=hcount[10:1]-x19;
	assign vpower=vcount[9:0]-y19;
	//energy
	assign henergy=hcount[10:1]-340;
	assign venergy=vcount[9:0]-10;
////////////////////////////////////////inobject//////////////////////////////////////////////////////////////////////////
	
always begin
 //bullet1
  inBullet1=((flag1>0)&&hcount[10:1]>x1&&hcount[10:1]<x1+30&&vcount[9:0]>y1&&vcount[9:0]<y1+30?1:0);
 //bullet2
  inBullet2=((flag2>0)&&hcount[10:1]>x2&&hcount[10:1]<x2+30&&vcount[9:0]>y2&&vcount[9:0]<y2+30?1:0);
  //bullet3
  inBullet3=((flag3>0)&&hcount[10:1]>x3&&hcount[10:1]<x3+30&&vcount[9:0]>y3&&vcount[9:0]<y3+30?1:0);
  //enemy1 
 inEnemy1=((flag4>0)&&hcount[10:1]>x4-100&&hcount[10:1]<x4-40&&vcount[9:0]>y4&&vcount[9:0]<y4+60?1:0);
 //enemy2
 inEnemy2=((flag5>0)&&hcount[10:1]>x5-100&&hcount[10:1]<x5-40&&vcount[9:0]>y5&&vcount[9:0]<y5+60?1:0);
 //enemy3
 inEnemy3=((flag6>0)&&hcount[10:1]>x6-100&&hcount[10:1]<x6-40&&vcount[9:0]>y6&&vcount[9:0]<y6+60?1:0);
 //explosion1 
 inExplosion1=(flag9&&hcount[10:1]>x9-100&&hcount[10:1]<x9-40&&vcount[9:0]>y9&&vcount[9:0]<y9+60?1:0);
 //explosion2 
 inExplosion2=(flag10&&hcount[10:1]>x10-100&&hcount[10:1]<x10-40&&vcount[9:0]>y10&&vcount[9:0]<y10+60?1:0);
  //explosion3 
 inExplosion3=(flag11&&hcount[10:1]>x11-100&&hcount[10:1]<x11-40&&vcount[9:0]>y11&&vcount[9:0]<y11+60?1:0);
 //inNumber1
 inNumber1=(hcount[10:1]>0&&hcount[10:1]<40&&vcount[9:0]>0&&vcount[9:0]<40?1:0);
 //inNumber2
 inNumber2=(hcount[10:1]>42&&hcount[10:1]<82&&vcount[9:0]>0&&vcount[9:0]<40?1:0);
 //inNumber3
 inNumber3=(hcount[10:1]>84&&hcount[10:1]<124&&vcount[9:0]>0&&vcount[9:0]<40?1:0);
 end
	
	
	
	
	
///////////////////////////////////////white///////////////////////////////////////////////////////////////////////////	
 //calculate the white simultaneously
 logic white_0,white_1,white_2,white_3,white_4,white_5,white_6,white_7,white_8,white_9,white_10,white_11,white_12,white_13,white_14,white_15,white_16,white_17,white_19, white_20;
 //assign if white?
 
 //chara
 always begin
 case (flag0)
 0: white_0=0;
 1: white_0=(!(chara1R>240&&chara1G>240&&chara1B>240));
 2: white_0=(!(chara2R>240&&chara2G>240&&chara2B>240));
 3: white_0=(!(chara3R>240&&chara3G>240&&chara3B>240));
 4: white_0=(!(shoot1R>240&&shoot1G>240&&shoot1B>240));
 5: white_0=(!(shoot2R>240&&shoot2G>240&&shoot2B>240));
 6: white_0=(!(falling1R>240&&falling1G>240&&falling1B>240));
 7: white_0=(!(falling2R>240&&falling2G>240&&falling2B>240));
 8: white_0=(!(fell1R>240&&fell1G>240&&fell1B>240));
 9: white_0=(!(fell2R>240&&fell2G>240&&fell2B>240));
 10: white_0=(!(fell3R>240&&fell3G>240&&fell3B>240));
 11: white_0=(!(fell4R>240&&fell4G>240&&fell4B>240));
 endcase
 
 end
//Bullet1
  always begin
 case (flag1)
 0: white_1=0;
 1: white_1=(!(bullet1R>240&&bullet1G>240&&bullet1B>240));
 2: white_1=(!(bullet2R>240&&bullet2G>240&&bullet2B>240));
  endcase
 
 end
 
 //Bullet2
  always begin
 case (flag2)
 0: white_2=0;
 1: white_2=(!(bullet1R>240&&bullet1G>240&&bullet1B>240));
 2: white_2=(!(bullet2R>240&&bullet2G>240&&bullet2B>240));
   endcase
 
 end
 
  //Bullet3
  always begin
 case (flag3)
 0: white_3=0;
 1: white_3=(!(bullet1R>240&&bullet1G>240&&bullet1B>240));
 2: white_3=(!(bullet2R>240&&bullet2G>240&&bullet2B>240));
   endcase
 
 end
 
 //enemy1
 always begin
 if (eid4==1)
 begin
 case (flag4)
 1:  white_4=(!(enemyA1R>240&&enemyA1G>240&&enemyA1B>240));
 2:  white_4=(!(enemyA2R>240&&enemyA2G>240&&enemyA2B>240));
 0:  white_4=0;
 endcase
 end
 else if(eid4==2)
 begin
 case (flag4)
 1:  white_4=(!(enemyB1R>240&&enemyB1G>240&&enemyB1B>240));
 2:  white_4=(!(enemyB2R>240&&enemyB2G>240&&enemyB2B>240));
 0:  white_4=0;
 endcase
 end
 
 end
 
 //enemy2
 always begin
 
 if (eid5==1)
 begin
 case (flag5)
 1:  white_5=(!(enemyA1R>240&&enemyA1G>240&&enemyA1B>240));
 2:  white_5=(!(enemyA2R>240&&enemyA2G>240&&enemyA2B>240));
 0:  white_5=0;
 endcase
 end
 else if(eid5==2)
 begin
 case (flag5)
 1:  white_5=(!(enemyB1R>240&&enemyB1G>240&&enemyB1B>240));
 2:  white_5=(!(enemyB2R>240&&enemyB2G>240&&enemyB2B>240));
 0:  white_5=0;
 endcase
 end
 
 end
 
  //enemy3
 always begin
 
 if (eid6==1)
 begin
 case (flag6)
 1:  white_6=(!(enemyA1R>240&&enemyA1G>240&&enemyA1B>240));
 2:  white_6=(!(enemyA2R>240&&enemyA2G>240&&enemyA2B>240));
 0:  white_6=0;
 endcase
 end
 else if(eid6==2)
 begin
 case (flag6)
 1:  white_6=(!(enemyB1R>240&&enemyB1G>240&&enemyB1B>240));
 2:  white_6=(!(enemyB2R>240&&enemyB2G>240&&enemyB2B>240));
 0:  white_6=0;
 endcase
 end
 
 end
 

 //assign white_7=(!(floorR>240&&floorG>240&&floorB>240));
 //assign white_8=(!(brickR>240&&brickG>240&&brickB>240)); 
  
   //explosion1
 always begin
 case (flag9)
 1:   white_9=(!(explosionR>240&&explosionG>240&&explosionB>240));
 0:   white_9=0;
 endcase
 end
 
   //explosion2
 always begin
 case (flag10)
 1:   white_10=(!(explosionR>240&&explosionG>240&&explosionB>240));
 0:  white_10=0;
 endcase
 end
 
   //explosion3
 always begin
 case (flag11)
 1:   white_11=(!(explosionR>240&&explosionG>240&&explosionB>240));
 0:  white_11=0;
 endcase
 end
 

 //airflow
 always begin
 case (flag12)
 1: white_12=(!(left1R>240&&left1G>240&&left1B>240));
 2: white_12=(!(left2R>240&&left2G>240&&left2B>240));
 3: white_12=(!(right1R>240&&right1G>240&&right1B>240));
 4: white_12=(!(right2R>240&&right2G>240&&right2B>240));
 5: white_12=(!(straight1R>240&&straight1G>240&&straight1B>240));
 6: white_12=(!(straight2R>240&&straight2G>240&&straight2B>240));
 0: white_12=0;
 endcase
 end
 
 //number1
 always begin
 case(flag13)
 
 1: white_13=(!(number1R>240&&number1G>240&&number1B>240));
 2: white_13=(!(number2R>240&&number2G>240&&number2B>240));
 3: white_13=(!(number3R>240&&number3G>240&&number3B>240));
 4: white_13=(!(number4R>240&&number4G>240&&number4B>240));
 5: white_13=(!(number5R>240&&number5G>240&&number5B>240));
 6: white_13=(!(number6R>240&&number6G>240&&number6B>240));
 7: white_13=(!(number7R>240&&number7G>240&&number7B>240));
 8: white_13=(!(number8R>240&&number8G>240&&number8B>240));
 9: white_13=(!(number9R>240&&number9G>240&&number9B>240));
 0: white_13=(!(number10R>240&&number10G>240&&number10B>240));
 endcase
 end
 
  //number2
 always begin
 case(flag14)
 
 1: white_14=(!(number1R>240&&number1G>240&&number1B>240));
 2: white_14=(!(number2R>240&&number2G>240&&number2B>240));
 3: white_14=(!(number3R>240&&number3G>240&&number3B>240));
 4: white_14=(!(number4R>240&&number4G>240&&number4B>240));
 5: white_14=(!(number5R>240&&number5G>240&&number5B>240));
 6: white_14=(!(number6R>240&&number6G>240&&number6B>240));
 7: white_14=(!(number7R>240&&number7G>240&&number7B>240));
 8: white_14=(!(number8R>240&&number8G>240&&number8B>240));
 9: white_14=(!(number9R>240&&number9G>240&&number9B>240));
 0: white_14=(!(number10R>240&&number10G>240&&number10B>240));
 endcase
 end
 
  //number3
 always begin
 case(flag15)
 
 1: white_15=(!(number1R>240&&number1G>240&&number1B>240));
 2: white_15=(!(number2R>240&&number2G>240&&number2B>240));
 3: white_15=(!(number3R>240&&number3G>240&&number3B>240));
 4: white_15=(!(number4R>240&&number4G>240&&number4B>240));
 5: white_15=(!(number5R>240&&number5G>240&&number5B>240));
 6: white_15=(!(number6R>240&&number6G>240&&number6B>240));
 7: white_15=(!(number7R>240&&number7G>240&&number7B>240));
 8: white_15=(!(number8R>240&&number8G>240&&number8B>240));
 9: white_15=(!(number9R>240&&number9G>240&&number9B>240));
 0: white_15=(!(number10R>240&&number10G>240&&number10B>240));
 endcase
 end
 
 //press
 assign white_16=(!(pressR>240&&pressG>240&&pressB>240));
 
 //over
 assign white_17=(!(overR>240&&overG>240&&overB>240));
 //defien if the object is to 
 //in this pixel
 //power
 assign white_19=(!(powerR>240&&powerG>240&&powerB>240));
 //energy
 assign white_20=(!(energyR>240&&energyG>240&&energyB>240));
 
 
 //////////////////////////////////////show//////////////////////////////////////////////////////////////////
 
 
 logic show0,show1,show2,show3,show4,show5,show6,show9,show10,show11,show12,show13,show14,show15,show16,show17,show19,show20;
 //chara
assign show0 = (flag0&&hcount[10:1]>x0+1&&hcount[10:1]<x0+60&&vcount[9:0]>y0&&vcount[9:0]<y0+60&&white_0?1:0);
 
 //bullet1
assign  show1=((flag1>0)&&hcount[10:1]>x1+2&&hcount[10:1]<x1+30&&vcount[9:0]>y1&&vcount[9:0]<y1+30&&white_1?1:0);
 //bullet2
  assign show2=((flag2>0)&&hcount[10:1]>x2+2&&hcount[10:1]<x2+30&&vcount[9:0]>y2&&vcount[9:0]<y2+30&&white_2?1:0);
  //bullet3
  assign show3=((flag3>0)&&hcount[10:1]>x3+2&&hcount[10:1]<x3+30&&vcount[9:0]>y3&&vcount[9:0]<y3+30&&white_3?1:0);
  //enemy1 
 assign show4=((flag4>0)&&hcount[10:1]>x4-98&&hcount[10:1]<x4-40&&vcount[9:0]>y4&&vcount[9:0]<y4+60&&white_4?1:0);
 //enemy2
 assign show5=((flag5>0)&&hcount[10:1]>x5-98&&hcount[10:1]<x5-40&&vcount[9:0]>y5&&vcount[9:0]<y5+60&&white_5?1:0);
 //enemy3
assign show6=((flag6>0)&&hcount[10:1]>x6-98&&hcount[10:1]<x6-40&&vcount[9:0]>y6&&vcount[9:0]<y6+60&&white_6?1:0);
 //explosion1 
assign show9=(flag9&&hcount[10:1]>x9-99&&hcount[10:1]<x9-40&&vcount[9:0]>y9&&vcount[9:0]<y9+60&&white_9?1:0);
 //explosion2 
 assign show10=(flag10&&hcount[10:1]>x10-99&&hcount[10:1]<x10-40&&vcount[9:0]>y10&&vcount[9:0]<y10+60&&white_10?1:0);
  //explosion3 
 assign show11=(flag11&&hcount[10:1]>x11-99&&hcount[10:1]<x11-40&&vcount[9:0]>y11&&vcount[9:0]<y11+60&&white_11?1:0);
 //airflow
 assign show12=(flag12&&hcount[10:1]>x12+1&&hcount[10:1]<x12+40&&vcount[9:0]>y12&&vcount[9:0]<y12+40&&white_12?1:0);
 //number1
 assign show13=(hcount[10:1]>1&&hcount[10:1]<40&&vcount[9:0]>0&&vcount[9:0]<40&&white_13?1:0);
 //number2
 assign show14=(hcount[10:1]>43&&hcount[10:1]<82&&vcount[9:0]>0&&vcount[9:0]<40&&white_14?1:0);
 //number3
 assign show15=(hcount[10:1]>85&&hcount[10:1]<124&&vcount[9:0]>0&&vcount[9:0]<40&&white_15?1:0);
 //press
 assign show16=(flag16&&hcount[10:1]>220&&hcount[10:1]<420&&vcount[9:0]>200&&vcount[9:0]<230&&white_16?1:0);
 //over
 assign show17=(flag17&&hcount[10:1]>220&&hcount[10:1]<420&&vcount[9:0]>150&&vcount[9:0]<180&&white_17?1:0);
 //power
 assign show19=(flag19&&hcount[10:1]>x19&&hcount[10:1]<x19+20&&vcount[9:0]>y19&&vcount[9:0]<y19+20&&white_19?1:0);
 //energy
 assign show20=(hcount[10:1]>340&&hcount[10:1]<x20+340&&vcount[9:0]>10&&vcount[9:0]<20?1:0);
 
 
 //////////////////////////////////////////output////////////////////////////////////////////////////////////////
  always begin
  //{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0}; // Black
if(show13)//number1
	begin
	if (flag13==1)
	    {VGA_R, VGA_G, VGA_B} = {number1R, number1G, number1B};
     else if (flag13==2)
	    {VGA_R, VGA_G, VGA_B} = {number2R, number2G, number2B};
	  else if (flag13==3)
	    {VGA_R, VGA_G, VGA_B} = {number3R, number3G, number3B};
	  else if (flag13==4)
	    {VGA_R, VGA_G, VGA_B} = {number4R, number4G, number4B};
	  else if (flag13==5)
	    {VGA_R, VGA_G, VGA_B} = {number5R, number5G, number5B};
	  else if (flag13==6)
	    {VGA_R, VGA_G, VGA_B} = {number6R, number6G, number6B};
	  else if (flag13==7)
	    {VGA_R, VGA_G, VGA_B} = {number7R, number7G, number7B};
	  else if (flag13==8)
	    {VGA_R, VGA_G, VGA_B} = {number8R, number8G, number8B};
	  else if (flag13==9)
	    {VGA_R, VGA_G, VGA_B} = {number9R, number9G, number9B};
	  else if (flag13==0)
	    {VGA_R, VGA_G, VGA_B} = {number10R, number10G, number10B};
   end
	
else if(show14)//number2
	begin
	case(flag14)
	1: {VGA_R, VGA_G, VGA_B}={number1R,number1G,number1B};
	2: {VGA_R, VGA_G, VGA_B}={number2R,number2G,number2B};
	3: {VGA_R, VGA_G, VGA_B}={number3R,number3G,number3B};
	4: {VGA_R, VGA_G, VGA_B}={number4R,number4G,number4B};
	5: {VGA_R, VGA_G, VGA_B}={number5R,number5G,number5B};
	6: {VGA_R, VGA_G, VGA_B}={number6R,number6G,number6B};
	7: {VGA_R, VGA_G, VGA_B}={number7R,number7G,number7B};
	8: {VGA_R, VGA_G, VGA_B}={number8R,number8G,number8B};
	9: {VGA_R, VGA_G, VGA_B}={number9R,number9G,number9B};
	0:{VGA_R, VGA_G, VGA_B}={number10R,number10G,number10B};
	endcase
   end
	
else if(show15)//number3
	begin
	case(flag15)
	1: {VGA_R, VGA_G, VGA_B}={number1R,number1G,number1B};
	2: {VGA_R, VGA_G, VGA_B}={number2R,number2G,number2B};
	3: {VGA_R, VGA_G, VGA_B}={number3R,number3G,number3B};
	4: {VGA_R, VGA_G, VGA_B}={number4R,number4G,number4B};
	5: {VGA_R, VGA_G, VGA_B}={number5R,number5G,number5B};
	6: {VGA_R, VGA_G, VGA_B}={number6R,number6G,number6B};
	7: {VGA_R, VGA_G, VGA_B}={number7R,number7G,number7B};
	8: {VGA_R, VGA_G, VGA_B}={number8R,number8G,number8B};
	9: {VGA_R, VGA_G, VGA_B}={number9R,number9G,number9B};
	0:{VGA_R, VGA_G, VGA_B}={number10R,number10G,number10B};
	endcase
   end
//show energy bar
else if(show20)
  {VGA_R, VGA_G, VGA_B} = {energyR, energyG, energyB};
//if press
else if(show16)
	{VGA_R, VGA_G, VGA_B} = {pressR, pressG, pressB};
//if over
else if(show17)
	{VGA_R, VGA_G, VGA_B} = {overR, overG, overB};
	


else if(show9)//explosion1
	  {VGA_R, VGA_G, VGA_B} = {explosionR, explosionG, explosionB};
else if(show10)//explosion2
	  {VGA_R, VGA_G, VGA_B} = {explosionR, explosionG, explosionB};
else if(show11)//explosion3
	  {VGA_R, VGA_G, VGA_B} = {explosionR, explosionG, explosionB};
	  
else if(show1)//bullet1
	  begin
	  if(flag1==1)
	  {VGA_R, VGA_G, VGA_B} = {bullet1R, bullet1G, bullet1B};
	  else
	  {VGA_R, VGA_G, VGA_B} = {bullet2R, bullet2G, bullet2B};
	  end
else if(show2)//bullet2
	  begin 
	  if(flag2==1)
	  {VGA_R, VGA_G, VGA_B} = {bullet1R, bullet1G, bullet1B};
	  else
	  {VGA_R, VGA_G, VGA_B} = {bullet2R, bullet2G, bullet2B};
	  end
else if(show3)//bullet3
	  begin 
	  if(flag3==1)
	  {VGA_R, VGA_G, VGA_B} = {bullet1R, bullet1G, bullet1B};
	  else
	  {VGA_R, VGA_G, VGA_B} = {bullet2R, bullet2G, bullet2B};
	  end
else if(show0)  //characterter
		begin
	  if (flag0==1)
	    {VGA_R, VGA_G, VGA_B} = {chara1R, chara1G, chara1B};
     else if (flag0==2)
	    {VGA_R, VGA_G, VGA_B} = {chara2R, chara2G, chara2B};
	  else if (flag0==3)
	    {VGA_R, VGA_G, VGA_B} = {chara3R, chara3G, chara3B};
	  else if (flag0==4)
	    {VGA_R, VGA_G, VGA_B} = {shoot1R, shoot1G, shoot1B};
	  else if (flag0==5)
	    {VGA_R, VGA_G, VGA_B} = {shoot2R, shoot2G, shoot2B};
	  else if (flag0==6)
	    {VGA_R, VGA_G, VGA_B} = {falling1R, falling1G, falling1B};
	  else if (flag0==7)
	    {VGA_R, VGA_G, VGA_B} = {falling2R, falling2G, falling2B};
	  else if (flag0==8)
	    {VGA_R, VGA_G, VGA_B} = {fell1R, fell1G, fell1B};
	  else if (flag0==9)
	    {VGA_R, VGA_G, VGA_B} = {fell2R, fell2G, fell2B};
	  else if (flag0==10)
	    {VGA_R, VGA_G, VGA_B} = {fell3R, fell3G, fell3B};
	  else if (flag0==11)
	    {VGA_R, VGA_G, VGA_B} = {fell4R, fell4G, fell4B};
    end 
else  if(show12)//airflow
    begin
	  if (flag12==1)
	    {VGA_R, VGA_G, VGA_B} = {left1R, left1G, left1B};
     else if (flag12==2)
	    {VGA_R, VGA_G, VGA_B} = {left2R, left2G, left2B};
	  else if (flag12==3)
	    {VGA_R, VGA_G, VGA_B} = {right1R, right1G, right1B};
	  else if (flag12==4)
	    {VGA_R, VGA_G, VGA_B} = {right2R, right2G, right2B};
		 else if (flag12==5)
	    {VGA_R, VGA_G, VGA_B} = {straight1R, straight1G, straight1B};
		 else if (flag12==6)
	    {VGA_R, VGA_G, VGA_B} = {straight2R, straight2G, straight2B};
		 
    end
  
  //power
  else if(show19)
     {VGA_R, VGA_G, VGA_B} = {powerR, powerG, powerB};

  
  else if(show4)//enemy1
	    begin
		 if(eid4==1)
		 begin
		  if (flag4==1)
		   {VGA_R, VGA_G, VGA_B} = {enemyA1R,enemyA1G,enemyA1B};
		 else if (flag4==2)
		   {VGA_R, VGA_G, VGA_B} = {enemyA2R,enemyA2G,enemyA2B};
		 end
		 else if(eid4==2)
		 begin
		   if (flag4==1)
		   {VGA_R, VGA_G, VGA_B} = {enemyB1R,enemyB1G,enemyB1B};
		else  if (flag4==2)
		   {VGA_R, VGA_G, VGA_B} = {enemyB2R,enemyB2G,enemyB2B};
		 end
		  end
 
 else if(show5)//enemy2
	    begin
		 if(eid5==1)
		 begin
		  if (flag5==1)
		   {VGA_R, VGA_G, VGA_B} = {enemyA1R,enemyA1G,enemyA1B};
		 else if (flag5==2)
		   {VGA_R, VGA_G, VGA_B} = {enemyA2R,enemyA2G,enemyA2B};
		 end
		 else if(eid5==2)
		 begin
		   if (flag5==1)
		   {VGA_R, VGA_G, VGA_B} = {enemyB1R,enemyB1G,enemyB1B};
		   else if (flag5==2)
		   {VGA_R, VGA_G, VGA_B} = {enemyB2R,enemyB2G,enemyB2B};
		 end
		  end
		  
		  
 else if(show6)//enemy3
	   begin
		 if(eid6==1)
		 begin
		  if (flag6==1)
		   {VGA_R, VGA_G, VGA_B} = {enemyA1R,enemyA1G,enemyA1B};
		  else if (flag6==2)
		   {VGA_R, VGA_G, VGA_B} = {enemyA2R,enemyA2G,enemyA2B};
		 end
		 else //if(eid6==2)
		 begin
		   if (flag6==1)
		   {VGA_R, VGA_G, VGA_B} = {enemyB1R,enemyB1G,enemyB1B};
		  else if (flag6==2)
		   {VGA_R, VGA_G, VGA_B} = {enemyB2R,enemyB2G,enemyB2B};
		 end
		  end
 
else if(vcount<420)
     {VGA_R, VGA_G, VGA_B} = {brickR,brickG,brickB};
else 
	  {VGA_R, VGA_G, VGA_B} = {floorR,floorG,floorB};
  end
 //  always_comb begin
 //     {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0}; // Black
   //   if (inChar)
//	if ( flag ) // In any active segment?
//	  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00}; // Red
//	else if ( |segment )        // In any (inactive) segment?
//	  {VGA_R, VGA_G, VGA_B} = {8'h20, 8'h20, 8'h20}; // Dark Gray
//   end  

endmodule // VGA_LED_Emulator
