/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [15:0]  writedata,//bandwidth
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [5:0]  address,//register address
         // output logic [15:0]  readdata,
			// input logic read,
	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n,
			 output logic  shootflag, airflag, fellflag, explosflag1, explosflag2, explosflag3);
			 
			 
			  logic [15:0]  writedata0;
			  logic write0;
			  logic chipselect0;
			  logic [5:0]  address0;
			  logic reset0;
			  logic clk0;
			  logic VBLANK;
			  
			  assign write0=write;
	        assign writedata0=writedata;	
	        assign chipselect0=chipselect;
	        assign address0=address;
	        assign reset0=reset;
	        assign clk0=clk;
	//chara
	logic[23:0] charap1,charap2,charap3,shoot1p,shoot2p,falling1p,falling2p,fell1p,fell2p,fell3p,fell4p;
	logic[9:0] hchara,vchara;
	logic[7:0] chara1R,chara1G,chara1B,chara2R,chara2G,chara2B,chara3R,chara3G,chara3B,shoot1R,shoot1G,shoot1B,shoot2R,shoot2G,shoot2B,falling1R,falling1G,falling1B,falling2R,falling2G,falling2B,fell1R,fell1G,fell1B,fell2R,fell2G,fell2B,fell3R,fell3G,fell3B,fell4R,fell4G,fell4B;
	logic[13:0] chara1add, chara2add,chara3add,shoot1add,shoot2add,falling1add,falling2add,fell1add,fell2add,fell3add,fell4add;
   
	//enemy
	logic[23:0] enemyA1p,enemyA2p,enemyB1p,enemyB2p;
	logic[9:0] henemy1,henemy2,henemy3;
   logic[9:0] venemy1,venemy2,venemy3;
	logic[7:0] enemyA1R,enemyA1G,enemyA1B,enemyA2R,enemyA2G,enemyA2B,enemyB1R,enemyB1G,enemyB1B,enemyB2R,enemyB2G,enemyB2B;
	logic[13:0] enemyA1add,enemyA2add,enemyB1add,enemyB2add;
	
	//bullet
	logic[23:0] bulletp1,bulletp2;
	logic[9:0] hbullet1,vbullet1,hbullet2,vbullet2,hbullet3,vbullet3;
	logic[7:0] bullet1R,bullet1G,bullet1B,bullet2R,bullet2G,bullet2B;
	logic[9:0] bullet1add, bullet2add;
	
	
	//airflow
	logic[23:0] left1p,left2p,right1p,right2p,straight1p,straight2p;
	logic[9:0] hair;
   logic[9:0] vair;
	logic[7:0] left1R,left1G,left1B,left2R,left2G,left2B,right1R,right1G,right1B,right2R,right2G,right2B,straight1R,straight1G,straight1B,straight2R,straight2G,straight2B;
	logic[13:0] left1add,left2add,right1add,right2add,straight1add,straight2add;
	
	//floor
	logic[23:0] floorp;
	logic[9:0] hfloor;
   logic[9:0] vfloor;
	logic[7:0] floorR,floorG,floorB;
	logic[11:0] flooradd;
	
	//explosion////////////////////////////////////////////////////////////////
	logic[23:0] explosionp;
	logic[9:0] hexplosion1,hexplosion2,hexplosion3;
   logic[9:0] vexplosion1,vexplosion2,vexplosion3;
	logic[7:0] explosionR,explosionG,explosionB;
	logic[11:0] explosionadd;
	
	//brick
	logic[23:0] brickp;
	logic[9:0] hbrick;
   logic[9:0] vbrick;
	logic[7:0] brickR,brickG,brickB;
	logic[10:0] brickadd;
	
	//number
	logic[23:0] number1p, number2p, number3p, number4p, number5p, number6p, number7p, number8p, number9p, number10p;
	logic[9:0] hnumber1,vnumber1,hnumber2,vnumber2,hnumber3,vnumber3;
	logic[7:0] number1R,number1G,number1B,number2R,number2G,number2B,number3R,number3G,number3B,number4R,number4G,number4B,number5R,number5G,number5B,number6R,number6G,number6B,number7R,number7G,number7B,number8R,number8G,number8B,number9R,number9G,number9B,number10R,number10G,number10B;
	logic[10:0] number1add, number2add, number3add, number4add, number5add, number6add, number7add, number8add, number9add, number10add;
	
	//press
	logic[23:0] pressp;
	logic[9:0] hpress, vpress;
   logic[7:0] pressR, pressG, pressB;
	logic[12:0] pressadd;
	
	//gameover
	logic[23:0] overp;
	logic[9:0] hover,vover;
	logic[7:0] overR, overG, overB;
	logic[12:0] overadd;
	
	//power
	logic[23:0] powerp;
	logic[9:0] hpower,vpower;
	logic[7:0] powerR, powerG, powerB;
	logic[12:0] poweradd;	
	
	//energy
	logic[23:0] energyp;
	logic[9:0] henergy,venergy;
	logic[7:0] energyR, energyG, energyB;
	logic[12:0] energyadd;
	
	logic inBullet1,inBullet2,inBullet3,inEnemy1,inEnemy2,inEnemy3,inExplosion1,inExplosion2,inExplosion3,inNumber1,inNumber2,inNumber3;
	ROMdecoder controller(.clk(clk),
	                       //chara
								 .hchara(hchara), .vchara(vchara), 
	                      .charap1(charap1), .charap2(charap2),  .charap3(charap3), .shoot1p(shoot1p), .shoot2p(shoot2p), .falling1p(falling1p), .falling2p(falling2p), .fell1p(fell1p), .fell2p(fell2p), .fell3p(fell3p), .fell4p(fell4p),
								 .chara1add(chara1add), .chara2add(chara2add), .chara3add(chara3add), .shoot1add(shoot1add), .shoot2add(shoot2add), .falling1add(falling1add), .falling2add(falling2add), .fell1add(fell1add), .fell2add(fell2add), .fell3add(fell3add), .fell4add(fell4add),
								 .chara1R(chara1R), .chara1G(chara1G), .chara1B(chara1B), 
								 .chara2R(chara2R), .chara2G(chara2G), .chara2B(chara2B),
								 .chara3R(chara3R), .chara3G(chara3G), .chara3B(chara3B),
								 .shoot1R(shoot1R), .shoot1G(shoot1G), .shoot1B(shoot1B),
								 .shoot2R(shoot2R), .shoot2G(shoot2G), .shoot2B(shoot2B),
								 .falling1R(falling1R), .falling1G(falling1G), .falling1B(falling1B),
								 .falling2R(falling2R), .falling2G(falling2G), .falling2B(falling2B),
								 .fell1R(fell1R), .fell1G(fell1G), .fell1B(fell1B),
								 .fell2R(fell2R), .fell2G(fell2G), .fell2B(fell2B),
								 .fell3R(fell3R), .fell3G(fell3G), .fell3B(fell3B),
								 .fell4R(fell4R), .fell4G(fell4G), .fell4B(fell4B),
								 //enemy
								 .enemyA1p(enemyA1p),.enemyA2p(enemyA2p),.enemyB1p(enemyB1p),.enemyB2p(enemyB2p),
								 .henemy1(henemy1), .henemy2(henemy2), .henemy3(henemy3), .venemy1(venemy1), .venemy2(venemy2),.venemy3(venemy3), 
								 .enemyA1R(enemyA1R), .enemyA1G(enemyA1G), .enemyA1B(enemyA1B),.enemyA2R(enemyA2R),.enemyA2G(enemyA2G),.enemyA2B(enemyA2B),
								 .enemyB1R(enemyB1R),.enemyB1G(enemyB1G),.enemyB1B(enemyB1B),.enemyB2R(enemyB2R),.enemyB2G(enemyB2G),.enemyB2B(enemyB2B),
								 .enemyA1add(enemyA1add), .enemyA2add(enemyA2add), .enemyB1add(enemyB1add), .enemyB2add(enemyB2add),
								 //bullet
								 
								 .bulletp1(bulletp1), .bulletp2(bulletp2), 
								 .hbullet1(hbullet1), .vbullet1(vbullet1),.hbullet2(hbullet2), .vbullet2(vbullet2),.hbullet3(hbullet3), .vbullet3(vbullet3),
								 .bullet1R(bullet1R), .bullet1G(bullet1G), .bullet1B(bullet1B), .bullet2R(bullet2R), .bullet2G(bullet2G), .bullet2B(bullet2B),
								 .bullet1add(bullet1add), .bullet2add(bullet2add),
								 //obstruction
								 
								 
								 
								 //airflow
								 .left1p(left1p),.left2p(left2p),.right1p(right1p),.right2p(right2p), .straight1p(straight1p),.straight2p(straight2p),
								 .hair(hair), .vair(vair),
								 .left1add(left1add), .left2add(left2add), .right1add(right1add), .right2add(right2add), .straight1add(straight1add), .straight2add(straight2add),
								 .left1R(left1R), .left1G(left1G),.left1B(left1B),
								 .left2R(left2R),.left2G(left2G),.left2B(left2B),
								 .right1R(right1R),.right1G(right1G),.right1B(right1B),
								 .right2R(right2R),.right2G(right2G),.right2B(right2B),
								 .straight1R(straight1R),.straight1G(straight1G),.straight1B(straight1B),
								 .straight2R(straight2R) , .straight2G(straight2G),.straight2B(straight2B),
								 //floor
								 .floorp(floorp),
								 .hfloor(hfloor), .vfloor(vfloor),
								 .floorR(floorR),.floorG(floorG),.floorB(floorB),
								 .flooradd(flooradd),
								 //brick
								 .brickp(brickp),
								 .hbrick(hbrick), .vbrick(vbrick),
								 .brickR(brickR),.brickG(brickG),.brickB(brickB),
								 .brickadd(brickadd),
								 
								 //explosion
								 .explosionp(explosionp),
								 .hexplosion1(hexplosion1), .vexplosion1(vexplosion1),.hexplosion2(hexplosion2), .vexplosion2(vexplosion2),.hexplosion3(hexplosion3), .vexplosion3(vexplosion3),
								 .explosionR(explosionR),.explosionG(explosionG),.explosionB(explosionB),
								 .explosionadd(explosionadd),
								 .inBullet1(inBullet1), .inBullet2(inBullet2), .inBullet3(inBullet3), .inEnemy1(inEnemy1), .inEnemy2(inEnemy2), .inEnemy3(inEnemy3), .inExplosion1(inExplosion1), .inExplosion2(inExplosion2), .inExplosion3(inExplosion3),
								 .inNumber1(inNumber1), .inNumber2(inNumber2), .inNumber3(inNumber3),
								 //number
								 .hnumber1(hnumber1), .vnumber1(vnumber1), .hnumber2(hnumber2), .vnumber2(vnumber2), .hnumber3(hnumber3), .vnumber3(vnumber3),
								 //number1
								 .number1p(number1p),
								 .number1R(number1R), .number1G(number1G), .number1B(number1B),
								 .number1add(number1add),
								 
								 //number2
								 .number2p(number2p),
								 .number2R(number2R), .number2G(number2G), .number2B(number2B),
								 .number2add(number2add),
								 
								 //number3
								 .number3p(number3p),
								 .number3R(number3R), .number3G(number3G), .number3B(number3B),
								 .number3add(number3add),
								 
								 //number4
								 .number4p(number4p),
								 .number4R(number4R), .number4G(number4G), .number4B(number4B),
								 .number4add(number4add),
								 
								 //number5
								 .number5p(number5p),
								 .number5R(number5R), .number5G(number5G), .number5B(number5B),
								 .number5add(number5add),
								 
								 //number6
								 .number6p(number6p),
								 .number6R(number6R), .number6G(number6G), .number6B(number6B),
								 .number6add(number6add),
								 
								 //number7
								 .number7p(number7p),
								 .number7R(number7R), .number7G(number7G), .number7B(number7B),
								 .number7add(number7add),
								 
								 //number8
								 .number8p(number8p),
								 .number8R(number8R), .number8G(number8G), .number8B(number8B),
								 .number8add(number8add),
								 
								 //number9
								 .number9p(number9p),
								 .number9R(number9R), .number9G(number9G), .number9B(number9B),
								 .number9add(number9add),
								 
								 //number10
								 .number10p(number10p),
								 .number10R(number10R), .number10G(number10G), .number10B(number10B),
								 .number10add(number10add),
								 
								 //press
								 .pressp(pressp),
								 .hpress(hpress), .vpress(vpress),
								 .pressR(pressR), .pressG(pressG), .pressB(pressB),
								 .pressadd(pressadd),
								 
								 //over
								 .overp(overp),
								 .hover(hover),.vover(vover),
								 .overR(overR), .overG(overG), .overB(overB),
								 .overadd(overadd),
								 
								 //power
								 .powerp(powerp),
								 .hpower(hpower),.vpower(vpower),
								 .powerR(powerR), .powerG(powerG), .powerB(powerB),
								 .poweradd(poweradd),
								 
								 //energy
								 .energyp(energyp),
								 .henergy(henergy),.venergy(venergy),
								 .energyR(energyR), .energyG(energyG), .energyB(energyB),
								 .energyadd(energyadd)
								 );
	//chara rom
	chara1 rom1(.address(chara1add), .clock(clk), .q(charap1));
	chara2 rom2(.address(chara2add), .clock(clk), .q(charap2));
	chara3 rom3(.address(chara3add), .clock(clk), .q(charap3));
	shoot1 rom8(.address(shoot1add), .clock(clk), .q(shoot1p));
	shoot2 rom9(.address(shoot2add), .clock(clk), .q(shoot2p));
	falling1 rom10(.address(falling1add), .clock(clk), .q(falling1p));
	falling2 rom11(.address(falling2add), .clock(clk), .q(falling2p));
   fell1 rom12	(.address(fell1add), .clock(clk), .q(fell1p));
	fell2 rom13	(.address(fell2add), .clock(clk), .q(fell2p));
	fell3 rom14	(.address(fell3add), .clock(clk), .q(fell3p));
	fell4 rom15	(.address(fell4add), .clock(clk), .q(fell4p));
	
	//bullet rom
	bullet1 rom5(.address(bullet1add), .clock(clk), .q(bulletp1));
	bullet2 rom6(.address(bullet2add), .clock(clk), .q(bulletp2));
	
	//brick rom
	brick   rom7(.address(brickadd),  .clock(clk), .q(brickp));
	
	//floor
	floor rom22(.address(flooradd),  .clock(clk), .q(floorp));
	
	//enemy rom
	enemyA1  rom4(.address(enemyA1add),  .clock(clk), .q(enemyA1p));
	enemyA2  rom23(.address(enemyA2add),  .clock(clk), .q(enemyA2p));
	enemyB1  rom24(.address(enemyB1add),  .clock(clk), .q(enemyB1p));
	enemyB2  rom25(.address(enemyB2add),  .clock(clk), .q(enemyB2p));
	
	
	//airflow rom
	left1  rom16(.address(left1add),  .clock(clk), .q(left1p));
	left2  rom17(.address(left2add),  .clock(clk), .q(left2p));
	right1  rom18(.address(right1add),  .clock(clk), .q(right1p));
	right2  rom19(.address(right2add),  .clock(clk), .q(right2p));
	straight1  rom20(.address(straight1add),  .clock(clk), .q(straight1p));
	straight2  rom21(.address(straight2add),  .clock(clk), .q(straight2p));
	
	//explosion
	explosion rom26(.address(explosionadd),  .clock(clk), .q(explosionp));
	
	//number
	number1 rom27(.address(number1add), .clock(clk), .q(number1p));
	number2 rom28(.address(number2add), .clock(clk), .q(number2p));
	number3 rom29(.address(number3add), .clock(clk), .q(number3p));
	number4 rom30(.address(number4add), .clock(clk), .q(number4p));
	number5 rom31(.address(number5add), .clock(clk), .q(number5p));
	number6 rom32(.address(number6add), .clock(clk), .q(number6p));
	number7 rom33(.address(number7add), .clock(clk), .q(number7p));
	number8 rom34(.address(number8add), .clock(clk), .q(number8p));
	number9 rom35(.address(number9add), .clock(clk), .q(number9p));
	number0 rom36(.address(number10add), .clock(clk), .q(number10p));
	
	//press
	
	press rom37(.address(pressadd),  .clock(clk), .q(pressp));
	//over
	gameover rom38(.address(overadd),  .clock(clk), .q(overp));
	//power
	power rom39(.address(poweradd), .clock(clk), .q(powerp));
	//energy
	energy rom40(.address(energyadd), .clock(clk), .q(energyp));
	 
   logic [15:0] 			  x0, y0, flag0,
									//3 bullets
	                       x1,y1,flag1,x2,y2,flag2,x3,y3,flag3,
								   //3 enemies
								  x4,y4,flag4,eid4,x5,y5,flag5,eid5,x6,y6,flag6,eid6,
								  //floor, brick
									x7,x8,
								  //3 explosions,
									x9,x10,x11,y9,y10,y11,flag9,flag10,flag11,
									//airflow
									x12,y12,flag12,
									//number
									flag13,flag14,flag15,
									//press
									flag16,
									//over
									flag17,
									//shooflag
									flag18,
									//power
									x19,
									y19,
									flag19,
									//energy
									x20;
 //  logic [1:0]  enemyID, obID;
//	logic bulletID;
   VGA_LED_Emulator led_emulator(.clk50(clk),.*);
   
assign shootflag=(flag18>0);
assign airflag=(flag12>0);
assign explosflag1=(flag9>0);
assign explosflag2=(flag10>0);
assign explosflag3=(flag11>0);
assign fellflag=(flag0>5);

Buffer fifo(.clk0(clk0), .write0(write0), .writedata0(writedata0), .address0(address0),
					.chipselect0(chipselect0), .reset0(reset0), .VBLANK(VBLANK), 
					.x0(x0), .y0(y0), .flag0(flag0),
									//3 bullets
						.x1(x1), .y1(y1), .flag1(flag1), .x2(x2), .y2(y2), .flag2(flag2), .x3(x3), .y3(y3), .flag3(flag3),
								   //3 enemies
						.x4(x4), .y4(y4), .flag4(flag4), .eid4(eid4), .x5(x5), .y5(y5), .flag5(flag5), .eid5(eid5), .x6(x6), .y6(y6), .flag6(flag6), .eid6(eid6),
								  //floor, brick
						.x7(x7), .x8(x8),
								  //3 explosions,
						.x9(x9), .x10(x10), .x11(x11), .y9(y9), .y10(y10), .y11(y11), .flag9(flag9), .flag10(flag10), .flag11(flag11),
									//airflow
						.x12(x12), .y12(y12), .flag12(flag12),
									//number
						.flag13(flag13), .flag14(flag14), .flag15(flag15),
									//press
						.flag16(flag16),
									//over
						.flag17(flag17),
									//shootflag
					   .flag18(flag18),
							     //power
						.x19(x19),
						.y19(y19),
						.flag19(flag19),
									//energy
						.x20(x20));
endmodule
