module audio_effects (
    input  clk,//master clock 11.2MHZ
    input  sample_end,
    input  sample_req,
	 //output audio data
    output [15:0] audio_output,
    input  [15:0] audio_input,
	 //input to control which rom to display
    input    contrair,
	 input    contrshoot,
	 input    contrexplos1,
	 input    contrexplos2,
	 input    contrexplos3,
	 input	contrfell
);
//rom data 
reg [15:0] airrom,shootrom, explosrom1, explosrom2, explosrom3,fellrom;

//inner data
reg [15:0]  airdata,shootdata, explosdata1, explosdata2, explosdata3,felldata;

//index as address for every rom
reg [14:0]  airindex = 0;
reg [13:0]	shootindex = 0;
reg [14:0]  explosindex1=0;
reg [14:0]  explosindex2=0;
reg [14:0]  explosindex3=0;
reg [14:0]	fellindex = 0;
//reg [15:0] last_sample;
//total audio
//reg [15:0] dat=0;
//total effect audio number
reg [2:0] num=0;
//final output data
assign audio_output = (airdata+shootdata+explosdata1+explosdata2+explosdata3+felldata)/num;

airaudio air(.address(airindex), .q(airrom), .clock(clk));
shootaudio shoot(.address(shootindex), .q(shootrom), .clock(clk));
explosaudio1 ex1(.address(explosindex1), .q(explosrom1), .clock(clk));
explosaudio2 ex2(.address(explosindex2), .q(explosrom2), .clock(clk));
explosaudio3 ex3(.address(explosindex3), .q(explosrom3), .clock(clk));
fellaudio fell(.address(fellindex), .q(fellrom), .clock(clk));
always @(posedge clk) begin
    //req for left channel
    if (sample_req) begin
	   num<=contrair+contrshoot+contrexplos1+contrexplos2+contrexplos3+contrfell;
			//air audio
			//flag==1
        if (contrair) begin
            airdata <= airrom;
            if (airindex == 16000)
                airindex <= 0;
            else
                airindex <= airindex + 1'b1;
             end 
		  //flag==0
		  else begin
            airindex<=0;
				airdata<=0;
				end
				
			//shoot audio
			if(contrshoot) begin
			    shootdata<=shootrom;
				 if(shootindex==16000)
				    shootindex<=0;
				 else
				    shootindex<=shootindex+1;
				 end
			 else begin
			    shootindex<=0;
				 shootdata<=0;
				 end
				 
				 
				 
			 //explosaudio1
			 if(contrexplos1) begin
			    explosdata1<=explosrom1;
				 if(explosindex1==15000)
				    explosindex1<=0;
				 else
				    explosindex1<=explosindex1+1;
				 end
			 else begin
			    explosindex1<=0;
				 explosdata1<=0;
				 end
				 
				 
			  //explosaudio2
			 if(contrexplos2) begin
			    explosdata2<=explosrom2;
				 if(explosindex2==15000)
				    explosindex2<=0;
				 else
				    explosindex2<=explosindex2+1;
				 end
			 else begin
			    explosindex2<=0;
				 explosdata2<=0;
				 end
				 
				//explosaudio3
			 if(contrexplos3) begin
			    explosdata3<=explosrom3;
				 if(explosindex3==15000)
				    explosindex3<=0;
				 else
				    explosindex3<=explosindex3+1;
				 end
			 else begin
			    explosindex3<=0;
				 explosdata3<=0;
				 end
				 
				 //fell
			 if(contrfell) begin
			   felldata<=fellrom;
				 if(fellindex==16000)
				    fellindex<=0;
				 else
				    fellindex<=fellindex+1;
				 end
			 else begin
			    fellindex<=0;
				 felldata<=0;
				 end
		 
    end

end
endmodule
