module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [15:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
               input logic[3:0]   SW,
               input logic [7:0]   pixel [0:1057],
	       input logic [1:0]   pixel_RGB [0:351],
	       input logic [1:0]   fix_pixel_RGB [0:351],
		input logic [1:0]   fix_pixel_RGB_denise [0:351],
		input logic [4:0]   fix_keys_position [0:351],
		input logic [8:0]   row_num,
                input logic [3:0]   KEY,
                input logic [4:0]   key_num,
                input logic [8:0]   ii,
		input logic [16:0]  press,
	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n);

               logic [7:0] R1,G1, B1;
               logic [15:0]  addr1;
               logic [23:0] pixel1;
               logic [9:0] hcount, vcount;
               
   rom newrom1(.clock(clk), .address(addr1), .q(pixel1));


   rgb_controller controller_1 (.clk(clk), .h(hcount), .c(vcount), .R1(R1), .G1(G1), .B1(B1),.addr_bg1(addr1), .M_bg1(pixel1));

   PIANO_DISPLAY led_emulator (.clk50(clk), .in_R1(R1), .in_G1(G1), .in_B1(B1), .h(hcount), .v(vcount), .*);
   

endmodule

