module rgb_controller(
input logic clk,
input logic  [9:0]      h,
input logic  [9:0]      c,
input logic  [23:0]     M_bg1,
input logic  [23:0]     M_bg2,
input logic  [23:0]     M_bg3,
input logic  [23:0]     M_bg4,
input logic  [23:0]     M_bg5,
output logic [7:0]           R1,
output logic [7:0]           G1,
output logic [7:0]           B1, 
output logic [7:0]           R2,
output logic [7:0]           G2,
output logic [7:0]           B2, 
output logic [7:0]           R3,
output logic [7:0]           G3,
output logic [7:0]           B3, 
output logic [7:0]           R4,
output logic [7:0]           G4,
output logic [7:0]           B4,
output logic [7:0]           R5,
output logic [7:0]           G5,
output logic [7:0]           B5,
output logic  [15:0]         addr_bg1,
output logic  [15:0]         addr_bg2,
output logic  [15:0]         addr_bg3,
output logic  [15:0]         addr_bg4,
output logic  [15:0]         addr_bg5
);
assign addr_bg1 = c * 128 + h % 128;
assign addr_bg2 = (c - 100) * 600 + h - 20;
assign addr_bg3 = (c - 240) * 128 + h % 128;
assign addr_bg4 = (c - 240) * 90 + h - 275;
assign addr_bg5 = (c - 240) * 90 + h - 275;

assign R1 = M_bg1[23:16];
assign R2 = M_bg2[23:16];
assign R3 = M_bg3[23:16];
assign R4 = M_bg4[23:16];
assign R5 = M_bg5[23:16];

assign G1 = M_bg1[15:8];
assign G2 = M_bg2[15:8];
assign G3 = M_bg3[15:8];
assign G4 = M_bg4[15:8];
assign G5 = M_bg5[15:8];

assign B1 = M_bg1[7:0];
assign B2 = M_bg2[7:0];
assign B3 = M_bg3[7:0];
assign B4 = M_bg4[7:0];
assign B5 = M_bg5[7:0];

endmodule
