module KEYCHAR_DISP(input logic [2:0]  offset,
						  input logic [2:0]  digit,
                    input logic [9:0]  vcount,
						  input logic [10:0] hcount,
						  
                    output logic [7:0] keycurSegs, keysegment);

	logic [2:0] 			     charx; // Coordinate within the 8x16 char
   logic [3:0] 			     chary;

   assign charx = hcount[3:1] - offset;
   assign chary = vcount[3:0];

   logic horizBar, leftCol, rightCol, topCol, botCol; // Parts of the disp.

   assign horizBar = !(charx[2:1] == 2'b11);  // When in any horizontal bar
   assign leftCol  = (charx == 3'd0);         // When in left column
   assign rightCol = (charx == 3'd5);         // When in right column
   assign topCol   = !chary[3] & !(chary[2:0] == 3'd7); // Top columns
   assign botCol   = (chary >= 4'd6) & (chary <= 4'd12); // Bottom columns

   assign keysegment[0] = horizBar & (chary == 4'd 0);
   assign keysegment[1] = rightCol & topCol;
   assign keysegment[2] = rightCol & botCol;
   assign keysegment[3] = horizBar & (chary == 4'd 12);
   assign keysegment[4] = leftCol & botCol;
   assign keysegment[5] = leftCol & topCol;
   assign keysegment[6] = horizBar & (chary == 4'd 6);
   assign keysegment[7] = (charx == 3'd6) & (chary == 4'd14);
	
   logic [7:0]  hex;	
	assign hex = digit == 4'd0 ? 8'h3f :
					 digit == 4'd1 ? 8'h06 :
					 digit == 4'd2 ? 8'h5b :
					 digit == 4'd3 ? 8'h4f :
					 digit == 4'd4 ? 8'h66 :
					 digit == 4'd5 ? 8'h6d :
					 digit == 4'd6 ? 8'h7d :
					 digit == 4'd7 ? 8'h07 :
					 digit == 4'd8 ? 8'h7f :
					 8'h6f;

   assign keycurSegs = hex;
						  
endmodule