module FINGER_DETECTION(input logic				clk50,
								input logic [4:0] 	fix_keys_position [0:351],
								input logic [1:0]		pixel_RGB [0:351],
								
								output logic [16:0]	press
								);
logic [4:0] position;
logic [4:0] red_num [0:16];
logic [4:0] red_num_stable [0:16];	
integer i;
integer j;							
								
always_ff @(posedge clk50)
begin
	i <= i + 1;
	if (i == 351) begin
		red_num_stable <= red_num;
		i <= 0;
		red_num[0] <= 0;
		red_num[1] <= 0;
		red_num[2] <= 0;
		red_num[3] <= 0;
		red_num[4] <= 0;
		red_num[5] <= 0;
		red_num[6] <= 0;
		red_num[7] <= 0;
		red_num[8] <= 0;
		red_num[9] <= 0;
		red_num[10] <= 0;
		red_num[11] <= 0;
		red_num[12] <= 0;
		red_num[13] <= 0;
		red_num[14] <= 0;
		red_num[15] <= 0;
		red_num[16] <= 0;
	end
	if (pixel_RGB[i] == 2'b01 && fix_keys_position[i] != 5'd17) begin
		position <= fix_keys_position[i];
		red_num[position] <= red_num[position] + 1;
	end
	
	for (j = 1; j < 17; j = j + 1)
	begin
		if (red_num_stable[j] > 7) begin
			press[j] <= 1;
		end else begin
			press[j] <= 0;
		end
	end	
end

endmodule				