module HEX_CONVERT(input logic [8:0]  digit_1, digit_2,
                   input logic [9:0]  vcount,
						 input logic [10:0] hcount,
						 
                   output logic [7:0] curSegs, segment);
	
   logic [3:0] digit1, digit2, digit3, digit4, digit5, digit6;
   assign digit1 = digit_1 / 100;
   assign digit2 = (digit_1 - digit1 * 100) / 10;
   assign digit3 = digit_1 - digit1 * 100 - digit2 * 10;
	assign digit4 = digit_2 / 100;
   assign digit5 = (digit_2 - digit4 * 100) / 10;
   assign digit6 = digit_2 - digit4 * 100 - digit5 * 10;

	logic [2:0] 			     charx; // Coordinate within the 8x16 char
   logic [3:0] 			     chary;

   assign charx = hcount[3:1];
   assign chary = vcount[3:0];

   logic horizBar, leftCol, rightCol, topCol, botCol; // Parts of the disp.

   assign horizBar = !(charx[2:1] == 2'b11);  // When in any horizontal bar
   assign leftCol  = (charx == 3'd0);         // When in left column
   assign rightCol = (charx == 3'd5);         // When in right column
   assign topCol   = !chary[3] & !(chary[2:0] == 3'd7); // Top columns
   assign botCol   = (chary >= 4'd6) & (chary <= 4'd12); // Bottom columns

   assign segment[0] = horizBar & (chary == 4'd 0);
   assign segment[1] = rightCol & topCol;
   assign segment[2] = rightCol & botCol;
   assign segment[3] = horizBar & (chary == 4'd 12);
   assign segment[4] = leftCol & botCol;
   assign segment[5] = leftCol & topCol;
   assign segment[6] = horizBar & (chary == 4'd 6);
   assign segment[7] = (charx == 3'd6) & (chary == 4'd14);

   logic [2:0] column; // Being displayed
   assign column = hcount[6:4];
	
   logic [7:0]  hex1, hex2, hex3, hex4, hex5, hex6;	
	assign hex1 = digit1 == 4'd0 ? 8'h3f :
					  digit1 == 4'd1 ? 8'h06 :
					  digit1 == 4'd2 ? 8'h5b :
					  digit1 == 4'd3 ? 8'h4f :
					  digit1 == 4'd4 ? 8'h66 :
					  digit1 == 4'd5 ? 8'h6d :
					  digit1 == 4'd6 ? 8'h7d :
					  digit1 == 4'd7 ? 8'h07 :
					  digit1 == 4'd8 ? 8'h7f :
					  8'h6f;

	assign hex2 = digit2 == 4'd0 ? 8'h3f :
					  digit2 == 4'd1 ? 8'h06 :
					  digit2 == 4'd2 ? 8'h5b :
					  digit2 == 4'd3 ? 8'h4f :
					  digit2 == 4'd4 ? 8'h66 :
					  digit2 == 4'd5 ? 8'h6d :
					  digit2 == 4'd6 ? 8'h7d :
					  digit2 == 4'd7 ? 8'h07 :
					  digit2 == 4'd8 ? 8'h7f :
					  8'h6f;

	assign hex3 = digit3 == 4'd0 ? 8'h3f :
					  digit3 == 4'd1 ? 8'h06 :
					  digit3 == 4'd2 ? 8'h5b :
					  digit3 == 4'd3 ? 8'h4f :
					  digit3 == 4'd4 ? 8'h66 :
					  digit3 == 4'd5 ? 8'h6d :
					  digit3 == 4'd6 ? 8'h7d :
					  digit3 == 4'd7 ? 8'h07 :
					  digit3 == 4'd8 ? 8'h7f :
					  8'h6f;

	assign hex4 = digit4 == 4'd0 ? 8'h3f :
					  digit4 == 4'd1 ? 8'h06 :
					  digit4 == 4'd2 ? 8'h5b :
					  digit4 == 4'd3 ? 8'h4f :
					  digit4 == 4'd4 ? 8'h66 :
					  digit4 == 4'd5 ? 8'h6d :
					  digit4 == 4'd6 ? 8'h7d :
					  digit4 == 4'd7 ? 8'h07 :
					  digit4 == 4'd8 ? 8'h7f :
					  8'h6f;

	assign hex5 = digit5 == 4'd0 ? 8'h3f :
					  digit5 == 4'd1 ? 8'h06 :
					  digit5 == 4'd2 ? 8'h5b :
					  digit5 == 4'd3 ? 8'h4f :
					  digit5 == 4'd4 ? 8'h66 :
					  digit5 == 4'd5 ? 8'h6d :
					  digit5 == 4'd6 ? 8'h7d :
					  digit5 == 4'd7 ? 8'h07 :
					  digit5 == 4'd8 ? 8'h7f :
					  8'h6f;

	assign hex6 = digit6 == 4'd0 ? 8'h3f :
					  digit6 == 4'd1 ? 8'h06 :
					  digit6 == 4'd2 ? 8'h5b :
					  digit6 == 4'd3 ? 8'h4f :
					  digit6 == 4'd4 ? 8'h66 :
					  digit6 == 4'd5 ? 8'h6d :
					  digit6 == 4'd6 ? 8'h7d :
					  digit6 == 4'd7 ? 8'h07 :
					  digit6 == 4'd8 ? 8'h7f :
					  8'h6f;			  
					     
   assign curSegs = column == 3'd1 ? hex1 :
		              column == 3'd2 ? hex2 :
		              column == 3'd3 ? hex3 :
		              column == 3'd4 ? 8'hb9 :
		              column == 3'd5 ? hex4 :
		              column == 3'd6 ? hex5 :
		              column == 3'd7 ? hex6 :
		              8'hf7;
						  
endmodule