// avl_st_bytes_packet.v

// This file was auto-generated as a prototype implementation of a module
// created in component editor.  It ties off all outputs to ground and
// ignores all inputs.  It needs to be edited to make it do something
// useful.
// 
// This file will not be automatically regenerated.  You should check it in
// to your version control system if you want to keep it.

module avl_st_packet_bytes (
		input  logic        clk,              //        clk.clk
		input  logic        reset,            //      reset.reset

		

		//Avalon ST interface (src) --------- bytes out
		
		input   logic        out_ready,         //  bytes_out.ready
		output  logic        out_valid,         //           .valid		
		output  logic [31:0] out_data,          //           .data
				
		//Avalon ST interface (sink) --------- packet in
		output logic        sink_ready,         // packets_in.ready
		input  logic        sink_valid,         //           .valid
		input  logic [63:0] sink_data,          //           .data
		input  logic        sink_sop,           //           .startofpacket
		input  logic        sink_eop,           //           .endofpacket
		input  logic  [2:0] sink_empty,         //           .empty

		
		//Avalon MM interface (slave) --------- used for module controlling
		
		input  logic        write,            // control_mm.write
		input  logic [7:0]  writedata,        //           .writedata
		input  logic        read,             // 	  .read
		output  logic [7:0]  readdata,         //           .readdata
		input  logic [3:0]  address,          //           .address
		input  logic        cs                //           .chipselect
	);

		//=======================================================
		//  REG/logic declarations
		//=======================================================
		logic[31:0] sink_data_rh;
		logic[31:0] sink_data_rl;
		logic[0:4][31:0] data_reg;
		logic			    sop_reg;
		logic[1:0]		esc_need;
		logic[2:0]		esc_proc;
		logic					  proc_ready;
		

		//=======================================================
		//  Structural coding
		//=======================================================
      assign sink_data_rl= {sink_data[7-:8],sink_data[15-:8],sink_data[23-:8],sink_data[31-:8]};
      assign sink_data_rh= {sink_data[39-:8],sink_data[47-:8],sink_data[55-:8],sink_data[63-:8]};
      assign esc_need[1] = sink_data_rh==32'h7a7a7a7a||sink_data_rh==32'h7b7b7b7b||sink_data_rh==32'h7d7d7d7d||sink_data_rh==32'h7e7e7e7e;
      assign esc_need[0] = sink_data_rl==32'h7a7a7a7a||sink_data_rl==32'h7b7b7b7b||sink_data_rl==32'h7d7d7d7d||sink_data_rl==32'h7e7e7e7e;
      //assign sink_ready = proc_ready & out_ready;
      assign sink_ready = proc_ready;
   
   always_ff@(posedge clk) begin 
      if (reset) begin
         data_reg[0] <= 32'h7e7e7e7e;
			data_reg[1] <= 32'h7e7e7e7e;
			data_reg[2] <= 32'h7e7e7e7e;
			data_reg[3] <= 32'h7e7e7e7e;
         out_data <= 32'h7e7e7e7e;  // The default output when no income data is 0x7e7e7e7e
         proc_ready <= 1;
         esc_proc <= 0;
      end 
		else 
		begin
				 if (cs) 
				 begin
						if (write) 
						begin
							case (address) 
								default;//do nothing;
							endcase
						end 
						else if (read) 
						begin
							case (address) 
								default;//do nothing;
							endcase
						end
				  end
/////////////////////////////////////From Packets to Bytes///////////////////////////////////////////////////////////////////
				if (out_ready) begin
					out_valid <= 1;
						if (esc_proc==0) 
						begin
							if (sink_valid)
								begin
									/////////////// recieve new data (64bits), generate code, buffer /////////////////////
										proc_ready <= 0;               
									/////////////// if startofpacket//////////////
										if (sink_sop) 
										begin                                      
										out_data <= 32'h7a7a7a7a;
											case (esc_need)
												2'b00: begin
													data_reg[0]<= sink_data_rl;
													data_reg[1]<= sink_data_rh;
													esc_proc <= 3'h2;
												end
												2'b10:begin
													data_reg[0]<= sink_data_rl;
													data_reg[1]<= sink_data_rh^ 32'h20202020;
													data_reg[2]<= 32'h7d7d7d7d;
													esc_proc <= 3'h3;
												end
												2'b01:begin
													data_reg[0]<= sink_data_rl^ 32'h20202020;
													data_reg[1]<= 32'h7d7d7d7d;
													data_reg[2]<= sink_data_rh;
													esc_proc <= 3'h3;
												end
												2'b11:begin
													data_reg[0]<= sink_data_rl^ 32'h20202020;
													data_reg[1]<= 32'h7d7d7d7d;
													data_reg[2]<= sink_data_rh^ 32'h20202020;
													data_reg[3]<= 32'h7d7d7d7d;
													esc_proc <= 3'h4;
												end
												endcase
										end 
									/////////////// if endofpacket////////////////
										else if (sink_eop) 
										begin                                  
										case (sink_empty[2]) 
										1'b0: begin
											case (esc_need)
												2'b00:begin
													data_reg[0]<= sink_data_rl;
													data_reg[1]<= {30'h0,sink_empty[1:0]};
													data_reg[2]<= 32'h7b7b7b7b;
													out_data <= sink_data_rh;
													esc_proc <= 3'h3;
												end
												2'b10:begin
													data_reg[0]<= sink_data_rl;
													data_reg[1]<= {30'h0,sink_empty[1:0]};
													data_reg[2]<= 32'h7b7b7b7b;
													data_reg[3]<= sink_data_rh^ 32'h20202020;
													out_data<= 32'h7d7d7d7d;
													esc_proc <= 3'h4;
												end
												2'b01:begin
													data_reg[0]<= sink_data_rl^ 32'h20202020;
													data_reg[1]<= 32'h7d7d7d7d;
													data_reg[2]<= {30'h0,sink_empty[1:0]};
													data_reg[3]<= 32'h7b7b7b7b;
													out_data<= sink_data_rh;
													esc_proc <= 3'h4;
												end
												2'b11:begin
													data_reg[0]<= sink_data_rl^ 32'h20202020;
													data_reg[1]<= 32'h7d7d7d7d;
													data_reg[2]<= {30'h0,sink_empty[1:0]};
													data_reg[3]<= 32'h7b7b7b7b;
													data_reg[4]<= sink_data_rh^ 32'h20202020;
													out_data<= 32'h7d7d7d7d;
													esc_proc <= 3'h5;
												end
											 endcase
										end
										1'b1: begin
											case (esc_need) 
												2'b00: begin
													data_reg[0]<= sink_data_rh;
													data_reg[1]<= {30'h0,sink_empty[1:0]};
													out_data<= 32'h7b7b7b7b;
													esc_proc <= 3'h2;
												end
												2'b10:begin
													data_reg[0]<= sink_data_rh^ 32'h20202020;
													data_reg[1]<= 32'h7d7d7d7d;
													data_reg[2]<= {30'h0,sink_empty[1:0]};
													out_data<= 32'h7b7b7b7b;
													esc_proc <= 3'h3;
												end
											 endcase
										end
										endcase
										end 
									/////////////// if in frame //////////////////
										else 
										begin                                           
										case (esc_need)
											2'b00: begin
												data_reg[0]<= sink_data_rl;
												out_data <= sink_data_rh;
												esc_proc <= 3'h1;
											end
											2'b10:begin
												data_reg[0]<= sink_data_rl;
												data_reg[1]<= sink_data_rh;
												out_data <= 32'h7d7d7d7d;
												esc_proc <= 3'h2;
											end
											2'b01:begin
												data_reg[0]<= sink_data_rl;
												data_reg[1]<= 32'h7d7d7d7d;
												out_data <= sink_data_rh;
												esc_proc <= 3'h2;
											end
											2'b11:begin
												data_reg[0]<= sink_data_rl;
												data_reg[1]<= 32'h7d7d7d7d;
												data_reg[2]<= sink_data_rh;
												out_data <= 32'h7d7d7d7d;
												esc_proc <= 3'h3;
											end
										 endcase
										end
								end
							else
								begin
										out_data <= 32'h7e7e7e7e;
										data_reg[0] <= 32'h7e7e7e7e;
										data_reg[1] <= 32'h7e7e7e7e;
										data_reg[2] <= 32'h7e7e7e7e;
										data_reg[3] <= 32'h7e7e7e7e;
										out_valid <= 1;
										proc_ready <= 1;
								end
						end
							///////// stream out data in buffer ////////
						else if (esc_proc > 0) 
							begin
								esc_proc <= esc_proc - 1;
								out_data <= data_reg [esc_proc - 1];
								if (esc_proc == 1) proc_ready <= 1;
								else  proc_ready <= 0;
							end
				else 
				begin
					out_data <= 32'h7e7e7e7e;
					out_valid <= 0;
				end
      end
	end
end
endmodule



