// avl_st_bytes_packet.v

// This file was auto-generated as a prototype implementation of a module
// created in component editor.  It ties off all outputs to ground and
// ignores all inputs.  It needs to be edited to make it do something
// useful.
// 
// This file will not be automatically regenerated.  You should check it in
// to your version control system if you want to keep it.

module avl_st_bytes_packet (
		input  logic        clk,              //        clk.clk
		input  logic        reset,            //      reset.reset

		
		//Avalon ST interface (sink) --------- bytes in
		output logic        in_ready,
		input  logic        in_valid,         //           .valid
		input  logic [31:0] in_data,          //           .data
		/*
		//Avalon ST interface (src) --------- bytes out
		
		input   logic        out_ready,         //  bytes_out.ready
		output  logic        out_valid,         //           .valid		
		output  logic [31:0] out_data,          //           .data
				
		/Avalon ST interface (sink) --------- packet in
		output logic        sink_ready,         // packets_in.ready
		input  logic        sink_valid,         //           .valid
		input  logic [63:0] sink_data,          //           .data
		input  logic        sink_sop,           //           .startofpacket
		input  logic        sink_eop,           //           .endofpacket
		input  logic  [2:0] sink_empty,         //           .empty
		*/
		//Avalon ST interface (src) --------- packet out
		
		input   logic        src_ready,         // packets_out.ready
		output  logic        src_valid,         //           .valid		
		output  logic [63:0] src_data,          //           .data
		output  logic        src_sop,           //           .startofpacket
		output  logic        src_eop,           //           .endofpacket
		output  logic  [2:0] src_empty,         //           .empty
		
		//Avalon MM interface (slave) --------- used for module controlling
		
		input  logic        write,            // control_mm.write
		input  logic [7:0]  writedata,        //           .writedata
		input  logic        read,             // 	  .read
		output  logic [7:0]  readdata,         //           .readdata
		input  logic [3:0]  address,          //           .address
		input  logic        cs                //           .chipselect
	);

		//=======================================================
		//  REG/logic declarations
		//=======================================================
		logic[31:0] in_data_reverse;
		logic			in_frame;
		logic[31:0]		data_reg;
		logic			sop_reg;
		logic[1:0]		eop_reg;
		logic[2:0]		empty_reg;
		logic			esc_reg;
		logic			isFull;
		logic   ready_reg;
		logic[7:0] control_reg1,control_reg2,control_reg3,control_reg4,control_reg5,control_reg6,control_reg7;
		logic[31:0] pktincnt,pktoutcnt;
		

      /*logic			in_frame_out;
		logic[2:0]			isFull_out;
		logic[0:1][31:0]	data_reg_out;
		logic			esc_reg_out;*/
		//=======================================================
		//  Structural coding
		//=======================================================
    assign in_ready = ready_reg;
	 assign in_data_reverse= {in_data[7-:8],in_data[15-:8],in_data[23-:8],in_data[31-:8]};
			
			always_ff@(posedge clk) begin 
				if (reset) begin
					ready_reg <= 0;
					control_reg1 <= 0;
					control_reg2 <= 0;
					control_reg3 <= 0;
					control_reg4 <= 0;
					control_reg5 <= 0;
					control_reg6 <= 0;
					control_reg7 <= 0;
				end else begin
				    if (cs) begin
					if (write) begin
						case (address) 
							3'h0 : ready_reg <= writedata[0];
							3'h1 : control_reg1 <= writedata;
							3'h2 : control_reg2 <= writedata;
							3'h3 : control_reg3 <= writedata;
							3'h4 : control_reg4 <= writedata;
							3'h5 : control_reg5 <= writedata;
							3'h6 : control_reg6 <= writedata;
							3'h7 : control_reg7 <= writedata;
							default;//do nothing;
						endcase
					end else if (read) begin
						case (address) 
							3'h0 : readdata <= pktincnt[7:0];
							3'h1 : readdata <= pktincnt[15:8];
							3'h2 : readdata <= pktincnt[23:16];
							3'h3 : readdata <= pktincnt[31:24];
							3'h4 : readdata <= pktoutcnt[7:0];
							3'h5 : readdata <= pktoutcnt[15:8];
							3'h6 : readdata <= pktoutcnt[23:16];
							3'h7 : readdata <= pktoutcnt[31:24];
							default;//do nothing;
						endcase
					end
				   end
/////////////////////////////////////From Bytes to Packets///////////////////////////////////////////////////////////////////
					if (in_valid) begin
						case (in_data_reverse)
						    32'h7a7a7a7a : begin        //0x7a7a7a7a Indicates Start Of Packet;
							   src_valid <= 0;
								src_eop <= 0;
							   sop_reg <= 1;
                        eop_reg <= 0;
                        in_frame <= 1;
							end
						    32'h7b7b7b7b : begin        //0x7b7b7b7b Indicates End Of Packet;
							   src_valid <= 0;
							   sop_reg <= 0;
                        in_frame <= 0;
                        eop_reg <= 2'b01;
							end 
						    32'h7d7d7d7d : begin        //0x7d7d7d7d Indicates Escape, Data after it should XOR with 0x20202020;
							   src_valid <= 0;
							   if (in_frame) esc_reg <= 1;
							end
						    default: begin
							     if (isFull) begin
								   if (in_frame) begin         //In Data Frame: Data Out
									src_valid <= 1;
									isFull <= 0; //isFull cleared
									if (esc_reg) begin     //A Escape Flag Was Triggered
									   src_data <= {data_reg,in_data_reverse ^ 32'h20202020};
									   esc_reg <= 0;
									end else src_data <= {data_reg,in_data_reverse};
									src_sop <= sop_reg;
									sop_reg <= 0;		
								   end else if (eop_reg[0]) begin  //In End Of Packet State: Data Mask
									case (in_data_reverse)
									   32'hff000000: empty_reg <= 3'h3;
									   32'hffff0000: empty_reg <= 3'h2;
									   32'hffffff00: empty_reg <= 3'h1;
									   32'hffffffff: empty_reg <= 3'h0;
									   default: empty_reg <= 0;
									endcase
									src_eop <= 1;
									eop_reg <= 2'b10;
			                                                src_valid <= 0;
								   end else if (eop_reg[1]) begin //In End Of Packet State: Final Data Out With Empty Signal
									src_valid <= 1;
									isFull <= 0;  //isFull cleared
									src_sop <= 0;
									src_eop <= 1;
									if (esc_reg) begin     //A Escape Flag Was Triggered
									   src_data <= {in_data_reverse ^ 32'h20202020,data_reg};
									   esc_reg <= 0;
									end else src_data <= {data_reg,in_data_reverse};
									src_empty <= empty_reg;
									empty_reg <= 0;
									eop_reg <= 2'b00;
								   end else begin
									src_eop <= 0;
									src_sop <= 0;
                           src_valid <= 0;
								   end
							     end else begin
								   if (in_frame) begin         //In Data Frame: No Data Out
									src_valid <= 0;
									isFull <= 1; //isFull set
									if (esc_reg) begin     //A Escape Flag Was Triggered
									   data_reg <= in_data_reverse ^ 32'h20202020;
									   esc_reg <= 0;
									end else data_reg <= in_data_reverse;
									src_sop <= sop_reg;	
								   end else if (eop_reg[0]) begin  //In End Of Packet State: Data Mask
									src_valid <= 0;
									case (in_data_reverse)
									   32'hff000000: empty_reg <= 3'h7;
									   32'hffff0000: empty_reg <= 3'h6;
									   32'hffffff00: empty_reg <= 3'h5;
									   32'hffffffff: empty_reg <= 3'h4;
									   default: empty_reg <= 3'h4;
									endcase
									src_eop <= 1;
									eop_reg <= 2'b10;
								   end else if (eop_reg[1]) begin //In End Of Packet State: Final Data Out With Empty Signal
									src_valid <= 1;
									isFull <= 0;  //isFull cleared
									src_sop <= 0;
									src_eop <= 1;
									if (esc_reg) begin     //A Escape Flag Was Triggered
									   src_data <= {32'h0,in_data_reverse ^ 32'h20202020};
									   esc_reg <= 0;
									end else src_data <= {in_data_reverse,32'h0};
									src_empty <= empty_reg;
									empty_reg <= 0;
									eop_reg <= 2'b00;
								   end else begin
									src_eop <= 0;
									src_sop <= 0;
			                  src_valid <= 0;
								   end
							     end
							end

						endcase
					end else begin
						src_eop <= 0;
						src_sop <= 0;
					   src_valid <= 0;
						src_empty <= 0;
						src_data <= 0;
					end
/////////////////////////////////////From Packets to Bytes///////////////////////////////////////////////////////////////////
				/*if (out_ready) begin
				    out_valid <= 1;
				    if (sink_valid) begin
					if (sink_sop) begin
					    in_frame_out <= 1;
					    isFull_out <= 0;
					end
					if (isFull_out==) begin
					    out_data <= data_reg_out;
					    isFull_out <= 0;
					    sink_ready <= 1;
					end else begin
					    sink_ready <= 0;
					    data_reg_out <= sink_data;
					    if (sink_data[63:32]==32'h00000000||sink_data[63:32]==32'h7a7a7a7a||sink_data[63:32]==32'h7b7b7b7b||sink_data[63:32]==32'h7d7d7d7d) begin
						out_data <= 32'7d7d7d7d;
						data_reg_out[0] <= sink_data[63:32] ^ 32'h20202020;
						data_reg_out[1] <= sink_data[31:0];
					    else begin
						
					end
				    end else begin
					
				    end
				end else begin
				    out_valid <= 0;
				    out_data <= 0;
				end*/
			end
		end


endmodule


