library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity VGA_Display is
  port (
    clk : in std_logic;
    rstn : in std_logic;
    color : in std_logic;
    VGA_CLK : in std_logic;
    VGA_X, VGA_Y : in unsigned(9 downto 0);
    VGA_VS : in std_logic;
    Red, Green, Blue : out unsigned(9 downto 0)
  );

end VGA_Display;

architecture datapath of VGA_Display is
  
component fbmem
  PORT
    (
      data		: IN STD_LOGIC_VECTOR (0 DOWNTO 0);
      rdaddress		: IN STD_LOGIC_VECTOR (18 DOWNTO 0);
      rdclock		: IN STD_LOGIC ;
      wraddress		: IN STD_LOGIC_VECTOR (18 DOWNTO 0);
      wrclock		: IN STD_LOGIC ;
      wren		: IN STD_LOGIC := '1';
      q	        	: OUT STD_LOGIC_VECTOR (0 DOWNTO 0)
      );
end component;

component lines
  port
    (
      clk, rst : in std_logic;
      x0, y0, x1, y1 : in signed(10 downto 0);
      x_p, y_p : out signed(10 downto 0);
      start : in std_logic; 
      done, plot : out std_logic
    );
end component;

signal rdaddress, wraddress : unsigned(19 downto 0);
signal read_data : STD_LOGIC;
signal write_data : STD_LOGIC; -- := '1';
signal data, q: STD_LOGIC_VECTOR(0 downto 0);

signal VGA_XW, VGA_YW : unsigned(9 downto 0) := (others => '0');

signal x0 : signed(10 downto 0); 
signal y0 : signed(10 downto 0);
signal x1 : signed(10 downto 0);
signal y1 : signed(10 downto 0);
signal start_line : std_logic;
signal done_line, last_done_line : std_logic;
signal wren : std_logic;
signal last_color, rst : std_logic;

signal x_p, y_p : signed(10 downto 0);

type states is (S_TOP, S_RIGHT, S_BOTTOM, S_LEFT, VBLANK);

signal state : states;

begin
  
  process (clk)
  begin
    if rising_edge(clk) then
      start_line <= '0';
      if color = '1' and last_color = '0' then
        start_line <= '1';
      end if;
      last_color <= color;

      if rstn = '0' then
        write_data <= '1';
        x0 <= to_signed(0,11);
        y0 <= to_signed(0,11);
        x1 <= to_signed(320,11);
        y1 <= to_signed(200,11);
        state <= S_TOP;
      else
        case state is
          when S_TOP =>
            if done_line = '1' then
              start_line <= '1';
              if x0 < to_signed(620,11) then
                x0 <= x0 + 10;
              else
                state <= S_RIGHT;
                x0 <= to_signed(639,11);
                y0 <= to_signed(0,11);
              end if;
            end if;

          when S_RIGHT =>
            if done_line = '1' then
              start_line <= '1';
              if y0 < to_signed(460,11) then
                y0 <= y0 + 10;              
              else
                state <= S_BOTTOM;
                x0 <= to_signed(639,11);
                y0 <= to_signed(479,11);              
              end if;
            end if;

            
          when S_BOTTOM =>
            if done_line = '1' then
              start_line <= '1';
              if x0 > to_signed(20, 11) then
                x0 <= x0 - 10;
              else
                state <= S_LEFT;
                x0 <= to_signed(0,11);
                y0 <= to_signed(479,11);
              end if;
            end if;

          when S_LEFT =>
            if done_line = '1' then
              start_line <= '1';
              if y0 > to_signed(20, 11) then
                y0 <= y0 - 10;
              else
                state <= S_TOP;
                x0 <= to_signed(0,11);
                y0 <= to_signed(0,11);
                write_data <= not write_data;
                if write_data = '0' then
                  if x1 < to_signed(600,11) then
                    x1 <= x1 + 3;
                  else
                    x1 <= to_signed(40,11);
                    if y1 < to_signed(440,11) then
                      y1 <= y1 + 3;
                    else
                      y1 <= to_signed(40, 11);
                    end if;                    
                  end if;
                else
                  state <= VBLANK;
                  start_line <= '0';
                end if;
              end if;
            end if;

          when VBLANK =>
           if VGA_VS = '0' then
             start_line <= '1';
             state <= S_TOP;
           end if;
           
        end case;
      end if;
    end if;
  end process;

  lines_inst : lines port map (
    clk => clk,
    x0 => x0,
    y0 => y0,
    x1 => x1,
    y1 => y1,
    x_p => x_p,
    y_p => y_p,
    start => start_line,
    done => done_line,
    plot => wren,
    rst => rst
    );

  rst <= not rstn;

  VGA_XW <= unsigned(x_p(9 downto 0));
  VGA_YW <= unsigned(y_p(9 downto 0));

  frame_buffer_memory : fbmem PORT MAP (
    rdaddress	 => std_logic_vector(rdaddress(18 downto 0)),
    rdclock	 => VGA_CLK,
    q	         => q,
    data	 => data,
    wraddress	 => std_logic_vector(wraddress(18 downto 0)),
    wrclock	 => clk,
    wren	 => wren
    );

  read_data <= '1' when q(0) = '1' else '0';
  data <= "1" when write_data = '1' else "0";

  rdaddress <= ("0000000000" & VGA_X) + (VGA_Y & "0000000") + (VGA_Y & "000000000");
  wraddress <= ("0000000000" & VGA_XW) + (VGA_YW & "0000000") + (VGA_YW & "000000000");

--  process (clk)
--  begin
--    if rising_edge(clk) then
--    end if;
--  end process;

  process (VGA_CLK)
  begin
    if rising_edge(VGA_CLK) then
      Red <= (others => '0');
      Green <= (others => '0');
      Blue <= (others => '0');
      if read_data = '1' then
        Red <= (others => '1');
        Green <= (others => '1');
        Blue <= (others => '1');
      end if;
    end if;
  end process;

end datapath;
  
  
