#include <iostream>
#include <vector>
#include <string>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "input.c"

using namespace std;

const char *byte_to_binary(int x) {
  static char b[9];
  b[0] = 0;

  int z;
  for (z = 256; z > 0; z >>= 1) {
    strcat(b, ((x & z) == z) ? "1" : "0");
  }

  return b;
}

void removeFirst (char *s) {
      if (*s == '\0') return;
          *s = *(s+1);
              removeFirst (s+1);
}


string f(int i) {
  char d[9];
  sprintf(d, "%s", byte_to_binary(i));
  removeFirst(d);
  return d;
}

string f2(int i) {
  char d[2];
  sprintf(d, "%02x", i);
  return d;
}

int main() {
  int pixels = gimp_image.width*gimp_image.height; 
  char pcount[100];
  sprintf(pcount, "%d", pixels-1);
  string out = "";
  out += "type _type is array(0 to " + (string) pcount + ") of std_logic_vector(" + ((gimp_image.bytes_per_pixel==3) ? "23" : "24") + " downto 0);\n";
  out += "constant _image : _type := (";
  if(gimp_image.bytes_per_pixel==4){
    out += "\"";
    out += (gimp_image.pixel_data[3] != 0x00) ? "1" : "0";
    out += f(gimp_image.pixel_data[0]);
    out += f(gimp_image.pixel_data[1]);
    out += f(gimp_image.pixel_data[2]);
  } else {
    out += "x\"";
    out += f2(gimp_image.pixel_data[0]);
    out += f2(gimp_image.pixel_data[1]);
    out += f2(gimp_image.pixel_data[2]);
  }
  int i = gimp_image.bytes_per_pixel;
  while(i < pixels*gimp_image.bytes_per_pixel) {
    if(gimp_image.bytes_per_pixel==4){
      out += "\", \"";
      out += (gimp_image.pixel_data[i+3] != 0x00) ? "1" : "0";
      out += f(gimp_image.pixel_data[i+0]);
      out += f(gimp_image.pixel_data[i+1]);
      out += f(gimp_image.pixel_data[i+2]);
      i = i + 4; 
    } else {
      out += "\", x\"";
      out += f2(gimp_image.pixel_data[i+0]);
      out += f2(gimp_image.pixel_data[i+1]);
      out += f2(gimp_image.pixel_data[i+2]);
      i = i + 3; 
    }
  }

  out += "\");";
  cout << out << endl;

  return 0;
}
