LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY tile_ram IS
	PORT
	(
		clk		: IN STD_LOGIC ;
		data		: in integer range 0 to 31;
		rdaddress_a_x, rdaddress_b_x, wraddress_x: in integer range 0 to 39;
		rdaddress_a_y, rdaddress_b_y, wraddress_y : in integer range 0 to 31;
		wren		: IN STD_LOGIC;
		qa		: out integer range 0 to 31;
		qb		: out integer range 0 to 31
	);
END tile_ram;


ARCHITECTURE SYN OF tile_ram IS
	type X_type is array (0 to 39) of integer range 0 to 31;
	type Y_type is array (0 to 31) of x_type ;   -- 32 * 40 blocks because there is an additional line.
	
	signal RAM : Y_type;
BEGIN

process (clk)
begin
	if rising_edge(clk) then
		qa <= RAM(rdaddress_a_y)(rdaddress_a_x);
		qb <= RAM(rdaddress_b_y)(rdaddress_b_x);
		
		if wren = '1' then
			RAM(wraddress_y)(wraddress_x) <= data;
		end if;
	end if;
end process;

END SYN;