#ifndef VGA_H_
#define VGA_H_

#include <system.h>

#define MIN_X 4
#define MAX_X 639
#define MIN_Y 32
#define MAX_Y 480

#define MAN_W 20
#define MAN_H 28
#define TILE_W 16
#define TILE_H 16

extern int tiles[40][32];

#define PROPERTY_BITS 2
#define PROPERTY_TILE 0
#define PROPERTY_MAN 1
#define PROPERTY_SETTING 2
#define PROPERTY_IRQ 3

#define CREATE_ADDRESS(property, address) \
    (0x1FFFF & ((((property) << (16-PROPERTY_BITS)) | (address))*2))

#define SET_VGA_PROP(property, address, value) \
    IOWR_16DIRECT(VGA_BASE, CREATE_ADDRESS(property, address), (value))
#define GET_VGA_PROP(property, address) \
    IORD_16DIRECT(VGA_BASE, CREATE_ADDRESS(property, address))


/* Tile Settings */
#define CREATE_TILE_ADDR(x, y) \
    (((y & 0x1F) << 6) | (x & 0x3F))
#define SET_TILE(x, y, value) \
    tiles[x][y] = value; \
    SET_VGA_PROP(PROPERTY_TILE, CREATE_TILE_ADDR(x, y), (value)) 
#define GET_TILE(x, y) \
    (0x2F & GET_VGA_PROP(PROPERTY_TILE, CREATE_TILE_ADDR(x, y)))
    
#define GET_OFFSETS() \
    alt_u16 readdata = IORD_16DIRECT(VGA_BASE, 0) & 0xffc0; \
    tileOffset = ((readdata & 0xf800) >> 11); \
    pixOffset = ((readdata & 0x0780) >> 7)
    
#define RESET_INTERRUPT() \
    SET_VGA_PROP(PROPERTY_IRQ, 0, 0)
    
/* Man Settings */
#define MAN_FORWARD 0
#define MAN_LEFT 1
#define MAN_RIGHT 2

#define SET_MAN_PROP(param, value) SET_VGA_PROP(PROPERTY_MAN, param, value)

#define SET_MAN_X(x) SET_MAN_PROP(0, x)
#define SET_MAN_Y(y) SET_MAN_PROP(1, y)
#define SET_MAN_DIR(d) SET_MAN_PROP(2, d)

/* Settings */
#define SETTING_SPEED 0

#define SET_SETTING(param, value) SET_VGA_PROP(PROPERTY_SETTING, param, value)
#define SET_SPEED(s) \
    speed = s; \
    SET_SETTING(SETTING_SPEED, s)

#endif /*VGA_H_*/
