#ifndef TILES_H_
#define TILES_H_

#include "vga.h"

#define TILE_0 0
#define TILE_1 1
#define TILE_2 2
#define TILE_3 3
#define TILE_4 4
#define TILE_5 5
#define TILE_6 6
#define TILE_7 7
#define TILE_8 8
#define TILE_9 9
#define TILE_BLACK 10
#define TILE_BRICK1 11
#define TILE_BRICK2 12
#define TILE_BRICK3 13
#define TILE_GAME_OVER1 14
#define TILE_GAME_OVER2 15
#define TILE_GAME_OVER3 16
#define TILE_GAME_OVER4 17
#define TILE_HEALTH1 18
#define TILE_HEALTH2 19
#define TILE_HEALTH3 20
#define TILE_HEART 21
#define TILE_HIGH1 22
#define TILE_HIGH2 23
#define TILE_POWERUP 24
#define TILE_SAND1 25
#define TILE_SAND2 26
#define TILE_SAND3 27
#define TILE_SCORE1 28
#define TILE_SCORE2 29
#define TILE_SCORE3 30
#define TILE_SPIKE_REV 31
#define TILE_SPIKE 32
#define TILE_SPRING 33
#define TILE_WHITE 34

#define SCORE_X 36
#define HEALTH_X 3

void puttiles(int x, int y, int count, int startTile) {
    int i = 0;
    for(i = 0; i<count; i++) {
        SET_TILE((x+i), y, (startTile+i));  
    }   
}

void setScore(int score, int x, int y) {
    int i;
    for(i = 3; i >= 0; i--) {
        SET_TILE((x+i), y, score%10);
        score = score/10;
    }
}

void setHealth(int health) {
    int i;
    for(i = 0; i < 8; i++) {
        SET_TILE((HEALTH_X+i), 0, (i < health) ? TILE_HEART : TILE_WHITE);
    }
}

void putPlatform(int x, int y, int platform) {
    int i;
    for(i = 0; i < 3; i++) {
        SET_TILE((x+i), y, (platform == TILE_SPIKE || platform == TILE_SPRING || platform == TILE_POWERUP) ? platform : platform + i);
    }
    for(i = 0; i < 3; i++) {
        SET_TILE((x+3+i), y, (platform == TILE_SPIKE || platform == TILE_SPRING || platform == TILE_POWERUP) ? platform : platform + i);
    }
}

#endif /*TILES_H_*/
