#include <io.h>
#include <system.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/alt_irq.h>
#include <alt_types.h>
#include "vga.h"
#include "tiles.h"
#include "control.h"
#include "sound.h"
#define GRAVITY 3
#define X_STEP 48

#define MAX_LEVEL 40
#define LEVEL_INC 5
#define MIN_SPEED 0x1FFF
#define START_SPEED 0xFFFF
#define SPEED_INC ((START_SPEED/MAX_LEVEL)*2)

int seeder = 2020;
int highScore = 0;
int score = 0;
int health = 8;
int man_x, next_man_x;
int man_y, next_man_y;
int man_y_vel;
int genPlatform = 0, drawPlatform = 0;
int platformType, platformX, lastY = 0;
int tileOffset, pixOffset;
int tiles[40][32];
int onTile = 0, scoreUpdated = 0;
int tile_under = TILE_BLACK;
int bouncing = 0;
int bounce_vel = 0;
int topHit = 0;
int onSand = 0, sand_row = -1, sandCounter = 0, bFrom = -1, speed, row_under = 0;
int level, genLevelProb;

int  genY(int actualY) {   
    int topy;
    GET_OFFSETS();
    topy = tileOffset + actualY - 1;

    if(topy > 31) topy -= 30;
    if(topy < 2) topy += 30;
    
    return topy;
}

void setupScreen() {
    srand(seeder);
    SET_SPEED (0);
    
    level = MAX_LEVEL;
    genPlatform = drawPlatform = lastY = onTile = scoreUpdated = 
        bouncing = bounce_vel = topHit = onSand = sandCounter = 0;
    
    score = 0;
    health = 8;
    man_x = (MAX_X - MIN_X)/2 - MAN_W/2;
    man_y = TILE_H*15 - MAN_H;
    man_y_vel = 0;
    
    int x, y;
    for(x = 0; x < 40; x++) {
        SET_TILE(x, 0, TILE_WHITE);
        SET_TILE(x, 1, TILE_SPIKE_REV); 
    }
    for(x = 0; x < 40; x++) {
        for(y = 2; y <= 31; y++) {
            SET_TILE(x, y, TILE_BLACK);   
        } 
    }
    
    puttiles(0, 0, 3, TILE_HEALTH1);
    puttiles(33, 0, 3, TILE_SCORE1);

    for(x = 10; x <=30; x = x + 3) {
         puttiles(x, genY(28), 3, TILE_BRICK1);
    }
    
    next_man_x = man_x;
    next_man_y = man_y;
    
    genLevelProb = (MAX_LEVEL*(level-(MAX_LEVEL/2)) - 100);
}

void bounceTo(int bVel, int bounceFrom) {
    //printf("Starting bounce\n"); 
    makeSound (SOUNDOFBOUNCE);
    bounce_vel = bVel;
    bouncing = 1;
    bFrom = bounceFrom;
}


void waitForInput(int count) {
   muteTheBackground ();
   while(count) {
        if(CONTROL_DIR() == CONTROL_LEFT || CONTROL_DIR() == CONTROL_RIGHT) {
               count --;
        }
    }
}

void gameOver() {
    int x, y;
    
    seeder += score;
    
    if(score > highScore) {
        highScore = score;   
    }
    
    SET_SPEED(0);
    for(x = 0; x < 40; x++) {
        for(y = 0; y <= 31; y++) {
            SET_TILE(x, y, TILE_WHITE);   
        } 
    }
    
    puttiles(18, genY(10), 4, TILE_GAME_OVER1);
    
    puttiles(17, genY(17), 3, TILE_SCORE1);
    setScore(score, 20, genY(17));
    puttiles(16, genY(18), 2, TILE_HIGH1);
    puttiles(18, genY(18), 3, TILE_SCORE1);
    setScore(highScore, 21, genY(18));
    
    man_x = (MAX_X - MIN_X)/2 - MAN_W/2;
    man_y = TILE_H*9 - MAN_H;
    
    SET_MAN_DIR (MAN_FORWARD);
    SET_MAN_X(man_x);
    SET_MAN_Y(man_y);
    
    waitForInput(10000);
    
    setupScreen();
    SET_SPEED (START_SPEED);
}

void updateManY() {
    int x_tile, y_tile;

    x_tile = (man_x + MAN_W)/TILE_W;
    if(x_tile >= 40) x_tile = 39;
    y_tile = (man_y + MAN_H + pixOffset)/TILE_H + tileOffset - 1;
    if(y_tile > 31) y_tile -= 30;
    if(y_tile < 2) y_tile += 30;
    
    tile_under = tiles[x_tile][y_tile];
    if(tile_under == TILE_BLACK) {
        x_tile = (man_x)/TILE_W;
        if(x_tile >= 40) x_tile = 39;
        tile_under = tiles[x_tile][y_tile];
    }
    
    if(tile_under != TILE_BLACK && !bouncing) {
        onTile = 1;
    } else {
        onTile = 0;   
    }
    
    if(!bouncing) {
        if(onTile) {
            row_under = y_tile;
            
            if(tile_under == TILE_SPIKE || tile_under == TILE_SPRING) {
                bounceTo(15, tile_under);
            } else if(tile_under >= TILE_SAND1 && tile_under <= TILE_SAND3 && !onSand) {
              onSand = 1;
              sand_row = y_tile; 
              sandCounter = 0x7FFF;
            } 
        } else {
            next_man_y += GRAVITY; 
        }
    } else {
        //printf("Bouncing\n"); 
        if(!bounce_vel) {
            bouncing = 0;
           // printf("Done Bouncing\n");   
        }
    }
}

static void drawScreen(void * context, alt_u32 id){
    int x, new_y, pth = topHit;
    GET_OFFSETS();
    
    setScore(score, SCORE_X, 0);
    setHealth(health);
    
    if (man_x < next_man_x){
        man_x += 8;
        if(man_x > MAX_X - MAN_W) {
             man_x = next_man_x = MAX_X - MAN_W;
        }
        SET_MAN_DIR (MAN_RIGHT);
    } else if (man_x > next_man_x){
        man_x -= 8; 
        if(man_x < MIN_X) {
            man_x = next_man_x = MIN_X;
        }
        SET_MAN_DIR (MAN_LEFT); 
    } else {
        SET_MAN_DIR (MAN_FORWARD);   
    }

    new_y = man_y;
    if(bouncing) {
        new_y -= bounce_vel;
        if(bounce_vel >= 1 ) bounce_vel --;
    } else if (onTile) {
        new_y =  row_under - tileOffset + 1;
        if(new_y < 2) new_y += 30;
        new_y = new_y*16 - MAN_H - pixOffset;
    } else if (man_y < next_man_y){
        new_y += 1;
    } else if (man_y > next_man_y){
        new_y -= 1;
    }
    
    
    topHit = 0;
    if(new_y > (MAX_Y - MAN_H)) {
        new_y = (MAX_Y - MAN_H);
        bounceTo(20, TILE_BLACK);
        health--;
    } else if(new_y < (TILE_H * 2)) {
        new_y = (TILE_H * 2);
        topHit = 1;
        
        if(pth != topHit && topHit && (!bouncing || (bouncing && bFrom != TILE_SPIKE))) {
            health--;   
        }
    }
    
    man_y = new_y;

    SET_MAN_X(man_x);
    SET_MAN_Y(man_y);
    
    if(lastY != tileOffset) {
        genPlatform = 0;  
        for(x = 0; x < 40; x++) {
            SET_TILE(x, tileOffset, TILE_BLACK);   
        } 
        if(drawPlatform) {
            lastY = tileOffset;
          
            putPlatform(platformX, tileOffset, platformType);
            drawPlatform = 0;
        }
    }
    
    if(sandCounter < 0) {
        onSand = 0;
        for(x = 0; x < 40; x++) {
            SET_TILE(x, sand_row, TILE_BLACK);   
        } 
    }
    
    if(health == 0) {
        makeSound (SOUNDOFDEATH);
        gameOver();
    }
        
    RESET_INTERRUPT();
}

void generatePlatform() {
    if(!genPlatform) {
        genPlatform = 1;
        drawPlatform = (rand()%(MAX_LEVEL*MAX_LEVEL) <= genLevelProb);

        if(drawPlatform) {
               platformType = rand()%100;
               if(platformType >= 0 && platformType < 40) {
                    platformType = TILE_BRICK1;
               } else if(platformType >= 40 && platformType < 60) {
                    platformType = TILE_SAND1;
               } else if(platformType >= 60 && platformType < 80) {
                    platformType = TILE_SPIKE;
               } else if(platformType >= 80 && platformType < 95) {
                    platformType = TILE_SPRING;
               } else {
                    platformType = TILE_POWERUP;
                    if(health == 8) {
                        genPlatform = 0;
                        drawPlatform = 0;    
                    }
               }
               
               platformX =  rand()%35;
        }
    }
}

void updateManPosition() {
    if(next_man_x == man_x) {
        if(CONTROL_DIR() == CONTROL_LEFT) {
            next_man_x -= X_STEP;
        } else if(CONTROL_DIR() == CONTROL_RIGHT) {
            next_man_x += X_STEP;
        }
        
        if(next_man_x < MIN_X) next_man_x = MIN_X;
        else if(next_man_x > (MAX_X - MAN_W)) next_man_x = (MAX_X - MAN_W);
    }
    
    updateManY();
}

void updateScore() {
   if(onTile == 1 && !scoreUpdated) {
        score++;
        if(tile_under == TILE_SPIKE) {
            health--;   
        } else if (tile_under == TILE_POWERUP) {
            if(health < 8) {
                health++;   
            }
        }
        
        level = MAX_LEVEL - score/LEVEL_INC;
        if(level <= 0) level = 1;
        
        speed = START_SPEED - MAX_LEVEL*SPEED_INC + level*SPEED_INC;
        if(speed < MIN_SPEED) speed = MIN_SPEED;
        SET_SPEED(speed);
        
        genLevelProb = (MAX_LEVEL*(level-(MAX_LEVEL/2)) - 100);
        if(genLevelProb < MAX_LEVEL*2) genLevelProb = MAX_LEVEL*2;

        scoreUpdated = 1;
   } else if(onTile == 0) {
        scoreUpdated = 0;
   } 
}

int main() {
    alt_irq_register(VGA_IRQ, NULL, (void*)drawScreen);
    alt_irq_register(GAME_SOUND_IRQ, NULL, (void*)newBackGroundMusic ); 
    setupScreen();

    waitForInput(1);
    SET_SPEED (START_SPEED);
    
    while(1) {
       generatePlatform();
       updateManPosition();
       updateScore();
       if(onSand) sandCounter --;
    }
    
    return 0;
}
