-- Quartus II VHDL Template
-- Four-State Moore State Machine

-- A Moore machine's outputs are dependent only on the current state.
-- The output is written only when the state changes.  (State
-- transitions are synchronous.)

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity rotaryController is

port(
clk		 : in	std_logic;
input	 : in	std_logic_vector (1 downto 0);
reset_n	 : in	std_logic;
output	 : out	unsigned (1 downto 0)
);

end entity;

architecture rtl of rotaryController is

-- Build an enumerated type for the state machine
type state_type is (s0, s1, s2, s3, s4 , s5, s6);

-- Register to hold the current state
signal state   : state_type;
--signal counter : unsigned (3 downto 0);
begin

		
-- Logic to advance to the next state
process (clk)
begin
if reset_n = '0' then
state <= s0;
elsif (rising_edge(clk)) then
case state is
when s0=>
if input = "01" then
state <= s1;
elsif input = "10" then
state <= s4;
else
state <= s0;
end if;
when s1=>
if input = "11" then
state <= s2;
elsif input = "00" then
state <= s0;
else
state <= s1;
end if;
when s2=>
if input = "10" then
state <= s3;
elsif input = "00" then
state <= s0;
else
state <= s2;
end if;
when s3 =>
if input = "00" then
state <= s0;
else
state <= s3;
end if;
when s4 =>
if input = "11" then
state <= s5;
elsif input = "00" then
state <= s0;
else
state <= s4;
end if;
when s5 =>
if input = "01" then
state <= s6;
elsif input = "00" then
state <= s0;
else
state <= s5;
end if;


when s6 =>
if input = "00" then
state <= s0;
else
state <= s6;
end if;
end case;
end if;
end process;

-- Output depends solely on the current state
process (state)
begin
case state is
when s0 =>
output <= "00";
when s1 =>
output <= "00";
when s2 =>
output <= "00";
when s3 =>
output <= "10";
when s4 =>
output <= "00";
when s5 =>
output <= "00";
when s6 =>
output <= "11";

end case;
end process;

end rtl;
