library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity musicController is port (
	reset_n, clk, chipSelect, write, address: std_logic;
	AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic;  --    Audio CODEC Bit-Stream Clock
	writedata : std_logic_vector (15 downto 0)
);
end musicController;

architecture rtl of musicController is 
signal start : std_logic;
signal audio_clock : unsigned(1 downto 0) := "00";
signal audio_request : std_logic;
signal data1 : std_logic_vector (15 downto 0) ; 
signal counter : unsigned (1 downto 0); 
signal trigger : std_logic;
Component de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    test_mode : in std_logic;       --    Audio CODEC controller test mode
    audio_request : out std_logic;  --    Audio controller request new data
    data : in std_logic_vector (15 downto 0);
    start: in std_logic;
    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  component;



begin


process (clk)
  begin
    if rising_edge(clk) then
      audio_clock <= audio_clock + "1";
    end if;
  end process;

	process (clk)
	begin
		if rising_edge(clk) then
			if reset_n = '0' then
				start <= '0';
				data1 <= (others =>'0');
			else
				if chipSelect = '1' and write = '1'  then
					if address = '0' then
						start <= writedata(0);
					else
						data1 <= writedata;
					end if;
				end if;
				
			end if;
		end if;
	end process;
			
	--write data (1 downto 0) means which tones to sound
	--write data (2 ) means whether to start the sound
	--
	--
	--
v:	de2_wm8731_audio port map (
	audio_clock(1),
	reset_n,
	'1',
	audio_request,
	data1,
	start,
	AUD_ADCLRCK  ,
    AUD_ADCDAT   ,
    AUD_DACLRCK ,
    AUD_DACDAT  ,
    AUD_BCLK 
);

end rtl;