library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity musicControl is port (
clk		 : in	std_logic;
reset_n : in std_logic;
chipSelect: in std_logic;
write: in std_logic;
address : in std_logic;
writedata: in unsigned (15 downto 0);
AUD_ADCLRCK  : out std_logic;       --    Audio CODEC ADC LR Clock
AUD_ADCDAT   : in  std_logic;       --    Audio CODEC ADC Data
AUD_DACLRCK  : out std_logic;       --    Audio CODEC DAC LR Clock
AUD_DACDAT   : out std_logic;       --    Audio CODEC DAC Data
AUD_BCLK     : inout std_logic      --    Audio CODEC Bit-Stream Clock

);
end musicControl;

architecture rtl of musicControl is
signal tone: unsigned (15 downto 0);
signal counter : unsigned (24 downto 0);
signal tone_out, tone_out0,tone_out1,tone_out2,tone_out3 : unsigned (3 downto 0);
signal counter_tone : unsigned (1 downto 0);
 signal audio_clock : unsigned(1 downto 0) := "00";
signal audio_request : std_logic;
signal Stop : std_logic ;
signal stopCount : unsigned (2 downto 0);
  component de2_wm8731_audio is
   port (
    clk : in std_logic;                 --    Audio CODEC Chip Clock AUD_XCK
    reset_n : in std_logic;
    test_mode : in std_logic;           --    Audio CODEC controller test mode
    audio_request : out std_logic;      --    Audio controller request new data
    data : in std_logic_vector(15 downto 0);
	tone: in unsigned (3 downto 0);
	stop: in std_logic;
    -- Audio interface signals
    AUD_ADCLRCK  : out std_logic;       --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in  std_logic;       --    Audio CODEC ADC Data
    AUD_DACLRCK  : out std_logic;       --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out std_logic;       --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic      --    Audio CODEC Bit-Stream Clock
  );
  end component;

begin	

V1: de2_wm8731_audio port map (
    clk => audio_clock(1),
    reset_n => '1',
    test_mode => '0',                   -- Output a sine wave
    audio_request => audio_request,
    data => "0000000000000000",
	tone => tone_out,
	stop => stop,
    -- Audio interface signals
    AUD_ADCLRCK  => AUD_ADCLRCK,
    AUD_ADCDAT   => AUD_ADCDAT,
    AUD_DACLRCK  => AUD_DACLRCK,
    AUD_DACDAT   => AUD_DACDAT,
    AUD_BCLK     => AUD_BCLK
  );

process (CLk)
  begin
    if rising_edge(CLk) then
      audio_clock <= audio_clock + "1";
    end if;
  end process;

process (clk)
begin
if rising_edge (clk) then
	if reset_n = '0' then
		tone <= (others => '0');
	else
		if chipSelect = '1' then
			if address = '0' then
				if write = '1' then
					tone <= writedata;
				end if;
			end if;
		end if;
	end if;
end if;
end process;


process (clk)
begin
if rising_edge (clk) then
	if reset_n = '0' then
		counter<= (others => '0');
	else
		counter <= counter +1;
	end if;
end if;
end process;

process (clk)
begin
if rising_edge (clk) then
	if reset_n = '0' then
		stop <= '0';
	else
		if (write = '1' and chipSelect = '1')then
			stop <= '0';
		elsif (stopCount = "111") then
			stop <= '1';
		end if;
	end if;
end if;
end process;

process (counter (24))
begin
if rising_edge (counter (24)) then
	if reset_n = '0' then
		counter_tone <= (others => '0');
	else
		if (counter_tone = "11") then
			stopCount <= stopCount +1;
		end if;
		counter_tone <= counter_tone +1;
	end if;
end if;
end process;

with tone select tone_out <=
tone_out1 when x"0000",
tone_out2 when x"0001",
tone_out3 when x"0002",
tone_out0 when others;

with counter_tone select tone_out0 <= 
    "0000" when "00",
    "0001" when "01",
    "0010" when "10",
    "0011" when others;

with counter_tone select tone_out1 <= 
    "0001" when "00",
    "0001" when "01",
    "0010" when "10",
    "0001" when others;
with counter_tone select tone_out2 <= 
    "0010" when "00",
    "0011" when "01",
    "0110" when "10",
    "0011" when others;
with counter_tone select tone_out3 <= 
    "0000" when "00",
    "0001" when "01",
    "0000" when "10",
    "0011" when others;

end rtl;
