library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity man_register is
  port
  (
    clk   : in std_logic;
    reset_n : in std_logic;
    write  : in std_logic;
    property : in std_logic_vector(2 downto 0);
    value : in std_logic_vector(15 downto 0);

    x : out integer;
    y : out integer;
    dir : out integer
  );
end man_register;

architecture rtl of man_register is
    signal x_val : unsigned(9 downto 0) := to_unsigned(230, 10);
    signal y_val : unsigned(9 downto 0) := to_unsigned(0, 10);
    signal dir_val : unsigned(1 downto 0) := to_unsigned(0, 2);
begin
  x <= to_integer(x_val);
  y <= to_integer(y_val);
  dir <= to_integer(dir_val);

  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        x_val <= (others => '0');
        y_val <= (others => '0');
        dir_val <= (others => '0');
      else
        if write = '1' then
          case property is
             when "000" => x_val       <= unsigned(value(9 downto 0));
             when "001" => y_val       <= unsigned(value(9 downto 0));
             when "010" => dir_val    <= unsigned(value(1 downto 0));
             when others => 
              x_val <= x_val;
          end case;
        end if;
      end if;
    end if;
  end process;
end rtl;
