library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity inputController is

port(
clk		 : in	std_logic;
reset_n : in std_logic;
chipSelect: in std_logic;
read: in std_logic;
address : in std_logic;
read_data: out unsigned (15 downto 0);
GPIOinput	 : in	std_logic_vector (1 downto 0)
);

end entity;

architecture rtl of inputController is 
	signal readdata : unsigned (15 downto 0);
	signal output : unsigned (1 downto 0);
	component rotaryController is port(
		clk		 : in	std_logic;
		input	 : in	std_logic_vector (1 downto 0);
		reset_n	 : in	std_logic;
		output	 : out	unsigned (1 downto 0)
	);

end component;
begin
	v1: rotaryController port map (
	clk,
	GPIOinput,
	reset_n,
	output
	);

	process (clk)
	begin
		if rising_edge (clk) then
			if reset_n = '0' then
				read_data <= (others => '0');
			else
				if chipSelect = '1' then
					if address = '0' then
						if read = '1' then
							read_data <= UNSIGNED ("00000000000000"  & OUTPUT); -- readdata;
						end if;
					end if;
				end if;
			end if;
		end if;
	end process;
end rtl;